/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.logsetup;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ServerLogManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.views.logsetup.ConfigurationLogSetUpPanel;
import com.metamatrix.console.ui.views.logsetup.ConfigurationLogSetUpPanelController;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SystemLogSetUpPanel
extends JPanel
implements WorkspacePanel,
ConfigurationLogSetUpPanelController,
NotifyOnExitConsole,
Refreshable {
    public static final int NUM_CONFIGURATIONS = 2;
    public static final int NEXT_STARTUP_INDEX = 0;
    public static final int STARTUP_INDEX = 1;
    public static final String[] CONFIGURATION_NAMES = new String[]{"Next Startup", "Startup"};
    public static final Icon[] CONFIGURATION_ICONS = new Icon[]{IconFactory.getIconForImageFile("startup_small.gif"), IconFactory.getIconForImageFile("NextStartUp_small.gif")};
    private ServerLogManager manager;
    private boolean canModify;
    private ConnectionInfo connection;
    private boolean isInitialized = false;
    private String[] messageLevelNames;
    private Collection allContexts;
    private ConfigurationLogSetUpPanel[] configPanels;
    private JTabbedPane tabbedPane;
    private List actions = new ArrayList(1);

    public SystemLogSetUpPanel(ServerLogManager mgr, boolean canMod, ConnectionInfo conn) {
        this.manager = mgr;
        this.canModify = canMod;
        this.connection = conn;
        this.isInitialized = this.init();
    }

    private boolean init() {
        boolean initialized = true;
        try {
            this.messageLevelNames = this.manager.getMessageLevelDisplayNames();
        }
        catch (Exception ex) {
            LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error retrieving log message levels");
            ExceptionUtility.showMessage("Error retrieving log message levels", ex);
            initialized = false;
        }
        if (initialized) {
            this.configPanels = new ConfigurationLogSetUpPanel[2];
            for (int i = 0; i < 2; ++i) {
                if (!initialized) continue;
                this.allContexts = null;
                try {
                    this.allContexts = this.manager.getAllContexts();
                }
                catch (Exception ex) {
                    LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error retrieving logging contexts");
                    ExceptionUtility.showMessage("Error retrieving logging contexts", ex);
                    initialized = false;
                    break;
                }
                if (!initialized) continue;
                Collection selectedContexts = null;
                try {
                    selectedContexts = this.manager.getContextsForConfigurationIndex(i);
                }
                catch (Exception ex) {
                    LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error retrieving logging contexts for configuration");
                    ExceptionUtility.showMessage("Error retrieving logging contexts", ex);
                    initialized = false;
                    break;
                }
                if (!initialized) continue;
                Collection availableContexts = this.allContexts;
                int messageLevel = -1;
                try {
                    messageLevel = this.manager.getLoggingLevelForConfigurationIndex(i);
                }
                catch (Exception ex) {
                    LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error retrieving logging level for configuration");
                    ExceptionUtility.showMessage("Error retrieving logging level", ex);
                    initialized = false;
                    break;
                }
                if (!initialized) continue;
                String[] otherSourceNames = new String[CONFIGURATION_NAMES.length - 1];
                Icon[] otherSourceIcons = new Icon[CONFIGURATION_NAMES.length - 1];
                int outputLoc = -1;
                for (int j = 0; j < CONFIGURATION_NAMES.length; ++j) {
                    if (j == i) continue;
                    otherSourceNames[++outputLoc] = CONFIGURATION_NAMES[j];
                    otherSourceIcons[outputLoc] = CONFIGURATION_ICONS[j];
                }
                boolean modifiable = this.canModify && i != 1;
                this.configPanels[i] = new ConfigurationLogSetUpPanel(CONFIGURATION_NAMES[i], modifiable, this, otherSourceNames, otherSourceIcons, this.messageLevelNames, messageLevel, new ArrayList(availableContexts), new ArrayList(selectedContexts));
            }
        }
        if (initialized) {
            this.tabbedPane = new JTabbedPane();
            for (int i = 0; i < 2; ++i) {
                this.tabbedPane.addTab(CONFIGURATION_NAMES[i], CONFIGURATION_ICONS[i], this.configPanels[i]);
            }
            this.setLayout(new GridLayout(1, 1));
            this.add(this.tabbedPane);
        }
        return initialized;
    }

    @Override
    public String getTitle() {
        return "Log Settings";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public List resume() {
        if (!this.isInitialized) {
            this.isInitialized = this.init();
        }
        return this.actions;
    }

    @Override
    public void refresh() {
        String configNames = "";
        if (this.configPanels[0].havePendingChanges()) {
            configNames = configNames + CONFIGURATION_NAMES[0] + " Configuration";
        }
        boolean continuing = true;
        if (configNames.length() > 0) {
            String msg = "Refresh will cause loss of pending changes to " + configNames + ".\n\nProceed with refresh?";
            int response = DialogUtility.displayYesNoDialog(ConsoleMainFrame.getInstance(), "Changes Pending", msg);
            switch (response) {
                case 0: {
                    break;
                }
                case 1: {
                    continuing = false;
                }
            }
        }
        if (continuing) {
            int index = 0;
            Collection selectedContexts = null;
            try {
                selectedContexts = this.manager.getContextsForConfigurationIndex(index);
            }
            catch (Exception ex) {
                LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error retrieving logging contexts for configuration");
                ExceptionUtility.showMessage("Error retrieving logging contexts", ex);
                continuing = false;
            }
            if (continuing) {
                Collection availableContexts = this.allContexts;
                int messageLevel = -1;
                try {
                    messageLevel = this.manager.getLoggingLevelForConfigurationIndex(index);
                }
                catch (Exception ex) {
                    LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error retrieving logging level for configuration");
                    ExceptionUtility.showMessage("Error retrieving logging level", ex);
                    continuing = false;
                }
                if (continuing) {
                    this.configPanels[index].setNewValues(new ArrayList(availableContexts), new ArrayList(selectedContexts), messageLevel);
                }
            }
        }
    }

    private int indexOfConfigurationName(String configName) {
        return StaticQuickSorter.unsortedStringArrayIndex(CONFIGURATION_NAMES, configName);
    }

    @Override
    public void applyButtonStateChanged(String configName, boolean newState) {
        this.indexOfConfigurationName(configName);
        for (int i = 0; i < 2; ++i) {
            if (CONFIGURATION_NAMES[i].equals(configName) || this.configPanels == null || this.configPanels.length < i + 1 || this.configPanels[i] == null) continue;
            this.configPanels[i].setCopyButtonState(configName, !newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyButtonPressed(String configName, int messageLevel, List messageContexts) {
        int index = this.indexOfConfigurationName(configName);
        Set allContexts = null;
        Collection selectedContexts = null;
        int newMessageLevel = -1;
        boolean continuing = true;
        try {
            StaticUtilities.startWait();
            this.manager.setContextsForConfigurationIndex(index, messageContexts);
            this.manager.setLoggingLevelForConfigurationIndex(index, messageLevel);
            allContexts = this.manager.getAllContexts();
            selectedContexts = this.manager.getContextsForConfigurationIndex(index);
            newMessageLevel = this.manager.getLoggingLevelForConfigurationIndex(index);
        }
        catch (Exception ex) {
            LogManager.logError((String)"LOG_SETTINGS", (Throwable)ex, (String)"Error applying log settings changes.");
            ExceptionUtility.showMessage("Error applying log settings changes", ex);
            continuing = false;
        }
        finally {
            StaticUtilities.endWait();
        }
        if (continuing) {
            Set availableContexts = allContexts;
            this.configPanels[index].setNewValues(new ArrayList(availableContexts), new ArrayList(selectedContexts), newMessageLevel);
        }
    }

    @Override
    public List getContextsFrom(String sourceName) {
        List messageContexts = null;
        int index = this.indexOfConfigurationName(sourceName);
        if (index < 0) {
            throw new RuntimeException("Error in SystemLogSetUpPanel.getContextsFrom(), unknown source name of " + sourceName);
        }
        messageContexts = this.configPanels[index].getSelectedMessageContexts();
        return messageContexts;
    }

    @Override
    public int getMessageLevelFrom(String sourceName) {
        int messageLevel = -1;
        int index = this.indexOfConfigurationName(sourceName);
        if (index < 0) {
            throw new RuntimeException("Error in SystemLogSetUpPanel.getMessageLevelFrom(), unknown source name of " + sourceName);
        }
        messageLevel = this.configPanels[index].getSelectedMessageLevel();
        return messageLevel;
    }

    @Override
    public boolean havePendingChanges() {
        boolean havePending = false;
        int i = 0;
        while (!havePending && i < 2) {
            havePending = this.configPanels[i].havePendingChanges();
            if (havePending) continue;
            ++i;
        }
        return havePending;
    }

    @Override
    public boolean finishUp() {
        boolean stayingHere = false;
        int currentTab = this.tabbedPane.getSelectedIndex();
        if (this.configPanels[currentTab].havePendingChanges()) {
            String msg = "Save changes to " + CONFIGURATION_NAMES[currentTab] + " configuration log settings?";
            int response = DialogUtility.showPendingChangesDialog(msg, this.manager.getConnection().getURL(), this.manager.getConnection().getUser());
            switch (response) {
                case 0: {
                    this.configPanels[currentTab].doApply();
                    stayingHere = false;
                    break;
                }
                case 1: {
                    this.configPanels[currentTab].doReset();
                    stayingHere = false;
                    break;
                }
                case 2: {
                    stayingHere = true;
                }
            }
        }
        block10: for (int i = 0; !stayingHere && i < 2; ++i) {
            if (!this.configPanels[i].havePendingChanges()) continue;
            this.tabbedPane.setSelectedIndex(i);
            String msg = "Save changes to " + CONFIGURATION_NAMES[i] + " configuration log settings?";
            int response = DialogUtility.showPendingChangesDialog(msg, this.manager.getConnection().getURL(), this.manager.getConnection().getUser());
            switch (response) {
                case 0: {
                    this.configPanels[i].doApply();
                    stayingHere = false;
                    continue block10;
                }
                case 1: {
                    this.configPanels[i].doReset();
                    stayingHere = false;
                    continue block10;
                }
                case 2: {
                    stayingHere = true;
                }
            }
        }
        return !stayingHere;
    }
}

