/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.properties;

import com.metamatrix.common.config.model.PropertyValidations;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.ObjectDefinitionDisplayNameComparator;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.console.models.PropertiesManager;
import com.metamatrix.console.models.PropertyDetail;
import com.metamatrix.console.ui.views.properties.ConsolePropertyObjectId;
import com.metamatrix.console.ui.views.properties.FakeUserTransaction;
import com.metamatrix.console.ui.views.properties.PropertyFilter;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ConsolePropertiedEditor
implements PropertiedObjectEditor,
ChangeListener {
    public static final short NSUCONFIGINDICATOR = 2;
    public static final short STARTUPCONFIGINDICATOR = 3;
    private Collection allPropDefns;
    private Collection allNSUPropDefns;
    private Collection allSUPropDefns;
    private ArrayList currentPropDefns = new ArrayList();
    private Properties oraginalProperties;
    private Properties allProperties;
    private Properties oldNSUProperties;
    private Properties nsuProperties;
    private Properties currentProperties = new Properties();
    private String propertyValue;
    private HashMap objectIdMap;
    private HashMap propHM;
    private HashMap defnHM;
    private HashMap propChangeHM = new HashMap();
    private String currentTabName;
    private String tabName;
    private EventListenerList listeners = new EventListenerList();
    private boolean buttonState;
    private PropertiesManager manager;
    private ObjectDefinitionDisplayNameComparator comp = new ObjectDefinitionDisplayNameComparator();
    private PropertyValidations validations = new PropertyValidations();
    public static final boolean DEFAULT_READ_ONLY_PRIVILEGE = false;

    public ConsolePropertiedEditor(PropertiesManager mgr) {
        this.manager = mgr;
        this.init();
    }

    private void init() {
        this.oldNSUProperties = new Properties();
        this.getPropertiesAndDefn();
        this.allPropDefns = this.allNSUPropDefns;
        this.allProperties = this.nsuProperties;
    }

    public ConsolePropertyObjectId getPropertyObjectId(String gName, PropertyFilter pFilter) {
        if (this.objectIdMap == null) {
            this.objectIdMap = new HashMap();
        }
        if (!this.objectIdMap.containsKey(gName)) {
            this.objectIdMap.put(gName, new ConsolePropertyObjectId(gName, pFilter));
        }
        return (ConsolePropertyObjectId)this.objectIdMap.get(gName);
    }

    public HashMap getChangeHM() {
        return this.propChangeHM;
    }

    String getCurrentTitle() {
        return this.currentTabName;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int iSelected = ((JTabbedPane)e.getSource()).getSelectedIndex();
        this.currentTabName = ((JTabbedPane)e.getSource()).getTitleAt(iSelected);
        if (this.currentTabName == "Next Startup") {
            if (this.allNSUPropDefns == null) {
                this.getNSUDefn();
                this.getNSUProperty();
            }
            this.allPropDefns = this.allNSUPropDefns;
            this.allProperties = this.nsuProperties;
        } else if (this.currentTabName == "Startup") {
            if (this.allSUPropDefns == null) {
                this.getSUDefn();
                this.getSUProperty();
            }
            this.allPropDefns = this.allSUPropDefns;
            this.allProperties = this.oraginalProperties;
        }
        if (this.propHM != null) {
            this.propHM.clear();
        }
    }

    private void getPropertiesAndDefn() {
        this.getNSUDefn();
        this.getNSUProperty();
    }

    private void getNSUDefn() {
        try {
            this.allNSUPropDefns = this.manager.getNextStartUpDefn();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed getting next startup defination", ex);
            LogManager.logError((String)"PROPERTIES", (Throwable)ex, (String)"Error creating nextStartUp propertyDefination");
        }
        if (this.allNSUPropDefns == null) {
            this.allNSUPropDefns = new ArrayList(0);
        }
    }

    private void getNSUProperty() {
        try {
            Properties p = this.manager.getNSUProperties();
            this.nsuProperties = new Properties();
            this.nsuProperties.putAll((Map<?, ?>)p);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed getting next startup properties", ex);
            LogManager.logError((String)"PROPERTIES", (Throwable)ex, (String)"Error creating nextStartUp property");
        }
        if (this.nsuProperties != null) {
            this.oldNSUProperties.putAll((Map<?, ?>)this.nsuProperties);
        }
        this.allProperties = this.nsuProperties;
    }

    public Properties getNSUProperties() {
        return this.nsuProperties;
    }

    public Collection getPropDefn() {
        return this.allNSUPropDefns;
    }

    private void getSUDefn() {
        try {
            this.allSUPropDefns = this.manager.getStartUpDefn();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed getting start up definition", ex);
            LogManager.logError((String)"PROPERTIES", (Throwable)ex, (String)"Error creating start up property definition");
        }
        if (this.allSUPropDefns == null) {
            this.allSUPropDefns = new ArrayList(0);
        }
        this.allPropDefns = this.allSUPropDefns;
    }

    private void getSUProperty() {
        try {
            this.oraginalProperties = this.manager.getSUProperties();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed getting start up properties", ex);
            LogManager.logError((String)"PROPERTIES", (Throwable)ex, (String)"Error creating start up property");
        }
        if (this.oraginalProperties != null) {
            this.allProperties = this.oraginalProperties;
        }
    }

    boolean getButtonState() {
        return this.buttonState;
    }

    void setChangePropValue(String name, HashMap cValue) {
        HashMap changeValue = cValue;
        Properties p = new Properties();
        p.clear();
        this.tabName = name != null ? name : this.currentTabName;
        if (this.tabName == "Next Startup") {
            this.oldNSUProperties.putAll((Map<?, ?>)this.nsuProperties);
            this.nsuProperties.putAll((Map<?, ?>)changeValue);
            if (name == null) {
                this.allProperties = this.nsuProperties;
            }
            p.putAll((Map<?, ?>)changeValue);
            this.saveProperty(p, 2);
        }
        if (this.propHM != null) {
            this.propHM.clear();
        }
    }

    void resetPropValue() {
        if (this.currentTabName == "Next Startup") {
            this.getNSUProperty();
            this.allProperties = this.nsuProperties;
        }
        if (this.propHM != null) {
            this.propHM.clear();
        }
    }

    private void saveProperty(Properties p, int i) {
        Iterator<Object> iter = p.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.manager.setProperty(name, (String)p.get(name), i);
            }
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("Failed saving property", ex);
            LogManager.logError((String)"PROPERTIES", (Throwable)ex, (String)"Error creating save property");
        }
    }

    public void setGroupDefn(String groupName, List groupPropDefns) {
        if (this.defnHM == null) {
            this.defnHM = new HashMap();
        }
        if (groupPropDefns != null) {
            this.defnHM.put(groupName, groupPropDefns);
        } else {
            this.defnHM.put(groupName, new ArrayList(0));
        }
    }

    private void filterPropDf(String gName) {
        Object propValue = null;
        Properties groupProperties = new Properties();
        if (this.propHM == null) {
            this.propHM = new HashMap();
        }
        if (gName != null) {
            String groupName = gName;
            if (this.propHM.get(groupName) == null) {
                groupProperties.clear();
                List pd = (List)this.defnHM.get(groupName);
                if (pd != null) {
                    ListIterator PropDefnsIter = pd.listIterator();
                    while (PropDefnsIter.hasNext()) {
                        PropertyDefinition propDefn = (PropertyDefinition)PropDefnsIter.next();
                        String propName = propDefn.getName();
                        propValue = this.allProperties.get(propName);
                        if (propValue == null) continue;
                        groupProperties.put(propName, propValue);
                    }
                }
                this.propHM.put(groupName, groupProperties);
            }
            this.currentPropDefns = (ArrayList)this.defnHM.get(groupName);
            this.currentProperties = (Properties)this.propHM.get(groupName);
        }
    }

    public List getNSUDefns(List propDefnsList) {
        return this.getDefnsFromAll(this.allNSUPropDefns, propDefnsList);
    }

    public List getSUDefns(List propDefnsList) {
        return this.getDefnsFromAll(this.allSUPropDefns, propDefnsList);
    }

    private List getDefnsFromAll(Collection allDefns, List defns) {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        ListIterator iter = defns.listIterator();
        block0: while (iter.hasNext()) {
            PropertyDefinition pDefn = (PropertyDefinition)iter.next();
            for (PropertyDefinition pDefn1 : allDefns) {
                if (!pDefn1.getDisplayName().equalsIgnoreCase(pDefn.getDisplayName())) continue;
                result.add(pDefn1);
                continue block0;
            }
        }
        return result;
    }

    public void refreshData() {
        if (this.currentTabName == "Next Startup") {
            this.getNSUProperty();
        } else if (this.currentTabName == "Startup") {
            this.getSUProperty();
        }
        if (this.propHM != null) {
            this.propHM = null;
        }
    }

    public List getPropertyDefinitions(PropertiedObject obj) {
        ConsolePropertyObjectId objId = (ConsolePropertyObjectId)obj;
        if (!objId.getGroupName().equals("System Property")) {
            this.filterPropDf(objId.getGroupName());
            if (this.currentPropDefns != null) {
                objId.setGroupProperties(this.currentProperties);
                objId.setGroupPropDefn(this.currentPropDefns);
            }
        } else {
            objId.setGroupProperties(this.allProperties);
            if (this.allPropDefns == null) {
                return new ArrayList(0);
            }
            objId.setGroupPropDefn(this.allPropDefns);
        }
        List defns = objId.getFilteredPropDefn();
        Collections.sort(defns, this.comp);
        return defns;
    }

    public boolean isReadOnly(PropertiedObject obj) throws UnsupportedOperationException {
        return false;
    }

    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        Properties currentProperty;
        Object propValue = null;
        ConsolePropertyObjectId objId = (ConsolePropertyObjectId)obj;
        PropertyDefinition defn = def;
        if (objId.getGroupProperties() != null && defn != null && (propValue = (currentProperty = objId.getGroupProperties()).get(defn.getName())) != null && defn.getPropertyType().equals((Object)PropertyType.BOOLEAN)) {
            propValue = new Boolean(currentProperty.get(defn.getName()).toString());
        }
        return propValue;
    }

    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        if (value instanceof String) {
            try {
                this.validations.isPropertyValid(def.getName(), (String)value);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public String getPropertyValue() {
        PropertyDetail pDetail = new PropertyDetail();
        pDetail.setDisplayName(this.propertyValue);
        return this.propertyValue;
    }

    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        if (value != null) {
            this.propChangeHM.put(def.getName(), value.toString());
        } else {
            Object defaultValue = def.getDefaultValue();
            String strValue = defaultValue == null ? "" : defaultValue.toString();
            this.propChangeHM.put(def.getName(), strValue);
        }
    }

    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        Assertion.isNotNull((Object)def, (String)"The PropertyDefinition reference may not be null");
        return def.getAllowedValues();
    }

    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) throws UnsupportedOperationException {
        return false;
    }

    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
    }

    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
    }

    public void reset(PropertiedObject obj) {
    }

    public UserTransaction createReadTransaction() {
        return new FakeUserTransaction();
    }

    public UserTransaction createWriteTransaction() {
        return new FakeUserTransaction();
    }

    public UserTransaction createWriteTransaction(Object p0) {
        return new FakeUserTransaction();
    }

    public PropertyAccessPolicy getPolicy() throws UnsupportedOperationException {
        return null;
    }

    public void setPolicy(PropertyAccessPolicy policy) {
    }

    public void addChangeListener(ChangeListener listener) {
        this.getListeners().add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getListeners().remove(ChangeListener.class, listener);
    }

    public EventListenerList getListeners() {
        return this.listeners;
    }

    protected void fireChangedEvent(ChangeEvent e) {
        Object[] listeners = this.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

