/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.properties;

import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.ui.views.properties.PropertyFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ConsolePropertyObjectId
implements PropertiedObject {
    public static final String ALL_SYS_PROPS = "System Property";
    private Properties groupProperties;
    private Collection propDefns;
    private List currentPropDefns = new ArrayList();
    private PropertyFilter propFilter;
    private HashMap defnHM;
    private HashMap descriptionHM;
    private String groupName;

    public ConsolePropertyObjectId(String gn, PropertyFilter pFilter) {
        this.groupName = gn;
        this.propFilter = pFilter;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public PropertyFilter getPropertyFilter() {
        return this.propFilter;
    }

    public void setGroupProperties(Properties gp) {
        this.groupProperties = gp;
    }

    public void setGroupPropDefn(Collection pd) {
        this.propDefns = pd;
        Iterator iter = this.propDefns.iterator();
        while (iter.hasNext()) {
            iter.next();
        }
    }

    public Properties getGroupProperties() {
        return this.groupProperties;
    }

    public List getFilteredPropDefn() {
        this.defnHM = new HashMap();
        this.descriptionHM = new HashMap();
        this.filterPropDefns();
        for (PropertyDefinition pd : this.currentPropDefns) {
            this.defnHM.put(pd.getDisplayName(), pd.getName());
            this.descriptionHM.put(pd.getName(), pd.getShortDescription());
        }
        return this.currentPropDefns;
    }

    public HashMap getDotName() {
        return this.defnHM;
    }

    public HashMap getDescriptionHM() {
        return this.descriptionHM;
    }

    private void filterPropDefns() {
        if (this.propDefns != null) {
            this.currentPropDefns.clear();
            if (this.isAllProperties()) {
                this.currentPropDefns.addAll(this.propDefns);
            } else {
                ArrayList defAL = this.filterBEpropDefns(this.propDefns);
                if (!defAL.isEmpty()) {
                    this.currentPropDefns = this.filterMRpropDefns(defAL);
                }
            }
        }
    }

    private ArrayList filterBEpropDefns(Collection pd) {
        ArrayList<PropertyDefinition> propDefnsBE = new ArrayList<PropertyDefinition>();
        if (this.isBasicProperties()) {
            for (PropertyDefinition propDefn : pd) {
                if (propDefn.isExpert() || propDefnsBE.contains(propDefn)) continue;
                propDefnsBE.add(propDefn);
            }
            return propDefnsBE;
        }
        if (this.isExpertProperties()) {
            for (PropertyDefinition propDefn : pd) {
                if (!propDefn.isExpert() || propDefnsBE.contains(propDefn)) continue;
                propDefnsBE.add(propDefn);
            }
            return propDefnsBE;
        }
        if (this.isBothBEProperties()) {
            for (PropertyDefinition propDefn : pd) {
                if (propDefnsBE.contains(propDefn)) continue;
                propDefnsBE.add(propDefn);
            }
            return propDefnsBE;
        }
        return propDefnsBE;
    }

    private List filterMRpropDefns(List pdmr) {
        if (!this.propFilter.isMRBEnable()) {
            return pdmr;
        }
        ArrayList<PropertyDefinition> propDefnsMR = new ArrayList<PropertyDefinition>();
        if (this.isModifiableProperties()) {
            for (PropertyDefinition propDefn : pdmr) {
                if (!propDefn.isModifiable() || propDefnsMR.contains(propDefn)) continue;
                propDefnsMR.add(propDefn);
            }
            return propDefnsMR;
        }
        if (this.isReadOnlyProperties()) {
            for (PropertyDefinition propDefn : pdmr) {
                if (propDefn.isModifiable() || propDefnsMR.contains(propDefn)) continue;
                propDefnsMR.add(propDefn);
            }
            return propDefnsMR;
        }
        if (this.isBothMRProperties()) {
            for (PropertyDefinition propDefn : pdmr) {
                if (propDefnsMR.contains(propDefn)) continue;
                propDefnsMR.add(propDefn);
            }
            return propDefnsMR;
        }
        return propDefnsMR;
    }

    public String getGroupNameId() {
        return this.propFilter.getGroupName();
    }

    public boolean isAllProperties() {
        return this.propFilter.isAllProperties();
    }

    public boolean isBasicProperties() {
        return this.propFilter.isBasicProperties();
    }

    public boolean isExpertProperties() {
        return this.propFilter.isExpertProperties();
    }

    public boolean isBothBEProperties() {
        return this.propFilter.isBothBEProperties();
    }

    public boolean isModifiableProperties() {
        return this.propFilter.isModifiableProperties();
    }

    public boolean isReadOnlyProperties() {
        return this.propFilter.isReadOnlyProperties();
    }

    public boolean isBothMRProperties() {
        return this.propFilter.isBothMRProperties();
    }

    public boolean isReadOnly() {
        return true;
    }
}

