/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.properties;

import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.views.properties.ConsolePropertiedEditor;
import com.metamatrix.console.ui.views.properties.ConsolePropertyObjectId;
import com.metamatrix.console.ui.views.properties.DefaultComponentSelector;
import com.metamatrix.console.ui.views.properties.PropertyDetailPanel;
import com.metamatrix.console.ui.views.properties.PropertyFilter;
import com.metamatrix.console.ui.views.properties.PropertyFilterPanel;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import com.metamatrix.toolbox.ui.widget.property.PropertySelectionEvent;
import com.metamatrix.toolbox.ui.widget.property.PropertySelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class NextStartupPanel
extends DefaultComponentSelector
implements ActionListener,
NotifyOnExitConsole,
PropertyChangeListener {
    private String title;
    private Icon icon;
    private JPanel pnlOuter;
    private PropertiedObjectPanel propObjPanel;
    private ConsolePropertiedEditor propEditor;
    private ConsolePropertyObjectId objectedId;
    private PropertyDetailPanel detailPanel;
    private ButtonWidget applyJB;
    private ButtonWidget resetJB;
    private JSplitPane propSplitPane;
    private PropertyFilterPanel parent;
    private boolean buttonState = false;
    private HashMap changeHM = null;
    private HashMap propValueMap = new HashMap();
    private ArrayList changedValue = new ArrayList();
    private ConnectionInfo connection;

    public NextStartupPanel(String title, Icon icon, PropertyFilterPanel parent, ConnectionInfo conn) {
        this.title = title;
        this.icon = icon;
        this.parent = parent;
        this.connection = conn;
    }

    @Override
    public void createComponent() {
        this.setLayout(new BorderLayout());
        this.pnlOuter = new JPanel(new BorderLayout());
        this.applyJB = new ButtonWidget("  Apply  ");
        this.applyJB.setName("SystemProperties." + this.title);
        this.applyJB.setEnabled(this.buttonState);
        this.resetJB = new ButtonWidget("  Reset  ");
        this.resetJB.setName("SystemProperties." + this.title);
        this.resetJB.setEnabled(this.buttonState);
        JPanel pnlUp = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JPanel bpanel = new JPanel(new GridLayout(1, 2, 20, 0));
        bpanel.add(this.applyJB);
        bpanel.add(this.resetJB);
        buttonPanel.add(bpanel);
        this.detailPanel = new PropertyDetailPanel(this.title);
        if (this.getObjectPanel() != null) {
            PropertiedObjectPanel objectPanel = this.getObjectPanel();
            objectPanel.createComponent();
            pnlUp.add((Component)objectPanel, "Center");
            if (this.getTitle().equals("Next Startup")) {
                pnlUp.add((Component)buttonPanel, "South");
            }
            this.propSplitPane = new Splitter(0, true, pnlUp, this.detailPanel);
            this.pnlOuter.add((Component)this.propSplitPane, "Center");
            this.add((Component)this.pnlOuter, "Center");
            this.applyJB.addActionListener(this);
            this.resetJB.addActionListener(this);
        }
    }

    public ConsolePropertiedEditor getPropertiedEditor() {
        return this.propEditor;
    }

    public void setPropertiedEditor(ConsolePropertiedEditor pEditor) {
        this.propEditor = pEditor;
        Encryptor encryptor = ModelManager.getConfigurationManager(this.connection).getEncryptor();
        this.propObjPanel = new PropertiedObjectPanel(this.propEditor, encryptor);
        this.propObjPanel.addPropertyChangeListener(this);
        this.propObjPanel.setShowExpertProperties(true);
        this.propObjPanel.setShowHiddenProperties(true);
        if (this.getTitle().equals("Startup")) {
            this.propObjPanel.setReadOnlyForced(true);
        }
        if (!this.parent.isModifyServerProperties()) {
            this.propObjPanel.setReadOnlyForced(true);
        }
        this.createComponent();
    }

    @Override
    public void propertyChange(PropertyChangeEvent theEvent) {
        boolean propsDifferent = false;
        String eventProp = theEvent.getPropertyName();
        if (this.propValueMap.containsKey(eventProp)) {
            Object current;
            Object original = this.propValueMap.get(eventProp);
            boolean bl = propsDifferent = !this.equivalent(original, current = theEvent.getNewValue());
            if (!propsDifferent) {
                this.changedValue.remove(eventProp);
            } else if (!this.changedValue.contains(eventProp)) {
                this.changedValue.add(eventProp);
            }
        } else {
            Object current;
            Object original = theEvent.getOldValue();
            if (!this.equivalent(original, current = theEvent.getNewValue())) {
                this.propValueMap.put(eventProp, theEvent.getOldValue());
                this.changedValue.add(eventProp);
            }
        }
        if (this.changedValue.size() > 0) {
            this.applyJB.setEnabled(true);
            this.resetJB.setEnabled(true);
        } else {
            this.applyJB.setEnabled(false);
            this.resetJB.setEnabled(false);
        }
    }

    private boolean equivalent(Object theValue, Object theOtherValue) {
        boolean same = theValue == null ? (theOtherValue == null ? true : theOtherValue instanceof String && ((String)theOtherValue).length() == 0) : (theOtherValue == null ? theValue instanceof String && ((String)theValue).length() == 0 : theValue.equals(theOtherValue));
        return same;
    }

    @Override
    public void postRealize() {
        this.propSplitPane.setDividerLocation(0.8);
    }

    private PropertiedObjectPanel getObjectPanel() {
        return this.propObjPanel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    ButtonWidget getApplyButton() {
        return this.applyJB;
    }

    ButtonWidget getResetButton() {
        return this.resetJB;
    }

    public void setGroupName(String gName, Object propDef, PropertyFilter pFilter) {
        this.objectedId = this.propEditor.getPropertyObjectId(gName, pFilter);
        this.propEditor.setGroupDefn(gName, (List)propDef);
        this.propObjPanel.setNameColumnHeaderWidth(0);
        this.propObjPanel.setPropertiedObject(this.objectedId);
        this.propObjPanel.setColumnHeaderNames("Property Name", "Property Value");
        this.processDetailPanel();
        this.propObjPanel.addPropertySelectionListener(new PropertySelectionListener(){

            @Override
            public void propertySelected(PropertySelectionEvent event) {
                NextStartupPanel.this.processDetailPanel(event.getPropertyDefinition());
            }
        });
        this.propObjPanel.setNameColumnHeaderWidth(0);
        this.propObjPanel.refreshDisplay();
        this.validate();
        this.repaint();
    }

    private void doChange() {
        if (this.getPropertiedEditor().getChangeHM() != null) {
            this.changeHM = this.getPropertiedEditor().getChangeHM();
        }
        this.propEditor.setChangePropValue(null, this.changeHM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("  Apply  ")) {
            try {
                StaticUtilities.startWait(this);
                this.doChange();
                this.propValueMap.clear();
                this.changedValue.clear();
            }
            catch (Exception exc) {
            }
            finally {
                StaticUtilities.endWait(this);
            }
            this.applyJB.setEnabled(false);
            this.resetJB.setEnabled(false);
        } else if (e.getActionCommand().equals("  Reset  ")) {
            try {
                StaticUtilities.startWait(this);
                this.propEditor.resetPropValue();
                this.applyJB.setEnabled(false);
                this.resetJB.setEnabled(false);
                this.parent.refresh(this.title);
            }
            catch (Exception exception) {
            }
            finally {
                StaticUtilities.endWait(this);
            }
        }
        this.buttonState = false;
        this.getPropertiedEditor().getChangeHM().clear();
    }

    private void processDetailPanel() {
        this.detailPanel.setDisplayName(" ");
        this.detailPanel.setNSUPropertyValue(" ");
        this.detailPanel.setIdentifierField(" ");
        this.detailPanel.setDescriptionName(" ");
    }

    private void processDetailPanel(PropertyDefinition propDef) {
        Properties propNSU = this.propEditor.getNSUProperties();
        String dispPropName = "";
        dispPropName = propDef.getName();
        String dn = (String)this.objectedId.getDescriptionHM().get(dispPropName);
        String nsuValue = propNSU.get(dispPropName) != null ? propNSU.get(dispPropName).toString() : "";
        this.detailPanel.setDisplayName(propDef.getDisplayName());
        this.detailPanel.setIdentifierField(dispPropName);
        this.detailPanel.setDescriptionName(dn);
        this.detailPanel.setNSUPropertyValue(nsuValue);
        this.setSelectedComponent(this.detailPanel);
    }

    @Override
    public boolean havePendingChanges() {
        boolean pending = false;
        if (this.applyJB != null) {
            pending = this.applyJB.isEnabled();
        }
        return pending;
    }

    @Override
    public boolean finishUp() {
        boolean stayingHere = false;
        String msg = "Save changes to " + this.title + " configuration?";
        int response = DialogUtility.showPendingChangesDialog(msg, this.connection.getURL(), this.connection.getUser());
        switch (response) {
            case 0: {
                if (this.applyJB.isEnabled() && this.getPropertiedEditor().getChangeHM() != null) {
                    this.changeHM = this.getPropertiedEditor().getChangeHM();
                }
                this.propEditor.setChangePropValue(this.title, this.changeHM);
                stayingHere = false;
                this.applyJB.setEnabled(false);
                this.resetJB.setEnabled(false);
                this.propValueMap.clear();
                this.changedValue.clear();
                break;
            }
            case 1: {
                stayingHere = false;
                this.applyJB.setEnabled(false);
                this.resetJB.setEnabled(false);
                this.propValueMap.clear();
                this.changedValue.clear();
                break;
            }
            case 2: {
                stayingHere = true;
            }
        }
        if (!this.getPropertiedEditor().getChangeHM().isEmpty()) {
            this.getPropertiedEditor().getChangeHM().clear();
        }
        return !stayingHere;
    }
}

