/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.properties;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelChangedEvent;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.PropertiesManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.views.properties.ConsolePropertiedEditor;
import com.metamatrix.console.ui.views.properties.NextStartupPanel;
import com.metamatrix.console.ui.views.properties.PropertyFilterPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PropertiesMasterPanel
extends BasePanel
implements WorkspacePanel,
ManagerListener,
ChangeListener,
NotifyOnExitConsole,
Refreshable {
    public static final String NEXT_STARTUP = "Next Startup";
    public static final String STARTUP = "Startup";
    public static final Icon NEXT_STARTUP_ICON = IconFactory.getIconForImageFile("NextStartUp_small.gif");
    public static final Icon STARTUP_ICON = IconFactory.getIconForImageFile("startup_small.gif");
    private NextStartupPanel nextStartupPanel;
    private JTabbedPane masterTabbedPane;
    private HashMap htSelectors = new HashMap();
    private JSplitPane splMainSplitPane = null;
    private JPanel propDetailPanel;
    private JPanel propMasterOuter;
    private PropertyFilterPanel pfPanel;
    private String sSelectedTitle;
    private ArrayList aryActions = new ArrayList();
    private String previousTitle;
    private boolean runStateChange = true;
    private ConsolePropertiedEditor editor;
    private boolean canModifyServerProperties = false;
    private ConnectionInfo connection;

    public PropertiesMasterPanel(ConnectionInfo conn) {
        this.connection = conn;
        this.init();
    }

    private void init() {
    }

    public void addActionToList(String sId, Action act) {
        this.aryActions.add(new MenuEntry(sId, act));
    }

    public void createComponent() {
        this.setLayout(new BorderLayout());
        PropertiesManager manager = ModelManager.getPropertiesManager(this.connection);
        this.editor = new ConsolePropertiedEditor(manager);
        try {
            this.canModifyServerProperties = UserCapabilities.getInstance().canModifyServerProperties(this.connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage("NullPointerException", ex);
            LogManager.logError((String)"ROLES", (Throwable)ex, (String)"Error setting unmodifiable for user");
        }
        this.pfPanel = new PropertyFilterPanel(this, this.editor, this.canModifyServerProperties);
        this.masterTabbedPane = new JTabbedPane();
        this.masterTabbedPane.addChangeListener(this);
        this.masterTabbedPane.addChangeListener(this.editor);
        this.nextStartupPanel = this.pfPanel.getNextStartupPanel();
        this.pfPanel.getStartupPanel();
        this.addSelector(this.pfPanel.getNextStartupPanel());
        this.addSelector(this.pfPanel.getStartupPanel());
        this.propDetailPanel = new JPanel();
        this.propDetailPanel.setLayout(new BorderLayout());
        this.propMasterOuter = new JPanel(new BorderLayout());
        this.propMasterOuter.add((Component)this.masterTabbedPane, "Center");
        this.splMainSplitPane = new Splitter(1, true, this.pfPanel, this.propMasterOuter);
        this.add((Component)this.splMainSplitPane, "Center");
    }

    @Override
    public void modelChanged(ModelChangedEvent e) {
    }

    public void addSelector(NextStartupPanel jc) {
        this.masterTabbedPane.addTab(jc.getTitle(), jc.getIcon(), jc.getComponent());
        this.htSelectors.put(jc.getTitle(), jc);
    }

    @Override
    public void postRealize() {
        this.splMainSplitPane.setDividerLocation(150);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.runStateChange) {
            this.runStateChange = true;
            return;
        }
        if (this.havePendingChanges()) {
            boolean proceeding = this.finishUp();
            if (proceeding) {
                this.masterTabChanged();
            } else {
                this.runStateChange = false;
                this.masterTabbedPane.setSelectedIndex(this.masterTabbedPane.indexOfTab(this.previousTitle));
            }
        } else {
            this.masterTabChanged();
        }
    }

    private void masterTabChanged() {
        int iSelected = this.masterTabbedPane.getSelectedIndex();
        this.previousTitle = this.sSelectedTitle = this.masterTabbedPane.getTitleAt(iSelected);
        if (this.sSelectedTitle == null) {
            return;
        }
        if (this.previousTitle.equals(NEXT_STARTUP)) {
            this.nextStartupPanel.getApplyButton().setEnabled(false);
        }
        if (this.sSelectedTitle.equals(STARTUP) || !this.canModifyServerProperties) {
            this.pfPanel.setMRBStatus(true);
        } else {
            this.pfPanel.setMRBStatus(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertiesMasterPanel.this.pfPanel.refresh(PropertiesMasterPanel.this.sSelectedTitle);
            }
        });
    }

    @Override
    public List resume() {
        return this.aryActions;
    }

    @Override
    public String getTitle() {
        return "System Properties";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public boolean havePendingChanges() {
        boolean haveChanges = false;
        if (this.previousTitle != null && this.previousTitle.equals(NEXT_STARTUP) && this.nextStartupPanel != null) {
            haveChanges = this.nextStartupPanel.havePendingChanges();
        }
        return haveChanges;
    }

    @Override
    public boolean finishUp() {
        if (this.previousTitle != null && this.previousTitle.equals(NEXT_STARTUP)) {
            return this.nextStartupPanel.finishUp();
        }
        return true;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public void refresh() {
        this.editor.refreshData();
        this.pfPanel.refresh(this.sSelectedTitle);
    }
}

