/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.properties;

import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.ui.tree.SortableChildrenNode;
import com.metamatrix.console.util.HashedList;
import com.metamatrix.console.util.HashedListEntryWrapper;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertiesTreeModelFactory {
    private HashedList hlPreTreeModel = null;
    private Collection colPropDefs = null;

    public PropertiesTreeModelFactory(Collection colPropDefs) {
        this.colPropDefs = colPropDefs;
    }

    private Collection getPropertyDefinitions() {
        return this.colPropDefs;
    }

    private HashedList getPreTreeModel() {
        if (this.hlPreTreeModel == null) {
            this.createPreTreeModel();
        }
        return this.hlPreTreeModel;
    }

    private void createPreTreeModel() {
        if (this.hlPreTreeModel == null) {
            this.hlPreTreeModel = new HashedList();
        }
        for (PropertyDefinition pdefTemp : this.getPropertyDefinitions()) {
            this.addPropDefToPreTreeModel(pdefTemp);
        }
    }

    private void addPropDefToPreTreeModel(PropertyDefinition pdef) {
        String sCategory = this.parseCategory(pdef.getName());
        HashedListEntryWrapper hlew = new HashedListEntryWrapper();
        hlew.setHLConcatenatedKey(sCategory);
        hlew.setHLLocalKey(pdef.getName());
        hlew.setHLObject(pdef);
        this.hlPreTreeModel.put(hlew);
    }

    private String parseCategory(String sDottedName) {
        String sWorkString = sDottedName;
        String sDot = ".";
        String sResult = "";
        String sPrefix1 = "com.metamatrix.";
        String sPrefix2 = "metamatrix.";
        if (sWorkString.startsWith(sPrefix1)) {
            sWorkString = sWorkString.substring(sPrefix1.length());
        } else if (sWorkString.startsWith(sPrefix2)) {
            sWorkString = sWorkString.substring(sPrefix2.length());
        }
        int iDotPos = sWorkString.indexOf(sDot);
        sWorkString = iDotPos > -1 ? sWorkString.substring(0, iDotPos) : "general";
        sResult = sWorkString;
        return sResult;
    }

    public DefaultTreeModel getTreeModel() {
        String sRootTitle = "System Properties Root";
        String sSysPropsTitle = "System Properties";
        DefaultTreeNode dtnRoot = null;
        SortableChildrenNode dtnSysPropsNode = null;
        SortableChildrenNode dtnNew = null;
        DefaultTreeModel dtmTreeModel = new DefaultTreeModel(sRootTitle);
        dtnRoot = (DefaultTreeNode)dtmTreeModel.getRoot();
        dtnSysPropsNode = new SortableChildrenNode(sSysPropsTitle, this.getPropertyDefinitions());
        dtnRoot.addChild(dtnSysPropsNode);
        HashedList hlPreTreeModel = this.getPreTreeModel();
        String sKey2 = "";
        for (String sKey2 : hlPreTreeModel.getHashtable().keySet()) {
            List lstListOfWrappedPropertyDefinitions = hlPreTreeModel.getList(sKey2);
            if (lstListOfWrappedPropertyDefinitions.isEmpty()) continue;
            ArrayList<Object> arylPropertyDefinitions = new ArrayList<Object>();
            for (HashedListEntryWrapper hlewTemp : lstListOfWrappedPropertyDefinitions) {
                arylPropertyDefinitions.add(hlewTemp.getHLObject());
            }
            dtnNew = new SortableChildrenNode(sKey2, arylPropertyDefinitions);
            dtnSysPropsNode.addChild(dtnNew);
        }
        return dtmTreeModel;
    }
}

