/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.properties;

import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.views.properties.ConsolePropertiedEditor;
import com.metamatrix.console.ui.views.properties.NextStartupPanel;
import com.metamatrix.console.ui.views.properties.PropertiesMasterPanel;
import com.metamatrix.console.ui.views.properties.PropertiesTreeModelFactory;
import com.metamatrix.console.ui.views.properties.PropertyFilter;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class PropertyFilterPanel
extends BasePanel {
    public static final String LOGGING = "Logging Operation";
    private static String ALL_TAB = "all tab";
    private JSplitPane pnlControllSPP;
    private JPanel pnlSystemTree;
    private GridBagLayout flagLayout;
    private GridBagLayout BESPanelLayout;
    private GridBagLayout MRSPanelLayout;
    private JCheckBox allPropCB = new CheckBox("All Properties");
    private JRadioButton basicCB = new JRadioButton("Basic       ", true);
    private JRadioButton expertCB = new JRadioButton("Expert       ");
    private JRadioButton bothBECB = new JRadioButton("Both       ");
    private JRadioButton modifiableCB = new JRadioButton("Modifiable");
    private JRadioButton readOnlyCB = new JRadioButton("Read Only");
    private JRadioButton bothMRCB = new JRadioButton("Both       ", true);
    private ButtonGroup groupBE = new ButtonGroup();
    private ButtonGroup groupMR = new ButtonGroup();
    private NextStartupPanel nextStartupPanel;
    private NextStartupPanel startupPanel;
    private PropertyFilter suFilter;
    private ConsolePropertiedEditor propEditor;
    private TreeWidget tree;
    private Collection propDefns;
    private PropertiesTreeModelFactory ptmFactory;
    private PropertiesMasterPanel masterPanel;
    private TreePath prevTP;
    private boolean runValueChange = true;
    private boolean canModifyServerProperties = false;

    public PropertyFilterPanel(PropertiesMasterPanel masterPanel, ConsolePropertiedEditor editor, boolean canModifyServerProperties) {
        this.masterPanel = masterPanel;
        this.canModifyServerProperties = canModifyServerProperties;
        this.propEditor = editor;
        this.createComponent();
    }

    public void createComponent() {
        StaticUtilities.startWait(this);
        this.setLayout(new BorderLayout());
        this.pnlSystemTree = new JPanel(new BorderLayout());
        JPanel pnlFlag = new JPanel();
        JPanel pnlBESelector = new JPanel();
        JPanel pnlMRSelector = new JPanel();
        this.flagLayout = new GridBagLayout();
        pnlFlag.setLayout(this.flagLayout);
        this.flagLayout.setConstraints(this.allPropCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.flagLayout.setConstraints(pnlBESelector, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.flagLayout.setConstraints(pnlMRSelector, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.BESPanelLayout = new GridBagLayout();
        pnlBESelector.setLayout(this.BESPanelLayout);
        this.BESPanelLayout.setConstraints(this.basicCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.BESPanelLayout.setConstraints(this.expertCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.BESPanelLayout.setConstraints(this.bothBECB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlBESelector.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        pnlBESelector.add(this.basicCB);
        pnlBESelector.add(this.expertCB);
        pnlBESelector.add(this.bothBECB);
        this.groupBE.add(this.basicCB);
        this.groupBE.add(this.expertCB);
        this.groupBE.add(this.bothBECB);
        this.MRSPanelLayout = new GridBagLayout();
        pnlMRSelector.setLayout(this.MRSPanelLayout);
        this.MRSPanelLayout.setConstraints(this.modifiableCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.MRSPanelLayout.setConstraints(this.readOnlyCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.MRSPanelLayout.setConstraints(this.bothMRCB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlMRSelector.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        pnlMRSelector.add(this.modifiableCB);
        pnlMRSelector.add(this.readOnlyCB);
        pnlMRSelector.add(this.bothMRCB);
        this.groupMR.add(this.modifiableCB);
        this.groupMR.add(this.readOnlyCB);
        this.groupMR.add(this.bothMRCB);
        TitledBorder tBorder = new TitledBorder("Display");
        pnlFlag.setBorder(tBorder);
        this.pnlControllSPP = new Splitter(0, true, this.pnlSystemTree, pnlFlag);
        pnlFlag.add(this.allPropCB);
        pnlFlag.add(pnlBESelector);
        pnlFlag.add(pnlMRSelector);
        this.add(this.pnlControllSPP);
        this.pnlControllSPP.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Double sizeDB = new Double(PropertyFilterPanel.this.pnlControllSPP.getSize().getHeight() - 260.0);
                PropertyFilterPanel.this.pnlControllSPP.setDividerLocation(sizeDB.intValue());
            }
        });
        this.nextStartupPanel = new NextStartupPanel("Next Startup", PropertiesMasterPanel.NEXT_STARTUP_ICON, this, this.masterPanel.getConnection());
        this.startupPanel = new NextStartupPanel("Startup", PropertiesMasterPanel.STARTUP_ICON, this, this.masterPanel.getConnection());
        this.suFilter = new PropertyFilter();
        this.nextStartupPanel.setPropertiedEditor(this.propEditor);
        this.propDefns = this.propEditor.getPropDefn();
        this.ptmFactory = new PropertiesTreeModelFactory(this.propDefns);
        DefaultTreeModel tm = this.ptmFactory.getTreeModel();
        this.tree = new TreeWidget(tm);
        this.tree.setRootVisible(false);
        this.tree.expandRow(0);
        StaticTreeUtilities.expandAll(this.tree);
        JScrollPane sp = new JScrollPane(this.tree);
        this.pnlSystemTree.add((Component)sp, "Center");
        this.startupPanel.setPropertiedEditor(this.propEditor);
        StaticUtilities.endWait(this);
        this.propControllProcess();
    }

    boolean isModifyServerProperties() {
        return this.canModifyServerProperties;
    }

    JRadioButton getMJRB() {
        return this.modifiableCB;
    }

    JRadioButton getRJRB() {
        return this.readOnlyCB;
    }

    JRadioButton getBJRB() {
        return this.bothMRCB;
    }

    NextStartupPanel getNextStartupPanel() {
        return this.nextStartupPanel;
    }

    NextStartupPanel getStartupPanel() {
        return this.startupPanel;
    }

    @Override
    public void postRealize() {
    }

    private void propControllProcess() {
        this.tree.setSelectionRow(0);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent se) {
                boolean proceeding;
                if (!PropertyFilterPanel.this.runValueChange) {
                    PropertyFilterPanel.this.runValueChange = true;
                    return;
                }
                if (PropertyFilterPanel.this.masterPanel.havePendingChanges() && !(proceeding = PropertyFilterPanel.this.masterPanel.finishUp())) {
                    PropertyFilterPanel.this.runValueChange = false;
                    PropertyFilterPanel.this.tree.setSelectionPath(PropertyFilterPanel.this.prevTP);
                    return;
                }
                PropertyFilterPanel.this.prevTP = PropertyFilterPanel.this.tree.getSelectionPath();
                DefaultTreeNode treeNode = (DefaultTreeNode)PropertyFilterPanel.this.prevTP.getLastPathComponent();
                String title = PropertyFilterPanel.this.propEditor.getCurrentTitle();
                String gn = treeNode.getName();
                Object propDefns = treeNode.getContent();
                if (title.equals("Next Startup")) {
                    PropertyFilterPanel.this.nextStartupPanel.setGroupName(gn, PropertyFilterPanel.this.propEditor.getNSUDefns((List)propDefns), PropertyFilterPanel.this.suFilter);
                } else if (title.equals("Startup")) {
                    PropertyFilterPanel.this.startupPanel.setGroupName(gn, PropertyFilterPanel.this.propEditor.getSUDefns((List)propDefns), PropertyFilterPanel.this.suFilter);
                }
                if (PropertyFilterPanel.this.nextStartupPanel.getPropertiedEditor().getChangeHM() != null) {
                    PropertyFilterPanel.this.nextStartupPanel.getPropertiedEditor().getChangeHM().clear();
                }
            }
        });
        CheckBoxListener cBoxListener = new CheckBoxListener();
        this.allPropCB.addActionListener(cBoxListener);
        this.basicCB.addActionListener(cBoxListener);
        this.bothBECB.addActionListener(cBoxListener);
        this.expertCB.addActionListener(cBoxListener);
        this.modifiableCB.addActionListener(cBoxListener);
        this.bothMRCB.addActionListener(cBoxListener);
        this.readOnlyCB.addActionListener(cBoxListener);
    }

    public void refresh() {
        this.refresh(ALL_TAB);
    }

    public void refresh(String tabIndex) {
        TreePath currentSelectPath = this.tree.getSelectionPath();
        String gn = null;
        Object propDefns = null;
        if (currentSelectPath != null) {
            DefaultTreeNode treeNode = (DefaultTreeNode)currentSelectPath.getLastPathComponent();
            gn = treeNode.getName();
            propDefns = treeNode.getContent();
        }
        if (gn == null) {
            if (tabIndex.equals("Next Startup") || tabIndex.equals(ALL_TAB)) {
                this.nextStartupPanel.setGroupName("System Property", null, this.suFilter);
            }
            if (tabIndex.equals("Startup") || tabIndex.equals(ALL_TAB)) {
                this.startupPanel.setGroupName("System Property", null, this.suFilter);
            }
        } else {
            if (tabIndex.equals("Next Startup")) {
                this.nextStartupPanel.setGroupName(gn, this.propEditor.getNSUDefns((List)propDefns), this.suFilter);
            }
            if (tabIndex.equals("Startup")) {
                this.startupPanel.setGroupName(gn, this.propEditor.getSUDefns((List)propDefns), this.suFilter);
            }
        }
    }

    void setMRBStatus(boolean isDisable) {
        if (isDisable) {
            this.suFilter.setIsMRBEnabled(false);
        } else {
            this.suFilter.setIsMRBEnabled(true);
        }
        if (isDisable || this.allPropCB.isSelected()) {
            this.modifiableCB.setEnabled(false);
            this.readOnlyCB.setEnabled(false);
            this.bothMRCB.setEnabled(false);
        } else {
            this.modifiableCB.setEnabled(true);
            this.readOnlyCB.setEnabled(true);
            this.bothMRCB.setEnabled(true);
        }
    }

    private void setAllCheckBoxesEnableStatus(boolean status) {
        this.basicCB.setEnabled(status);
        this.expertCB.setEnabled(status);
        this.bothBECB.setEnabled(status);
        if (this.propEditor.getCurrentTitle().equals("Startup") || !this.canModifyServerProperties) {
            return;
        }
        this.modifiableCB.setEnabled(status);
        this.readOnlyCB.setEnabled(status);
        this.bothMRCB.setEnabled(status);
    }

    class CheckBoxListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String title = PropertyFilterPanel.this.propEditor.getCurrentTitle();
            Object source = e.getSource();
            if (source == PropertyFilterPanel.this.allPropCB) {
                PropertyFilterPanel.this.suFilter.setAllProperties(PropertyFilterPanel.this.allPropCB.isSelected());
                if (PropertyFilterPanel.this.allPropCB.isSelected()) {
                    PropertyFilterPanel.this.setAllCheckBoxesEnableStatus(false);
                } else {
                    PropertyFilterPanel.this.setAllCheckBoxesEnableStatus(true);
                }
            } else if (source == PropertyFilterPanel.this.basicCB) {
                PropertyFilterPanel.this.suFilter.setBasicProperties(PropertyFilterPanel.this.basicCB.isSelected());
            } else if (source == PropertyFilterPanel.this.expertCB) {
                PropertyFilterPanel.this.suFilter.setExpertProperties(PropertyFilterPanel.this.expertCB.isSelected());
            } else if (source == PropertyFilterPanel.this.bothBECB) {
                PropertyFilterPanel.this.suFilter.setBothBEProperties(PropertyFilterPanel.this.bothBECB.isSelected());
            } else if (source == PropertyFilterPanel.this.modifiableCB) {
                PropertyFilterPanel.this.suFilter.setModifiableProperties(PropertyFilterPanel.this.modifiableCB.isSelected());
            } else if (source == PropertyFilterPanel.this.readOnlyCB) {
                PropertyFilterPanel.this.suFilter.setReadOnlyProperties(PropertyFilterPanel.this.readOnlyCB.isSelected());
            } else if (source == PropertyFilterPanel.this.bothMRCB) {
                PropertyFilterPanel.this.suFilter.setBothMRProperties(PropertyFilterPanel.this.bothMRCB.isSelected());
            }
            PropertyFilterPanel.this.refresh(title);
        }
    }
}

