/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.queries;

import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelChangedEvent;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.QueryManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.queries.QueryRequestPanel;
import com.metamatrix.console.ui.views.queries.QueryTableModel;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.server.serverapi.RequestInfo;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class QueryPanel
extends JPanel
implements ManagerListener,
WorkspacePanel,
AutoRefreshable {
    private static final SimpleDateFormat FORMATTER;
    private static final double INITIAL_SPLITTER_LOC = 0.4;
    private JTextArea txaCommand;
    private QueryRequestPanel queryPanel;
    private TextFieldWidget txfRequestId;
    private TextFieldWidget txfSessionId;
    private TextFieldWidget txfSubmitted;
    private TextFieldWidget txfTransactionId;
    private TextFieldWidget txfUser;
    private TextFieldWidget txfConnectorBinding;
    private Splitter splitter;
    private ConnectionInfo connection;
    private ConnectorManager connectorMgr;
    private ArrayList actions = new ArrayList();
    private Action refreshAction;
    private AutoRefresher arRefresher;
    private boolean hasBeenPainted = false;
    private JPanel pnlDetail;

    public QueryPanel(ConnectionInfo conn) throws Exception {
        this.connection = conn;
        this.construct();
        ModelManager.getQueryManager(this.connection).addManagerListener(this);
        this.refreshAction = new AbstractPanelAction(0){

            @Override
            public void actionImpl(ActionEvent e) {
                QueryPanel.this.refreshImpl();
            }
        };
        this.refreshAction.putValue("Name", "Refresh");
        this.refreshAction.putValue("SmallIcon", DeployPkgUtils.getIcon("icon.refresh"));
        MenuEntry mnuEntry = new MenuEntry("view.refresh", this.refreshAction);
        this.actions.add(mnuEntry);
        this.getQueryManager().setRefreshAction(this.refreshAction);
        this.arRefresher = new AutoRefresher(this, 15, false, this.connection);
        this.arRefresher.init();
        this.arRefresher.startTimer();
        this.getQueryManager().setAutoRefresher(this.arRefresher);
    }

    private void clearDetailPanel() {
        this.txfRequestId.setText("");
        this.txfSessionId.setText("");
        this.txfSubmitted.setText("");
        this.txfTransactionId.setText("");
        this.txfUser.setText("");
        this.txfConnectorBinding.setText("");
        this.txaCommand.setText("");
    }

    private void construct() {
        this.setLayout(new GridLayout(1, 1));
        this.splitter = new Splitter(0);
        this.splitter.setOneTouchExpandable(true);
        this.add(this.splitter);
        this.connectorMgr = ModelManager.getConnectorManager(this.connection);
        this.queryPanel = new QueryRequestPanel(this, this.connectorMgr);
        this.splitter.setTopComponent(this.queryPanel);
        QueryRequestPanel.CancelQueryRequestsAction cancelAction = this.queryPanel.getCancelAction();
        if (cancelAction != null) {
            MenuEntry menuEntry = new MenuEntry("action", cancelAction);
            this.actions.add(menuEntry);
        }
        this.pnlDetail = new JPanel(new GridBagLayout());
        this.splitter.setBottomComponent(new JScrollPane(this.pnlDetail));
        GridBagLayout requestLayout = new GridBagLayout();
        JPanel pnlRequest = new JPanel(requestLayout);
        TitledBorder bdr = new TitledBorder("Request");
        Font bdrFont = bdr.getTitleFont().deriveFont(1);
        bdr.setTitleFont(bdrFont);
        pnlRequest.setBorder(bdr);
        this.pnlDetail.add((Component)pnlRequest, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        LabelWidget lblRequestId = new LabelWidget(QueryTableModel.COLUMN_NAMES[0] + ':');
        pnlRequest.add((Component)lblRequestId, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.txfRequestId = new TextFieldWidget();
        this.txfRequestId.setEditable(false);
        pnlRequest.add((Component)this.txfRequestId, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        LabelWidget lblUser = new LabelWidget(QueryTableModel.COLUMN_NAMES[1] + ':');
        pnlRequest.add((Component)lblUser, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 2), 0, 0));
        this.txfUser = new TextFieldWidget();
        this.txfUser.setEditable(false);
        pnlRequest.add((Component)this.txfUser, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        LabelWidget lblSessionId = new LabelWidget(QueryTableModel.COLUMN_NAMES[2] + ':');
        pnlRequest.add((Component)lblSessionId, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.txfSessionId = new TextFieldWidget();
        this.txfSessionId.setEditable(false);
        pnlRequest.add((Component)this.txfSessionId, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        LabelWidget lblConnectorBinding = new LabelWidget(QueryTableModel.CONNECTOR_BINDING_HDR + ':');
        pnlRequest.add((Component)lblConnectorBinding, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 2), 0, 0));
        this.txfConnectorBinding = new TextFieldWidget();
        this.txfConnectorBinding.setEditable(false);
        pnlRequest.add((Component)this.txfConnectorBinding, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        LabelWidget lblTransactionId = new LabelWidget(QueryTableModel.TRANSACTION_ID_HDR + ':');
        pnlRequest.add((Component)lblTransactionId, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.txfTransactionId = new TextFieldWidget();
        this.txfTransactionId.setEditable(false);
        pnlRequest.add((Component)this.txfTransactionId, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        LabelWidget lblSubmitted = new LabelWidget(QueryTableModel.TIME_SUBMITTED_HDR + ':');
        pnlRequest.add((Component)lblSubmitted, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 2, 2), 0, 0));
        this.txfSubmitted = new TextFieldWidget();
        this.txfSubmitted.setEditable(false);
        pnlRequest.add((Component)this.txfSubmitted, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel pnlCommand = new JPanel(new GridLayout(1, 1));
        bdr = new TitledBorder("Command");
        bdr.setTitleFont(bdrFont);
        pnlCommand.setBorder(bdr);
        this.pnlDetail.add((Component)pnlCommand, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.txaCommand = new JTextArea();
        this.txaCommand.setLineWrap(true);
        this.txaCommand.setWrapStyleWord(true);
        this.txaCommand.setEditable(false);
        JScrollPane spnCommand = new JScrollPane(this.txaCommand);
        pnlCommand.add(spnCommand);
    }

    public void displayQuery(RequestInfo request) {
        if (request != null) {
            this.txfRequestId.setText(String.valueOf(request.getRequestID()));
            SessionToken sessionToken = request.getSessionToken();
            String sessionIDStr = "";
            if (sessionToken != null) {
                sessionIDStr = sessionToken.getSessionIDValue();
            }
            this.txfSessionId.setText(sessionIDStr);
            Date date = request.getProcessingTimestamp();
            this.txfSubmitted.setText(date == null ? "" : FORMATTER.format(date));
            String transId = request.getTransactionId();
            this.txfTransactionId.setText(transId == null ? "" : transId);
            String userStr = "";
            if (sessionToken != null) {
                userStr = sessionToken.getUsername();
            }
            this.txfUser.setText(userStr);
            String bindingUUID = request.getConnectorBindingUUID();
            String bindingName = "";
            if (bindingUUID != null && bindingUUID.trim().length() > 0) {
                try {
                    ConnectorBinding cb = this.connectorMgr.getConnectorBindingByUUID(bindingUUID);
                    if (cb != null) {
                        bindingName = cb.getName();
                    }
                }
                catch (Exception ex) {
                    LogManager.logError((String)"QUERIES", (Throwable)ex, (String)("Error retrieving connector binding for UUID " + bindingUUID));
                }
            }
            this.txfConnectorBinding.setText(bindingName);
            String command = request.getCommand();
            StringBuffer sql = new StringBuffer();
            sql.append(command.toString());
            this.txaCommand.setText(sql.toString());
        } else {
            this.clearDetailPanel();
        }
        this.pnlDetail.validate();
    }

    private QueryManager getQueryManager() {
        return ModelManager.getQueryManager(this.connection);
    }

    @Override
    public String getTitle() {
        return "Queries";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void modelChanged(ModelChangedEvent e) {
        this.refreshTable();
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    private void refreshImpl() {
        this.getQueryManager().setIsStale(true);
    }

    @Override
    public void refresh() {
        this.refreshTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTable() {
        final String selectedRequestID = this.txfRequestId.getText();
        try {
            StaticUtilities.startWait(ConsoleMainFrame.getInstance());
            final Collection allQueries = this.getQueryManager().getAllRequests();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    QueryPanel.this.clearDetailPanel();
                    QueryPanel.this.queryPanel.updateView(allQueries, selectedRequestID);
                }
            };
            StaticUtilities.invokeLaterSafe(runnable);
        }
        catch (ExternalException ee) {
            ExceptionUtility.showUnspecifiedFailureMessage(ConsolePlugin.Util.getString("QueryPanel.Could_not_refresh_query_table_1"), (Throwable)((Object)ee));
        }
        catch (Throwable e) {
            ExceptionUtility.showUnspecifiedFailureMessage(ConsolePlugin.Util.getString("QueryPanel.Could_not_refresh_query_table_1"), e);
        }
        finally {
            StaticUtilities.endWait(ConsoleMainFrame.getInstance());
        }
    }

    @Override
    public List resume() {
        this.refresh();
        return this.actions;
    }

    @Override
    public String getName() {
        return "data.query";
    }

    @Override
    public void setAutoRefreshEnabled(boolean b) {
        this.arRefresher.setAutoRefreshEnabled(b);
    }

    @Override
    public void setRefreshRate(int iRate) {
        this.arRefresher.setRefreshRate(iRate);
    }

    @Override
    public void setAutoRefresher(AutoRefresher ar) {
        this.arRefresher = ar;
    }

    @Override
    public AutoRefresher getAutoRefresher() {
        return this.arRefresher;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.hasBeenPainted) {
            this.hasBeenPainted = true;
            this.splitter.setDividerLocation(0.4);
        }
        super.paint(g);
    }

    static {
        PropertyProvider pp = PropertyProvider.getDefault();
        FORMATTER = (SimpleDateFormat)pp.getObject("date.formatter.default");
    }
}

