/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.queries;

import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.ColumnSortInfo;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.ui.views.queries.QueryPanel;
import com.metamatrix.console.ui.views.queries.QueryTableModel;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.server.serverapi.RequestInfo;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class QueryRequestPanel
extends BasePanel {
    private QueryPanel caller;
    private ConnectorManager connectorManager;
    private ConnectionInfo connection = null;
    private TableWidget queryTable;
    private QueryTableModel tableModel;
    private HashMap requestsMap = new HashMap();
    private CancelQueryRequestsAction actionCancel = null;
    private Vector actionsVec;

    public QueryRequestPanel(QueryPanel cllr, ConnectorManager connMgr) {
        this.caller = cllr;
        this.connectorManager = connMgr;
        this.connection = this.caller.getConnection();
        this.createComponent();
        UserCapabilities cap = null;
        try {
            cap = UserCapabilities.getInstance();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.actionsVec = new Vector(1);
        if (cap.canModifyQueries(this.connection)) {
            this.actionCancel = new CancelQueryRequestsAction();
            this.actionCancel.setEnabled(false);
            this.actionsVec.add(this.actionCancel);
        }
    }

    public void createComponent() {
        this.initializeTable();
        this.queryTable.setRowSelectionAllowed(true);
        this.queryTable.setColumnSelectionAllowed(false);
        this.queryTable.setSortable(true);
        EnhancedTableColumn requestIDCol = (EnhancedTableColumn)this.queryTable.getColumn(QueryTableModel.REQUEST_ID_HDR);
        this.queryTable.setColumnSortedAscending(requestIDCol);
        JScrollPane scrollPane = new JScrollPane(this.queryTable);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.queryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean enableCancel;
                    int numSelections = QueryRequestPanel.this.getNumSelections();
                    boolean bl = enableCancel = numSelections > 0;
                    if (QueryRequestPanel.this.actionCancel != null) {
                        QueryRequestPanel.this.actionCancel.setEnabled(enableCancel);
                    }
                    if (numSelections == 1) {
                        int selectionRow = QueryRequestPanel.this.queryTable.getSelectedRows()[0];
                        String requestIDStr = (String)QueryRequestPanel.this.tableModel.getValueAt(QueryRequestPanel.this.queryTable.convertRowIndexToModel(selectionRow), QueryRequestPanel.this.tableModel.getRequestIdColumn());
                        RequestInfo req = (RequestInfo)QueryRequestPanel.this.requestsMap.get(requestIDStr);
                        QueryRequestPanel.this.caller.displayQuery(req);
                    } else {
                        QueryRequestPanel.this.caller.displayQuery(null);
                    }
                }
            }
        });
        this.queryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    QueryRequestPanel.this.handlePopupTrigger(e);
                }
            }
        });
    }

    private JPopupMenu getActionsPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        Iterator it = this.actionsVec.iterator();
        while (it.hasNext()) {
            menu.add((Action)it.next());
        }
        return menu;
    }

    private void handlePopupTrigger(MouseEvent e) {
        try {
            if (UserCapabilities.getInstance().canModifyQueries(this.connection)) {
                this.getActionsPopupMenu().show(this.queryTable, e.getX() + 10, e.getY());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getNumSelections() {
        int[] rows = this.queryTable.getSelectedRows();
        return rows.length;
    }

    private void cancelSelectedQueries() throws ExternalException {
        ConfirmCancelPanel pnl = new ConfirmCancelPanel();
        DialogWindow.show(ConsoleMainFrame.getInstance(), ConsolePlugin.Util.getString("QueryRequestPanel.Cancel_Confirmation_2"), pnl);
        if (pnl.getSelectedButton() == pnl.getAcceptButton()) {
            try {
                ModelManager.getQueryManager(this.connection).cancelQueryRequests(this.getCurrentSelections());
            }
            catch (Exception theException) {
                theException.printStackTrace();
                throw new ExternalException(theException);
            }
        }
    }

    public void updateView(Collection newQueryRequests, String selectedRequestID) {
        StaticUtilities.startWait(this);
        this.updateTheView(newQueryRequests);
        StaticUtilities.endWait(this);
        this.selectRowOfRequestID(selectedRequestID);
    }

    private void selectRowOfRequestID(String requestID) {
        if (requestID != null && requestID.length() > 0) {
            boolean found = false;
            int i = 0;
            int numRows = this.queryTable.getRowCount();
            while (i < numRows && !found) {
                String curRequestID = (String)this.tableModel.getValueAt(i, 0);
                if (requestID.equals(curRequestID)) {
                    found = true;
                    int viewRow = this.queryTable.convertRowIndexToView(i);
                    this.queryTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    continue;
                }
                ++i;
            }
        }
    }

    private void initializeTable() {
        this.tableModel = new QueryTableModel();
        this.queryTable = new TableWidget((TableModel)this.tableModel, true);
        this.queryTable.setName("QueryTable");
        this.queryTable.getTableHeader().setName("QueryTable.header");
    }

    private void updateTheView(Collection newRequests) {
        ColumnSortInfo[] tableColumnSortInfo = ColumnSortInfo.getTableColumnSortInfo(this.queryTable);
        Vector<Vector> outerVec = new Vector<Vector>(newRequests.size());
        Iterator iterator = newRequests.iterator();
        HashMap<String, RequestInfo> tempRequestsMap = new HashMap<String, RequestInfo>();
        while (iterator.hasNext()) {
            RequestInfo q = (RequestInfo)iterator.next();
            Object[] rowData = new Object[4];
            String requestStr = this.getRequestInfoDisplayString(q);
            rowData[0] = requestStr;
            tempRequestsMap.put(requestStr, q);
            SessionToken st = q.getSessionToken();
            if (st != null) {
                rowData[1] = st.getUsername();
                rowData[2] = st.getSessionIDValue();
            }
            rowData[3] = this.getConnectorBindingForUUID(q.getConnectorBindingUUID());
            Vector innerVec = StaticUtilities.arrayToVector(rowData);
            outerVec.add(innerVec);
        }
        this.queryTable.clearSelection();
        this.tableModel.setRows(outerVec);
        this.queryTable.sizeColumnsToFitData();
        this.requestsMap = tempRequestsMap;
        this.queryTable.requestFocus();
        this.queryTable.setEditable(false);
        ColumnSortInfo.setColumnSortOrder(tableColumnSortInfo, this.queryTable);
    }

    private String getRequestInfoDisplayString(RequestInfo q) {
        RequestID id = q.getRequestID();
        boolean isAtomicQuery = q.isAtomicQuery();
        String requestStr = isAtomicQuery ? id.toString() + '.' + q.getNodeID() : id.toString();
        return requestStr;
    }

    private String getConnectorBindingForUUID(String connectorBindingUUID) {
        ConnectorBinding cb = null;
        String name = null;
        try {
            cb = this.connectorManager.getConnectorBindingByUUID(connectorBindingUUID);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (cb != null) {
            name = cb.getFullName();
        }
        return name;
    }

    public Collection getCurrentSelections() {
        int[] selectedRows = this.queryTable.getSelectedRows();
        ArrayList<RequestInfo> queries = new ArrayList<RequestInfo>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            String requestIDStr = (String)this.tableModel.getValueAt(this.queryTable.convertRowIndexToModel(selectedRows[i]), this.tableModel.getRequestIdColumn());
            RequestInfo ri = (RequestInfo)this.requestsMap.get(requestIDStr);
            queries.add(ri);
        }
        return queries;
    }

    public TableWidget getQueryTable() {
        return this.queryTable;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public CancelQueryRequestsAction getCancelAction() {
        return this.actionCancel;
    }

    private class ConfirmCancelPanel
    extends DialogPanel {
        public ConfirmCancelPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createEmptyBorder(30, 40, 30, 40));
            int rows = QueryRequestPanel.this.getNumSelections();
            LabelWidget lbl = new LabelWidget(QueryRequestPanel.this.getNumSelections() > 1 ? ConsolePlugin.Util.getString("QueryRequestPanel.Are_you_sure_you_want_to_cancel_the__11") + rows + ConsolePlugin.Util.getString("QueryRequestPanel._selected_queries__12") : ConsolePlugin.Util.getString("QueryRequestPanel.Are_you_sure_you_want_to_cancel_the_selected_query__13"));
            lbl.setIcon(PropertyProvider.getDefault().getIcon("icon.warning"));
            pnl.add(lbl);
            this.setContent(pnl);
        }
    }

    private class CancelFailedPanel
    extends DialogPanel {
        public CancelFailedPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createEmptyBorder(30, 40, 30, 40));
            LabelWidget lbl = new LabelWidget(ConsolePlugin.Util.getString("QueryRequestPanel.At_least_one_query_failed_to_cancel._n_8") + ConsolePlugin.Util.getString("QueryRequestPanel.Refresh_to_get_an_updated_list_of_active_queries._9"));
            lbl.setIcon(PropertyProvider.getDefault().getIcon("icon.info"));
            pnl.add(lbl);
            this.setContent(pnl);
            this.removeNavigationButton(this.getCancelButton());
        }
    }

    public class CancelQueryRequestsAction
    extends AbstractPanelAction {
        public CancelQueryRequestsAction() {
            super(0);
            this.putValue("ShortDescription", ConsolePlugin.Util.getString("QueryRequestPanel.Cancel_the_selected_queries_5"));
            this.putValue("Name", "Cancel");
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) throws ExternalException {
            QueryRequestPanel.this.cancelSelectedQueries();
        }

        @Override
        protected void handleError(Exception theException) {
            CancelFailedPanel pnl = new CancelFailedPanel();
            DialogWindow.show(ConsoleMainFrame.getInstance(), ConsolePlugin.Util.getString("QueryRequestPanel.Cancel_Query_Error_7"), pnl);
        }
    }
}

