/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.resources;

import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ResourceManager;
import com.metamatrix.console.models.ResourcePropertiedObjectEditor;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.POPWithButtons;
import com.metamatrix.console.ui.util.POPWithButtonsController;
import com.metamatrix.console.ui.util.PropertiedObjectPanelHolder;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.resources.ResourceData;
import com.metamatrix.console.ui.views.resources.RestartToActivateDialog;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.property.PropertiedObjectPanel;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ResourcesMainPanel
extends BasePanel
implements WorkspacePanel,
NotifyOnExitConsole,
POPWithButtonsController,
Refreshable {
    public static final int RESOURCE_NAME_COL_NUM = 0;
    public static final int RESOURCE_TYPE_COL_NUM = 1;
    public static final int NUM_COLUMNS = 2;
    public static final double SPLIT_PANE_DIVIDER_LOC_FRAME_PROPORTION = 0.6;
    public static final String RESOURCE_NAME_COL_HDR = "Resource Name";
    public static final String RESOURCE_TYPE_COL_HDR = "Resource Type";
    private ConnectionInfo connection;
    private TableWidget table;
    private DefaultTableModel tableModel;
    private PropertiedObjectPanel pop = null;
    private POPWithButtons popWithButtons = null;
    private ResourcePropertiedObjectEditor rpoe;
    private ResourceManager manager;
    private JPanel lowerPanel;
    private Map resourceMap = new HashMap();
    private boolean canModify;
    private String currentSelectedResource = null;
    private boolean programmaticTableRowSelection = false;
    private boolean showingNeedRestartToActivateDialog = true;

    public ResourcesMainPanel(ResourceManager manager, boolean modifiable, ConnectionInfo conn) throws Exception {
        this.manager = manager;
        this.canModify = modifiable;
        this.connection = conn;
        this.init();
        this.populateTable(null);
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void init() throws Exception {
        String[] colHdrs = new String[]{RESOURCE_NAME_COL_HDR, RESOURCE_TYPE_COL_HDR};
        Vector<String> colHdrsVec = new Vector<String>(Arrays.asList(colHdrs));
        this.tableModel = new DefaultTableModel(colHdrsVec);
        this.table = new TableWidget((TableModel)this.tableModel, true);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setEditable(false);
        this.table.setComparator(DefaultConsoleTableComparator.getInstance());
        EnhancedTableColumn nameColumn = (EnhancedTableColumn)this.table.getColumn(RESOURCE_NAME_COL_HDR);
        this.table.setColumnSortedAscending(nameColumn, false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                ResourcesMainPanel.this.tableRowSelectionChanged(ev);
            }
        });
        JScrollPane tableJSP = new JScrollPane(this.table);
        this.lowerPanel = new JPanel();
        GridBagLayout ll = new GridBagLayout();
        this.lowerPanel.setLayout(ll);
        this.rpoe = this.manager.getResourcePropertiedObjectEditor();
        this.pop = new PropertiedObjectPanel(this.rpoe, this.manager.getEncryptor());
        this.pop.setReadOnlyForced(!this.canModify);
        this.pop.createComponent();
        PropertiedObjectPanelHolder popHolder = new PropertiedObjectPanelHolder(this.pop, null);
        this.popWithButtons = new POPWithButtons(popHolder, (PropertiedObjectEditor)this.rpoe, (POPWithButtonsController)this);
        this.popWithButtons.setButtonsVisible(this.canModify);
        this.lowerPanel.add(this.popWithButtons);
        ll.setConstraints(this.popWithButtons, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        Splitter splitter = new Splitter(0, true, tableJSP, this.lowerPanel);
        splitter.setOneTouchExpandable(true);
        int frameHeight = ConsoleMainFrame.getInstance().getSize().height;
        int dividerLoc = (int)((double)frameHeight * 0.6);
        ((JSplitPane)splitter).setDividerLocation(dividerLoc);
        this.setLayout(new GridLayout(1, 1));
        this.add(splitter);
    }

    private void tableRowSelectionChanged(ListSelectionEvent ev) {
        if (!this.programmaticTableRowSelection && !ev.getValueIsAdjusting()) {
            boolean continuing = true;
            if (this.havePendingChanges()) {
                continuing = this.finishUp();
            }
            if (continuing) {
                int selectedModelRow = this.table.getSelectionModel().getLeadSelectionIndex();
                if (selectedModelRow >= 0) {
                    selectedModelRow = this.table.convertRowIndexToModel(selectedModelRow);
                }
                String resourceName = this.resourceNameForModelRow(selectedModelRow);
                ResourceData rData = (ResourceData)this.resourceMap.get(resourceName);
                this.currentSelectedResource = resourceName;
                PropertiedObject po = rData.getPropertiedObject();
                this.displayDetail(this.currentSelectedResource, po);
            } else {
                int modelRow = this.modelRowForResource(this.currentSelectedResource);
                int viewRow = this.table.convertRowIndexToView(modelRow);
                this.programmaticTableRowSelection = true;
                this.table.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                this.programmaticTableRowSelection = false;
            }
        }
    }

    @Override
    public boolean havePendingChanges() {
        return this.popWithButtons.havePendingChanges();
    }

    @Override
    public boolean finishUp() {
        boolean stayingHere = false;
        String msg = "Save changes to Resource \"" + this.currentSelectedResource + "\"?";
        int response = DialogUtility.showPendingChangesDialog(msg, this.manager.getConnection().getURL(), this.manager.getConnection().getUser());
        switch (response) {
            case 0: {
                this.doApplyChanges(this.pop);
                stayingHere = false;
                break;
            }
            case 1: {
                stayingHere = false;
                break;
            }
            case 2: {
                stayingHere = true;
            }
        }
        return !stayingHere;
    }

    @Override
    public List resume() {
        ArrayList actions = new ArrayList(1);
        return actions;
    }

    @Override
    public String getTitle() {
        return "Resources";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    private void populateTable(String resourceToSelect) {
        SharedResource[] resources = null;
        boolean continuing = true;
        try {
            resources = this.manager.getResources();
        }
        catch (Exception ex) {
            String msg = "Error retrieving list of Resources";
            LogManager.logError((String)"RESOURCES", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
            continuing = false;
        }
        if (continuing) {
            this.resourceMap.clear();
            this.programmaticTableRowSelection = true;
            this.tableModel.setRowCount(0);
            this.programmaticTableRowSelection = false;
            for (int i = 0; i < resources.length; ++i) {
                ResourceData rData = new ResourceData(resources[i], this.manager);
                this.resourceMap.put(rData.getName(), rData);
                Object[] rowData = new Object[]{rData.getName(), rData.getType()};
                this.tableModel.addRow(rowData);
            }
            if (resourceToSelect != null) {
                int modelRow = this.modelRowForResource(resourceToSelect);
                if (modelRow != 0) {
                    int viewRow = this.table.convertRowIndexToView(modelRow);
                    this.programmaticTableRowSelection = true;
                    this.table.setRowSelectionInterval(viewRow, viewRow);
                    this.programmaticTableRowSelection = false;
                    this.currentSelectedResource = resourceToSelect;
                } else {
                    this.currentSelectedResource = null;
                }
            } else {
                this.currentSelectedResource = null;
            }
        }
    }

    private void displayDetail(String resourceName, PropertiedObject po) {
        this.lowerPanel.setBorder(new TitledBorder("Properties for Resource " + resourceName));
        this.popWithButtons.setPropertiedObject(po);
        this.popWithButtons.setButtons();
    }

    private int modelRowForResource(String resourceName) {
        int matchingRow = -1;
        int i = 0;
        int numRows = this.table.getRowCount();
        while (matchingRow < 0 && i < numRows) {
            String curName = (String)this.tableModel.getValueAt(i, 0);
            if (resourceName.equals(curName)) {
                matchingRow = i;
                continue;
            }
            ++i;
        }
        return matchingRow;
    }

    private String resourceNameForModelRow(int modelRow) {
        String name = null;
        if (modelRow < this.tableModel.getRowCount()) {
            name = (String)this.tableModel.getValueAt(modelRow, 0);
        }
        return name;
    }

    @Override
    public boolean doApplyChanges(PropertiedObjectPanel pop) {
        boolean proceeding = true;
        if (this.showingNeedRestartToActivateDialog) {
            proceeding = this.showNeedRestartDialog();
        }
        if (proceeding) {
            try {
                this.manager.updateResourceProperties(this.rpoe);
                this.populateTable(this.currentSelectedResource);
            }
            catch (Exception ex) {
                String msg = "Error applying Resources property changes";
                LogManager.logError((String)"RESOURCES", (Throwable)ex, (String)msg);
                ExceptionUtility.showMessage(msg, ex);
            }
        }
        return proceeding;
    }

    private boolean showNeedRestartDialog() {
        boolean proceeding = true;
        RestartToActivateDialog dialog = new RestartToActivateDialog();
        dialog.show();
        proceeding = dialog.wasOKPressed();
        this.showingNeedRestartToActivateDialog = !dialog.doNotShowChecked();
        return proceeding;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public void refresh() {
        boolean continuing = true;
        if (this.havePendingChanges()) {
            continuing = this.finishUp();
        }
        if (continuing) {
            this.populateTable(this.currentSelectedResource);
        }
    }
}

