/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.resources;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

class RestartToActivateDialog
extends JDialog {
    private boolean okPressed = false;
    private JCheckBox doNotShowWarning;

    public RestartToActivateDialog() {
        super((Frame)ConsoleMainFrame.getInstance(), "Server Restart Needed");
        this.setModal(true);
        this.initialize();
    }

    private void initialize() {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        LabelWidget noteLabel = new LabelWidget("Note-- Changes to Resource property values will only take effect at next server restart.");
        this.doNotShowWarning = new CheckBox("In the future, do not show this warning.");
        ButtonWidget okButton = new ButtonWidget("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RestartToActivateDialog.this.okPressed();
            }
        });
        ButtonWidget cancelButton = new ButtonWidget("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RestartToActivateDialog.this.cancelPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 20, 0));
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        this.getContentPane().add(noteLabel);
        this.getContentPane().add(this.doNotShowWarning);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(noteLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 20, 10), 0, 0));
        layout.setConstraints(this.doNotShowWarning, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 4), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 2, 0, 0, 0.0, 0.0, 10, 0, new Insets(10, 4, 4, 4), 0, 0));
        this.pack();
        Dimension size = this.getSize();
        Point loc = StaticUtilities.centerFrame(size);
        this.setLocation(loc);
    }

    private void okPressed() {
        this.okPressed = true;
        this.dispose();
    }

    private void cancelPressed() {
        this.dispose();
    }

    public boolean wasOKPressed() {
        return this.okPressed;
    }

    public boolean doNotShowChecked() {
        return this.doNotShowWarning.isSelected();
    }
}

