/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.runtime.OperationsDelegate;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.VMStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.util.RuntimeMgmtUtils;
import com.metamatrix.console.ui.views.runtime.util.ServiceStateConstants;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public final class OperationsPanel
extends JPanel
implements ServiceStateConstants {
    private static final String START_TEXT = RuntimeMgmtUtils.getString("actionStart");
    private static final String STOP_TEXT = RuntimeMgmtUtils.getString("actionStop");
    private static final String STOP_NOW_TEXT = RuntimeMgmtUtils.getString("actionStopNow");
    private static final String SHOW_ERROR_TEXT = RuntimeMgmtUtils.getString("actionShowServiceError");
    private static final String SHOW_PROCESS_TEXT = RuntimeMgmtUtils.getString("actionShowProcess");
    private static final String SHOW_QUEUES_TEXT = RuntimeMgmtUtils.getString("actionShowQueues");
    private static final String SHOW_QUEUE_TEXT = RuntimeMgmtUtils.getString("actionShowQueue");
    private PanelAction actionStart = new PanelAction(0);
    private PanelAction actionStop = new PanelAction(1);
    private PanelAction actionStopNow = new PanelAction(2);
    private PanelAction actionShowQueue = new PanelAction(3);
    private PanelAction actionShowQueues = new PanelAction(4);
    private PanelAction actionShowProcess = new PanelAction(5);
    private PanelAction actionShowServiceError = new PanelAction(6);
    private MenuEntry startMenueEntry = new MenuEntry("action", this.actionStart);
    private MenuEntry stopMenueEntry = new MenuEntry("action", this.actionStop);
    private MenuEntry stopNowMenueEntry = new MenuEntry("action", this.actionStopNow);
    private MenuEntry showQueueMenueEntry = new MenuEntry("action", this.actionShowQueue);
    private MenuEntry showQueuesMenueEntry = new MenuEntry("action", this.actionShowQueues);
    private MenuEntry showProcessMenueEntry = new MenuEntry("action", this.actionShowProcess);
    private MenuEntry showServiceErrorMenueEntry = new MenuEntry("action", this.actionShowServiceError);
    private ArrayList permanentActions = new ArrayList(7);
    private ArrayList actions = new ArrayList(7);
    private ButtonWidget btnShowQueue = new ButtonWidget();
    private ButtonWidget btnShowProcess = new ButtonWidget();
    private ButtonWidget btnShowQueues = new ButtonWidget();
    private ButtonWidget btnShowServiceError = new ButtonWidget();
    private JPanel pnlOpsSizer;
    private boolean disabled = false;
    private boolean enableShowQueue;
    private ServiceData serviceData = null;
    private ProcessData processData = null;
    private OperationsDelegate delegate;

    public OperationsPanel(OperationsDelegate theDelegate) {
        this.delegate = theDelegate;
        TitledBorder tBorder = new TitledBorder(RuntimeMgmtUtils.getString("op.title"));
        this.pnlOpsSizer = new JPanel(new GridLayout(4, 1, 0, 6));
        this.pnlOpsSizer.setBorder(new CompoundBorder(tBorder, RuntimeMgmtUtils.EMPTY_BORDER));
        this.add(this.pnlOpsSizer);
        ButtonWidget btnStart = new ButtonWidget();
        btnStart.setPreferredSize(new Dimension(90, 25));
        this.actionStart.addComponent(btnStart);
        this.pnlOpsSizer.add(btnStart);
        ButtonWidget btnStop = new ButtonWidget();
        this.actionStop.addComponent(btnStop);
        this.pnlOpsSizer.add(btnStop);
        ButtonWidget btnStopNow = new ButtonWidget();
        this.actionStopNow.addComponent(btnStopNow);
        this.pnlOpsSizer.add(btnStopNow);
        this.actions.add(this.startMenueEntry);
        this.actions.add(this.stopMenueEntry);
        this.actions.add(this.stopNowMenueEntry);
        this.permanentActions.add(this.startMenueEntry);
        this.permanentActions.add(this.stopMenueEntry);
        this.permanentActions.add(this.stopNowMenueEntry);
    }

    public List getActions() {
        return (List)this.actions.clone();
    }

    public void setActionsDisabled() {
        this.setEnabled(new boolean[7]);
        this.disabled = true;
    }

    public void setEnabled(boolean[] theEnableFlags) {
        if (!this.disabled) {
            this.setEnabled(this.actionStart, theEnableFlags[0]);
            this.setEnabled(this.actionStop, theEnableFlags[1]);
            this.setEnabled(this.actionStopNow, theEnableFlags[2]);
        }
    }

    public void setServiceData(ServiceData serviceData) {
        this.serviceData = serviceData;
        this.setEnabledShowQueues(serviceData);
    }

    public void setProcessDate(ProcessData processData) {
        this.processData = processData;
    }

    public void setShowQueue(boolean showQueue) {
        this.enableShowQueue = showQueue;
        this.setEnabledShowQueues(this.serviceData);
    }

    public void setShowProcess(boolean showProcess) {
        this.setEnabledShowProcess(this.processData);
    }

    public void setEnabledShowQueues(ServiceData serviceData) {
        if (this.delegate.isServiceDisplayed(serviceData) || !this.enableShowQueue) {
            this.btnShowQueue.setEnabled(false);
            this.btnShowQueues.setEnabled(false);
            this.setShowQueueEnabled(false);
            this.setShowQueuesEnabled(false);
        } else {
            this.btnShowQueue.setEnabled(true);
            this.btnShowQueues.setEnabled(true);
            this.setShowQueueEnabled(true);
            this.setShowQueuesEnabled(true);
        }
    }

    public void setEnabledShowProcess(ProcessData processData) {
        if (this.delegate.isProcessDisplayed(processData)) {
            this.btnShowProcess.setEnabled(false);
            this.setShowProcessEnabled(false);
        } else if (!processData.isRegistered()) {
            this.btnShowProcess.setEnabled(false);
            this.setShowProcessEnabled(false);
        } else {
            this.btnShowProcess.setEnabled(true);
            this.setShowProcessEnabled(true);
        }
    }

    public void setVisibleProcess(boolean visibleFlag) {
        this.clearOperationsPanel();
        if (visibleFlag) {
            this.actionShowProcess.addComponent(this.btnShowProcess);
            this.pnlOpsSizer.add(this.btnShowProcess);
            this.actions.add(this.showProcessMenueEntry);
        }
        this.pnlOpsSizer.validate();
        this.pnlOpsSizer.repaint();
    }

    public void setVisibleService(boolean visibleFlag, int numberOfQueues, boolean hasError) {
        this.clearOperationsPanel();
        if (visibleFlag) {
            if (numberOfQueues == 1) {
                if (!this.actions.contains(this.showQueueMenueEntry)) {
                    this.actions.add(this.showQueueMenueEntry);
                }
                this.actionShowQueue.addComponent(this.btnShowQueue);
                this.pnlOpsSizer.add(this.btnShowQueue);
            } else if (numberOfQueues > 1) {
                if (!this.actions.contains(this.showQueuesMenueEntry)) {
                    this.actions.add(this.showQueuesMenueEntry);
                }
                this.actionShowQueue.addComponent(this.btnShowQueues);
                this.pnlOpsSizer.add(this.btnShowQueues);
            } else if (hasError) {
                if (!this.actions.contains(this.showServiceErrorMenueEntry)) {
                    this.actions.add(this.showServiceErrorMenueEntry);
                }
                this.actionShowServiceError.addComponent(this.btnShowServiceError);
                this.btnShowServiceError.setEnabled(true);
                this.setEnabled(this.actionShowServiceError, true);
                this.pnlOpsSizer.add(this.btnShowServiceError);
            }
        }
        this.pnlOpsSizer.validate();
        this.pnlOpsSizer.repaint();
    }

    @Override
    public void setEnabled(boolean theEnabledFlag) {
        if (!this.disabled) {
            boolean[] enablements = new boolean[7];
            int i = 0;
            while (i < 7) {
                enablements[i++] = theEnabledFlag;
            }
            this.setEnabled(enablements);
        }
    }

    private void clearOperationsPanel() {
        this.actions.retainAll(this.permanentActions);
        ButtonWidget button = this.getButtonComponent(this.pnlOpsSizer, SHOW_QUEUE_TEXT);
        if (button != null) {
            this.actionShowQueue.removeComponent(this.btnShowQueue);
            this.pnlOpsSizer.remove(this.btnShowQueue);
        }
        if ((button = this.getButtonComponent(this.pnlOpsSizer, SHOW_QUEUES_TEXT)) != null) {
            this.actionShowQueues.removeComponent(this.btnShowQueues);
            this.pnlOpsSizer.remove(this.btnShowQueues);
        }
        if ((button = this.getButtonComponent(this.pnlOpsSizer, SHOW_PROCESS_TEXT)) != null) {
            this.actionShowProcess.removeComponent(this.btnShowProcess);
            this.pnlOpsSizer.remove(this.btnShowProcess);
        }
        if ((button = this.getButtonComponent(this.pnlOpsSizer, SHOW_ERROR_TEXT)) != null) {
            this.actionShowServiceError.removeComponent(this.btnShowServiceError);
            this.pnlOpsSizer.remove(this.btnShowServiceError);
        }
        this.pnlOpsSizer.validate();
        this.pnlOpsSizer.repaint();
    }

    private void setShowQueueEnabled(boolean theEnableFlags) {
        this.setEnabled(this.actionShowQueue, theEnableFlags);
    }

    private void setShowQueuesEnabled(boolean theEnableFlags) {
        this.setEnabled(this.actionShowQueues, theEnableFlags);
    }

    private void setShowProcessEnabled(boolean theEnableFlags) {
        this.setEnabled(this.actionShowProcess, theEnableFlags);
    }

    private void setEnabled(Action theAction, boolean theEnabledFlag) {
        if (!this.disabled) {
            if (theEnabledFlag) {
                if (!theAction.isEnabled()) {
                    theAction.setEnabled(true);
                }
            } else if (theAction.isEnabled()) {
                theAction.setEnabled(false);
            }
        }
    }

    private ButtonWidget getButtonComponent(JPanel pnlOpsSizer2, String buttonText) {
        ButtonWidget theButton = null;
        Component[] components = pnlOpsSizer2.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component aComponent = components[i];
            if (!(aComponent instanceof ButtonWidget) || !((ButtonWidget)aComponent).getText().equals(buttonText)) continue;
            theButton = (ButtonWidget)aComponent;
            break;
        }
        return theButton;
    }

    private class PanelAction
    extends AbstractPanelAction {
        public PanelAction(int theType) {
            super(theType);
            switch (theType) {
                case 0: {
                    this.putValue("Name", START_TEXT);
                    this.putValue("ShortDescription", RuntimeMgmtUtils.getString("actionStart.tip"));
                    break;
                }
                case 1: {
                    this.putValue("Name", STOP_TEXT);
                    this.putValue("ShortDescription", RuntimeMgmtUtils.getString("actionStop.tip"));
                    break;
                }
                case 2: {
                    this.putValue("Name", STOP_NOW_TEXT);
                    this.putValue("ShortDescription", RuntimeMgmtUtils.getString("actionStopNow.tip"));
                    break;
                }
                case 3: {
                    this.putValue("Name", SHOW_QUEUE_TEXT);
                    break;
                }
                case 4: {
                    this.putValue("Name", SHOW_QUEUES_TEXT);
                    break;
                }
                case 5: {
                    this.putValue("Name", SHOW_PROCESS_TEXT);
                    break;
                }
                case 6: {
                    this.putValue("Name", SHOW_ERROR_TEXT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The action type <" + theType + "> is invalid.");
                }
            }
        }

        @Override
        public void actionImpl(ActionEvent theEvent) throws ExternalException {
            switch (this.type) {
                case 0: {
                    OperationsPanel.this.delegate.startOperation();
                    break;
                }
                case 1: {
                    OperationsPanel.this.delegate.stopOperation();
                    break;
                }
                case 2: {
                    OperationsPanel.this.delegate.stopNowOperation();
                    break;
                }
                case 3: 
                case 4: {
                    QueueStatisticsFrame qsFrame = OperationsPanel.this.delegate.startShowQueue(OperationsPanel.this.serviceData);
                    OperationsPanel.this.setEnabledShowQueues(OperationsPanel.this.serviceData);
                    if (qsFrame == null) break;
                    qsFrame.show();
                    break;
                }
                case 5: {
                    VMStatisticsFrame vmsFrame = OperationsPanel.this.delegate.startShowProcess(OperationsPanel.this.processData);
                    OperationsPanel.this.setEnabledShowProcess(OperationsPanel.this.processData);
                    if (vmsFrame == null) break;
                    vmsFrame.show();
                    break;
                }
                case 6: {
                    OperationsPanel.this.delegate.showServcieError();
                    break;
                }
            }
        }

        @Override
        protected void handleError(Exception theException) {
            String emsg = theException.toString();
            boolean showError = true;
            StringTokenizer st = new StringTokenizer(emsg, "\n");
            while (st.hasMoreTokens()) {
                String exceptionLine = st.nextToken();
                if (exceptionLine.indexOf("Is last instance of an essential service") < 0) continue;
                showError = false;
                break;
            }
            if (this.type == 1 && !showError) {
                JOptionPane.showMessageDialog(ConsoleMainFrame.getInstance(), "Cannot stop essential service", "Information", 1);
            } else if (this.type == 2 && !showError) {
                JOptionPane.showMessageDialog(ConsoleMainFrame.getInstance(), "Cannot do \"Stop Now\" for essential service", "Information", 1);
            }
            if (showError) {
                super.handleError(theException);
            }
        }
    }
}

