/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.ui.views.runtime.ConfirmationPanel;
import com.metamatrix.console.ui.views.runtime.OperationsDelegate;
import com.metamatrix.console.ui.views.runtime.OperationsPanel;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.VMStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.util.RuntimeMgmtUtils;
import com.metamatrix.console.ui.views.runtime.util.ServiceStateConstants;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ProcessMgmtPanel
extends DialogPanel
implements ListSelectionListener,
OperationsDelegate,
ServiceStateConstants {
    private static String[] HDRS = new String[5];
    private static final int PROC_COL = 0;
    private static final int ID_COL = 1;
    private static final int REGISTERED_COL = 2;
    private static final int NUM_REG_PSC_COL = 3;
    private static final int NUM_NOT_REG_PSC_COL = 4;
    private TableWidget tbl;
    private OperationsPanel pnlOps;
    private DefaultTableModel tblModel;
    private RuntimeMgmtManager manager;

    public ProcessMgmtPanel(RuntimeMgmtManager mgr) throws ExternalException {
        this.manager = mgr;
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(RuntimeMgmtUtils.EMPTY_BORDER);
        this.tbl = new TableWidget();
        this.tblModel = (DefaultTableModel)this.tbl.getModel();
        this.tblModel.setColumnIdentifiers(HDRS);
        this.tbl.setEditable(false);
        this.tbl.setPreferredScrollableViewportSize(new Dimension(this.tbl.getPreferredSize().width, RuntimeMgmtUtils.getInt("pm.rows", 10) * this.tbl.getRowHeight()));
        this.tbl.setAutoResizeMode(4);
        this.tbl.setSortable(true);
        this.tbl.getSelectionModel().setSelectionMode(0);
        this.tbl.getSelectionModel().addListSelectionListener(this);
        JScrollPane spn = new JScrollPane(this.tbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)spn, gbc);
        this.pnlOps = new OperationsPanel(this);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        pnl.add((Component)this.pnlOps, gbc);
        this.setContent(pnl);
        ButtonWidget btnOk = this.getAcceptButton();
        btnOk.setText(RuntimeMgmtUtils.getString("sm.btnOk"));
        this.removeNavigationButton(this.getCancelButton());
    }

    private ProcessData getSelectedProcess() {
        int row = this.tbl.getSelectedRow();
        return (ProcessData)this.tblModel.getValueAt(row, 0);
    }

    public void load(List theProcesses) throws ExternalException {
        this.tblModel.setNumRows(0);
        if (theProcesses != null && !theProcesses.isEmpty()) {
            int size = theProcesses.size();
            for (int i = 0; i < size; ++i) {
                ProcessData process = (ProcessData)theProcesses.get(i);
                Vector<Object> row = new Vector<Object>(HDRS.length);
                row.setSize(HDRS.length);
                row.setElementAt(process, 0);
                row.setElementAt(process.getName(), 1);
                row.setElementAt(new Boolean(process.isRegistered()), 2);
                Integer[] counts = this.manager.getPscCounts(process);
                row.setElementAt(counts[0], 3);
                row.setElementAt(counts[1], 4);
                this.tblModel.addRow(row);
            }
            this.tbl.setRowSelectionInterval(0, 0);
        }
        this.tbl.sizeColumnsToFitData();
    }

    public void setActionsDisabled() {
        this.pnlOps.setActionsDisabled();
    }

    @Override
    public void startOperation() throws ExternalException {
        ProcessData process = this.getSelectedProcess();
        this.manager.startProcess(process);
    }

    @Override
    public void stopOperation() throws ExternalException {
        ProcessData process = this.getSelectedProcess();
        Object[] processArg = new Object[]{process};
        String msg = "dlg.stopprocess.msg";
        if (this.tblModel.getRowCount() == 1) {
            msg = "dlg.stoponlyprocess.msg";
        }
        ConfirmationPanel pnlConfirm = new ConfirmationPanel(msg, processArg);
        DialogWindow.show(this, RuntimeMgmtUtils.getString("dlg.stopprocess.title", processArg), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.manager.stopProcess(process);
        }
    }

    @Override
    public void stopNowOperation() throws ExternalException {
        ProcessData process = this.getSelectedProcess();
        Object[] processArg = new Object[]{process};
        String msg = "dlg.stopnowprocess.msg";
        if (this.tblModel.getRowCount() == 1) {
            msg = "dlg.stopnowonlyprocess.msg";
        }
        ConfirmationPanel pnlConfirm = new ConfirmationPanel(msg, processArg);
        DialogWindow.show(this, RuntimeMgmtUtils.getString("dlg.stopnowprocess.title", processArg), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.manager.stopProcessNow(process);
        }
    }

    @Override
    public void showServcieError() throws ExternalException {
    }

    @Override
    public QueueStatisticsFrame startShowQueue(ServiceData sd) {
        return null;
    }

    @Override
    public boolean isServiceDisplayed(ServiceData sd) {
        return false;
    }

    @Override
    public void refreshService(ServiceData sd) {
    }

    @Override
    public VMStatisticsFrame startShowProcess(ProcessData pd) {
        return null;
    }

    @Override
    public boolean isProcessDisplayed(ProcessData pd) {
        return false;
    }

    @Override
    public void refreshProcess(ProcessData pd) {
    }

    @Override
    public void valueChanged(ListSelectionEvent theEvent) {
        if (!theEvent.getValueIsAdjusting()) {
            if (this.tbl.getSelectedRowCount() > 0) {
                ProcessData process = this.getSelectedProcess();
                this.pnlOps.setEnabled(RuntimeMgmtUtils.getOperationsEnablements(process));
            } else {
                this.pnlOps.setEnabled(false);
            }
        }
    }

    static {
        ProcessMgmtPanel.HDRS[0] = RuntimeMgmtUtils.getString("pm.proc.hdr");
        ProcessMgmtPanel.HDRS[1] = RuntimeMgmtUtils.getString("pm.id.hdr");
        ProcessMgmtPanel.HDRS[2] = RuntimeMgmtUtils.getString("pm.registered.hdr");
        ProcessMgmtPanel.HDRS[3] = RuntimeMgmtUtils.getString("pm.numregisteredpscs.hdr");
        ProcessMgmtPanel.HDRS[4] = RuntimeMgmtUtils.getString("pm.numnotregisteredpscs.hdr");
    }
}

