/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsDisplayHandler;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsPanel;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

class QueueStatisticsFrame
extends JFrame {
    private static final float MIN_SCREEN_WIDTH_PROPORTION = 0.3f;
    QueueStatisticsDisplayHandler caller;
    QueueStatisticsPanel panel;
    ServiceData sd;

    public QueueStatisticsFrame(QueueStatisticsDisplayHandler cllr, String serviceDisplayName, ServiceData sd, QueueStatisticsPanel pnl) {
        super(serviceDisplayName + " Queue Status");
        this.caller = cllr;
        this.sd = sd;
        this.panel = pnl;
        this.init();
    }

    private void init() {
        this.setIconImage(ViewManager.CONSOLE_ICON_IMAGE);
        GridBagLayout layout = new GridBagLayout();
        layout.setConstraints(this.panel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().setLayout(layout);
        this.getContentPane().add(this.panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                QueueStatisticsFrame.this.dispose();
            }
        });
        this.panel.getCloseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                QueueStatisticsFrame.this.dispose();
            }
        });
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension firstSize = this.getSize();
        int height = firstSize.height;
        int width = Math.max(firstSize.width, (int)((float)screenSize.width * 0.3f));
        this.setSize(width, height);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    public ServiceData getServiceData() {
        return this.sd;
    }

    public QueueStatisticsPanel getPanel() {
        return this.panel;
    }

    @Override
    public void dispose() {
        this.caller.frameClosing(this.sd);
        super.dispose();
    }
}

