/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.views.runtime.QueueStatistics;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsRefreshRequestHandler;
import com.metamatrix.console.ui.views.runtime.SingleQueueStatisticsPanel;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class QueueStatisticsPanel
extends JPanel {
    private ServiceData serviceData;
    private QueueStatisticsRefreshRequestHandler controller;
    private QueueStatistics[] queueStatistics;
    private SingleQueueStatisticsPanel[] subPanels;
    private AbstractButton closeButton;

    public QueueStatisticsPanel(QueueStatisticsRefreshRequestHandler ctrlr, ServiceData sd, QueueStatistics[] queueStat) {
        this.controller = ctrlr;
        this.serviceData = sd;
        this.queueStatistics = queueStat;
        this.init();
    }

    private void init() {
        this.closeButton = new ButtonWidget("Close");
        ButtonWidget refreshButton = new ButtonWidget("Refresh");
        if (this.controller != null) {
            final ServiceData sd = this.serviceData;
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    QueueStatisticsPanel.this.controller.refreshRequested(sd);
                }
            });
        } else {
            refreshButton.setVisible(false);
        }
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.subPanels = new SingleQueueStatisticsPanel[this.queueStatistics.length];
        JPanel statsPanel = new JPanel(new GridLayout(this.subPanels.length, 1, 0, 4));
        for (int i = 0; i < this.queueStatistics.length; ++i) {
            this.subPanels[i] = new SingleQueueStatisticsPanel(this.queueStatistics[i].getQueueName());
            this.subPanels[i].populate(new Integer(this.queueStatistics[i].getCurrentSize()), new Integer(this.queueStatistics[i].getHighestSize()), new Integer(this.queueStatistics[i].getTotalEnqueued()), new Integer(this.queueStatistics[i].getTotalDequeued()), new Integer(this.queueStatistics[i].getNumThreads()));
            statsPanel.add(this.subPanels[i]);
        }
        this.add(statsPanel);
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 40, 0));
        buttonsPanel.add(refreshButton);
        buttonsPanel.add(this.closeButton);
        this.add(buttonsPanel);
        layout.setConstraints(statsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void repopulate(QueueStatistics[] queueStat) {
        this.queueStatistics = queueStat;
        for (int i = 0; i < this.subPanels.length; ++i) {
            String subPanelQueueName = this.subPanels[i].getQueueName();
            int matchLoc = -1;
            int j = 0;
            while (j < this.queueStatistics.length && matchLoc < 0) {
                if (this.queueStatistics[j].getQueueName().equals(subPanelQueueName)) {
                    matchLoc = j;
                    continue;
                }
                ++j;
            }
            if (matchLoc < 0) {
                this.subPanels[i].populate(null, null, null, null, null);
                continue;
            }
            this.subPanels[i].populate(new Integer(this.queueStatistics[matchLoc].getCurrentSize()), new Integer(this.queueStatistics[matchLoc].getHighestSize()), new Integer(this.queueStatistics[matchLoc].getTotalEnqueued()), new Integer(this.queueStatistics[matchLoc].getTotalDequeued()), new Integer(this.queueStatistics[matchLoc].getNumThreads()));
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }
}

