/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.runtime.QueueStatistics;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsDisplayHandler;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsRefreshRequestHandler;
import com.metamatrix.console.ui.views.runtime.VMStatisticsDisplayHandler;
import com.metamatrix.console.ui.views.runtime.util.ServiceStateConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class QueueStatisticsRefreshRequestHandlerImp
implements QueueStatisticsRefreshRequestHandler,
ServiceStateConstants {
    private QueueStatisticsDisplayHandler qsdh;
    private VMStatisticsDisplayHandler vmsdh;
    private boolean refreshFlag = false;
    private ServiceData currentServiceData = null;
    private ConnectionInfo connection;

    public QueueStatisticsRefreshRequestHandlerImp(ConnectionInfo conn) {
        this.connection = conn;
    }

    @Override
    public void refreshRequested(ServiceData sd) {
        this.refreshFlag = true;
        try {
            QueueStatistics[] qss;
            if (this.currentServiceData != null && this.currentServiceData.getCurrentState() != sd.getCurrentState() && this.currentServiceData.getServiceID().equals((Object)sd.getServiceID())) {
                sd = this.currentServiceData;
            }
            if ((qss = this.getQueueStatistics(sd)).length != 0) {
                this.qsdh.refreshDisplayForService(sd.getName(), sd, qss);
            }
            this.refreshFlag = false;
        }
        catch (Exception theException) {
            this.logException(theException, "QueueStatisticsRefreshRequestHandlerImp.refreshRequested");
        }
    }

    @Override
    public void refreshProcessRequested(ProcessData pd) {
        try {
            if (this.getProcessStatistics(pd) != null) {
                ProcessStatistics vmstats = this.getProcessStatistics(pd);
                this.vmsdh.refreshDisplayForProcess(pd.getName(), pd, vmstats);
            }
        }
        catch (Exception theException) {
            this.logException(theException, "QueueStatisticsRefreshRequestHandlerImp.refreshRequested");
        }
    }

    @Override
    public void runGarbageCollection(ProcessData pd) {
    }

    private RuntimeStateAdminAPI getAdminAPI() {
        RuntimeStateAdminAPI api = null;
        try {
            api = ModelManager.getRuntimeStateAPI(this.connection);
        }
        catch (Exception theException) {
            this.logException(theException, "QueueStatisticsRefreshRequestHandlerImp.getAdminAPI");
        }
        return api;
    }

    public boolean isRefresh() {
        return this.refreshFlag;
    }

    public void setServiceData(ServiceData s) {
        this.currentServiceData = s;
    }

    public QueueStatistics[] getQueueStatistics(ServiceData sd) {
        Collection serviceCollection = null;
        serviceCollection = this.getServiceCollection(sd);
        QueueStatistics[] qss = new QueueStatistics[serviceCollection.size()];
        if (serviceCollection.isEmpty()) {
            return qss;
        }
        if (serviceCollection != null) {
            Iterator iter = serviceCollection.iterator();
            int i = 0;
            while (i < serviceCollection.size()) {
                if (!iter.hasNext()) continue;
                WorkerPoolStats wps = (WorkerPoolStats)iter.next();
                qss[i] = new QueueStatistics(wps.name, wps.queued, 0, (int)wps.totalSubmitted, (int)wps.totalCompleted, wps.threads);
                ++i;
            }
        }
        return qss;
    }

    public HashMap getServiceMap(ArrayList serviceList) {
        HashMap<ServiceData, Integer> serviceHM = new HashMap<ServiceData, Integer>();
        Collection sqs = null;
        for (ServiceData sd : serviceList) {
            int state = sd.getCurrentState();
            if (state == 1 || state == 3) {
                sqs = this.getServiceCollection(sd);
            }
            if (sqs != null) {
                serviceHM.put(sd, new Integer(sqs.size()));
                continue;
            }
            serviceHM.put(sd, new Integer(0));
        }
        return serviceHM;
    }

    private Collection getServiceCollection(ServiceData sd) {
        Collection sqs = null;
        if (this.refreshFlag && sd.getCurrentState() != 1) {
            if (sd.getCurrentState() == 3) {
                JOptionPane.showMessageDialog(ConsoleMainFrame.getInstance(), "Service " + sd.getName() + "currently suspended. " + "Queue statistics is unavailable", "Information", 1);
            } else {
                JOptionPane.showMessageDialog(ConsoleMainFrame.getInstance(), "Service " + sd.getName() + "currently stopped. " + "Queue statistics is unavailable", "Information", 1);
            }
            QueueStatisticsFrame qsd = (QueueStatisticsFrame)this.qsdh.getDialogs().get(sd);
            qsd.dispose();
            return Collections.EMPTY_SET;
        }
        try {
            sqs = this.getAdminAPI().getServiceQueueStatistics(sd.getServiceID());
        }
        catch (Exception theException) {
            this.displayException(theException, "QueueStatisticsRefreshRequestHandlerImp.getServiceCollection");
        }
        return sqs;
    }

    public ProcessStatistics getProcessStatistics(ProcessData pd) {
        try {
            return this.getAdminAPI().getProcessStatistics(pd.getHostName(), pd.getName());
        }
        catch (Exception theException) {
            this.displayException(theException, "QueueStatisticsRefreshRequestHandlerImp.getVMStatistics");
            return null;
        }
    }

    public void setDisplayHandler(QueueStatisticsDisplayHandler qsdh) {
        this.qsdh = qsdh;
    }

    public void setDisplayVMHandler(VMStatisticsDisplayHandler vmsdh) {
        this.vmsdh = vmsdh;
    }

    private void logException(Exception theException, String messageCode) {
        String message = ConsolePlugin.Util.getString(messageCode);
        LogManager.logError((String)"RUNTIME", (Throwable)theException, (String)message);
    }

    private void displayException(Exception theException, String messageCode) {
        String message = ConsolePlugin.Util.getString(messageCode);
        ExceptionUtility.showMessage("", message, theException);
        LogManager.logError((String)"RUNTIME", (Throwable)theException, (String)message);
    }
}

