/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.connections.ConnectionProcessor;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.runtime.ConfirmationPanel;
import com.metamatrix.console.ui.views.runtime.OperationsDelegate;
import com.metamatrix.console.ui.views.runtime.OperationsPanel;
import com.metamatrix.console.ui.views.runtime.ProcessMgmtPanel;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsDisplayHandler;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsRefreshRequestHandlerImp;
import com.metamatrix.console.ui.views.runtime.RuntimeStateCellRenderer;
import com.metamatrix.console.ui.views.runtime.ServiceMgmtPanel;
import com.metamatrix.console.ui.views.runtime.VMStatisticsDisplayHandler;
import com.metamatrix.console.ui.views.runtime.VMStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.model.HostStatistics;
import com.metamatrix.console.ui.views.runtime.model.RuntimeMgmtModel;
import com.metamatrix.console.ui.views.runtime.model.StatisticsConstants;
import com.metamatrix.console.ui.views.runtime.util.RuntimeMgmtUtils;
import com.metamatrix.console.ui.views.runtime.util.ServiceStateConstants;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.TreeWidget;
import com.metamatrix.toolbox.ui.widget.menu.DefaultPopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class RuntimeMgmtPanel
extends JPanel
implements OperationsDelegate,
StatisticsConstants,
ServiceStateConstants,
TreeModelListener,
TreeSelectionListener,
WorkspacePanel,
AutoRefreshable {
    private static String[] PROC_STATS_HDRS;
    private static String[] SERV_STATS_HDRS;
    private static final double SPLIT_INIT;
    private TreeMenuFactory servicePopQueuesTree = null;
    private TreeMenuFactory servicePopQueueTree = null;
    private TreeMenuFactory processPopupTree = null;
    private boolean iSSyncing = false;
    private Object mutex = new Object();
    private AutoRefresher arRefresher;
    private TreeWidget tree;
    private TreeMenuFactory popTree;
    private TableWidget tblProcStats;
    private TableWidget tblServStats;
    private TextFieldWidget txfLastChange;
    private OperationsPanel pnlOps;
    private ServiceMgmtPanel pnlServMgmt;
    private ProcessMgmtPanel pnlProcMgmt;
    private ConnectionInfo connection;
    private ArrayList actions = new ArrayList();
    private PanelAction actionShutdown = new PanelAction(0);
    private PanelAction actionBounce = new PanelAction(1);
    private PanelAction actionSynch = new PanelAction(3);
    private DefaultTableModel procsTblModel;
    private DefaultTableModel servsTblModel;
    private QueueStatisticsDisplayHandler qsdh;
    private VMStatisticsDisplayHandler vmdh;
    private QueueStatisticsRefreshRequestHandlerImp qsrh;
    private RuntimeMgmtModel treeModel;
    private HashMap serviceHM;
    private ArrayList serviceList;
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent theEvent) {
            JTable tbl = (JTable)theEvent.getSource();
            Point p = new Point(theEvent.getX(), theEvent.getY());
            int row = tbl.rowAtPoint(p);
            int col = tbl.convertColumnIndexToModel(tbl.columnAtPoint(p));
            if (col != 0 && col != 0 && theEvent.getClickCount() == 2) {
                if (tbl == RuntimeMgmtPanel.this.tblProcStats) {
                    RuntimeMgmtPanel.this.showProcessDetails(row, col);
                } else {
                    RuntimeMgmtPanel.this.showServiceDetails(row, col);
                }
            }
        }
    };
    private Map hostStats;
    private Object lastSelectedObj;
    private boolean disabled = false;

    public RuntimeMgmtPanel(ConnectionInfo conn) throws ExternalException {
        this.connection = conn;
        this.setLayout(new GridBagLayout());
        this.setBorder(RuntimeMgmtUtils.EMPTY_BORDER);
        this.construct();
        try {
            if (!UserCapabilities.getInstance().canPerformRuntimeOperations(this.connection)) {
                this.setActionsDisabled();
                this.pnlOps.setActionsDisabled();
                this.disabled = true;
            }
        }
        catch (Exception theException) {
            throw new ExternalException("RuntimeMgmtPanel:init", theException);
        }
    }

    private RuntimeMgmtManager getRuntimeMgmtManager() {
        return ModelManager.getRuntimeMgmtManager(this.connection);
    }

    private void bounce() throws ExternalException {
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.bounceserver.msg");
        DialogWindow.show(this, RuntimeMgmtPanel.getString("dlg.bounceserver.title"), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            StaticUtilities.startWait(this);
            this.getRuntimeMgmtManager().bounceServer();
            StaticUtilities.endWait(this);
            ModelManager.getConfigurationManager(this.connection).setRefreshNeeded();
        }
    }

    private void construct() throws ExternalException {
        JPanel pnlLastChange = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 13;
        this.add((Component)pnlLastChange, gbc);
        LabelWidget lblLastChange = new LabelWidget(RuntimeMgmtPanel.getString("lblLastChange"));
        pnlLastChange.add(lblLastChange);
        this.txfLastChange = RuntimeMgmtUtils.createTextField("timestamp");
        this.txfLastChange.setEditable(false);
        pnlLastChange.add(this.txfLastChange);
        Splitter split = new Splitter(0){
            boolean init;
            {
                this.init = false;
            }

            @Override
            public void paint(Graphics theGraphics) {
                if (!this.init) {
                    this.setDividerLocation(SPLIT_INIT);
                }
                this.init = true;
                super.paint(theGraphics);
            }
        };
        split.setOneTouchExpandable(true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)split, gbc);
        JPanel pnlTree = new JPanel(new GridBagLayout());
        GridBagConstraints gbcTreePanel = new GridBagConstraints();
        pnlTree.setMinimumSize(new Dimension(0, 0));
        TitledBorder tBorder = new TitledBorder(RuntimeMgmtPanel.getString("pnlTree.title"));
        pnlTree.setBorder(new CompoundBorder(tBorder, RuntimeMgmtUtils.EMPTY_BORDER));
        split.setTopComponent(pnlTree);
        this.tree = new TreeWidget(){

            @Override
            public String getToolTipText(MouseEvent theEvent) {
                TreePath path = RuntimeMgmtPanel.this.tree.getPathForLocation(theEvent.getX(), theEvent.getY());
                if (path == null) {
                    return null;
                }
                DefaultTreeNode node = (DefaultTreeNode)path.getLastPathComponent();
                Object userObj = node.getContent();
                if (userObj instanceof ServiceData) {
                    return RuntimeMgmtUtils.getServiceStateToolTip((ServiceData)userObj);
                }
                return null;
            }
        };
        this.tree.setVisibleRowCount(RuntimeMgmtUtils.getInt("tree.rows", 15));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setMinimumSize(this.tree.getPreferredSize());
        this.tree.setCellRenderer(new RuntimeStateCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.tree.setPopupMenuFactory(this.popTree);
        this.treeModel = new RuntimeMgmtModel(this.connection);
        this.tree.setModel(this.treeModel);
        this.treeModel.addTreeModelListener(this);
        JScrollPane spnTree = new JScrollPane(this.tree);
        gbcTreePanel.gridx = 0;
        gbcTreePanel.gridy = 0;
        gbcTreePanel.anchor = 17;
        gbcTreePanel.fill = 1;
        gbcTreePanel.weightx = 0.9;
        gbcTreePanel.weighty = 0.9;
        pnlTree.add((Component)spnTree, gbcTreePanel);
        this.pnlOps = new OperationsPanel(this);
        gbcTreePanel.gridx = 1;
        gbcTreePanel.fill = 0;
        gbcTreePanel.weightx = 0.1;
        gbcTreePanel.weighty = 0.1;
        gbcTreePanel.insets = new Insets(5, 5, 5, 5);
        pnlTree.add((Component)this.pnlOps, gbcTreePanel);
        JPanel pnlStats = new JPanel(new GridLayout(1, 1));
        pnlStats.setMinimumSize(new Dimension(0, 0));
        tBorder = new TitledBorder(RuntimeMgmtPanel.getString("pnlStats.title"));
        pnlStats.setBorder(new CompoundBorder(tBorder, RuntimeMgmtUtils.EMPTY_BORDER));
        split.setBottomComponent(pnlStats);
        JTabbedPane tpnStats = new JTabbedPane();
        pnlStats.add(tpnStats);
        this.tblProcStats = new TableWidget();
        this.procsTblModel = (DefaultTableModel)this.tblProcStats.getModel();
        this.procsTblModel.setColumnIdentifiers(PROC_STATS_HDRS);
        this.tblProcStats.setEditable(false);
        this.tblProcStats.setPreferredScrollableViewportSize(new Dimension(this.tblProcStats.getPreferredSize().width, RuntimeMgmtPanel.getInt("statstblrows", 10) * this.tblProcStats.getRowHeight()));
        this.tblProcStats.setCellSelectionEnabled(true);
        this.tblProcStats.setAutoResizeMode(4);
        this.tblProcStats.setSortable(true);
        this.tblProcStats.getSelectionModel().setSelectionMode(0);
        this.tblProcStats.addMouseListener(this.mouseListener);
        JScrollPane spnProcStats = new JScrollPane(this.tblProcStats);
        tpnStats.addTab(RuntimeMgmtPanel.getString("processstats.tab"), spnProcStats);
        this.tblServStats = new TableWidget();
        this.servsTblModel = (DefaultTableModel)this.tblServStats.getModel();
        this.servsTblModel.setColumnIdentifiers(SERV_STATS_HDRS);
        this.tblServStats.setEditable(false);
        this.tblServStats.setPreferredScrollableViewportSize(new Dimension(this.tblServStats.getPreferredSize().width, RuntimeMgmtPanel.getInt("statstblrows", 10) * this.tblServStats.getRowHeight()));
        this.tblServStats.setCellSelectionEnabled(true);
        this.tblServStats.setAutoResizeMode(4);
        this.tblServStats.setSortable(true);
        this.tblServStats.getSelectionModel().setSelectionMode(0);
        this.tblServStats.addMouseListener(this.mouseListener);
        JScrollPane spnServStats = new JScrollPane(this.tblServStats);
        tpnStats.addTab(RuntimeMgmtPanel.getString("servicestats.tab"), spnServStats);
        this.qsrh = new QueueStatisticsRefreshRequestHandlerImp(this.connection);
        this.qsdh = new QueueStatisticsDisplayHandler(this.qsrh);
        this.vmdh = new VMStatisticsDisplayHandler(this.qsrh);
        this.qsrh.setDisplayVMHandler(this.vmdh);
        this.qsrh.setDisplayHandler(this.qsdh);
        this.qsdh.setOperationsPnl(this.pnlOps);
        this.vmdh.setOperationsPnl(this.pnlOps);
        this.actions.add(new MenuEntry("action", this.actionBounce));
        this.actions.add(new MenuEntry("action", this.actionShutdown));
        this.actions.add(new MenuEntry("action", this.actionSynch));
        this.pnlOps.setVisibleService(false, 0, false);
        this.popTree = new TreeMenuFactory(this.tree, this.pnlOps.getActions());
        this.tree.setPopupMenuFactory(this.popTree);
        this.arRefresher = new AutoRefresher(this, 15, true, this.connection);
        this.arRefresher.init();
        this.arRefresher.startTimer();
    }

    public static int getInt(String theKey, int theDefault) {
        return RuntimeMgmtUtils.getInt(theKey, theDefault);
    }

    private DefaultTreeNode getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        return path == null ? null : (DefaultTreeNode)path.getLastPathComponent();
    }

    private static String getString(String theKey) {
        return RuntimeMgmtUtils.getString(theKey);
    }

    private static String getString(String theKey, Object[] value) {
        return RuntimeMgmtUtils.getString(theKey, value);
    }

    @Override
    public String getTitle() {
        return RuntimeMgmtPanel.getString("systemstatetitle");
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void refresh() {
        this.treeModel.refresh();
    }

    @Override
    public List resume() {
        DefaultTreeNode node = this.getSelectedNode();
        if (node != null) {
            Object userObj;
            this.lastSelectedObj = userObj = node.getContent();
        }
        this.refresh();
        List clone = (List)this.actions.clone();
        List opsActions = this.pnlOps.getActions();
        if (!opsActions.isEmpty()) {
            clone.add(MenuEntry.DEFAULT_SEPARATOR);
            clone.addAll(opsActions);
        }
        return clone;
    }

    private void selectNode(DefaultTreeNode theNode) {
        ArrayList<DefaultTreeNode> pathNodes = new ArrayList<DefaultTreeNode>();
        pathNodes.add(theNode);
        for (DefaultTreeNode parent = theNode.getParent(); parent != null; parent = parent.getParent()) {
            pathNodes.add(parent);
        }
        Collections.reverse(pathNodes);
        TreePath path = new TreePath(pathNodes.toArray());
        this.tree.setSelectionPath(path);
        this.tree.scrollRowToVisible(this.tree.getRowForPath(path));
    }

    private void setActionsDisabled() {
        this.actionShutdown.setEnabled(false);
        this.actionBounce.setEnabled(false);
        this.actionSynch.setEnabled(false);
    }

    private void setLastChangeDate(Map theStats) {
        SimpleDateFormat formatter = StaticUtilities.getDefaultDateFormat();
        this.txfLastChange.setText(formatter.format(this.treeModel.getLastChangeDate()));
    }

    private void showProcessDetails(int theRow, int theColumn) {
        HostData host = (HostData)this.tblProcStats.getValueAt(theRow, 0);
        HostStatistics stats = (HostStatistics)this.hostStats.get(host);
        List procs = null;
        String title = "";
        if (theColumn == 2) {
            procs = stats.getSynchedProcesses();
            title = RuntimeMgmtPanel.getString("sm.title.synched");
        } else if (theColumn == 3) {
            procs = stats.getNotRegisteredProcesses();
            title = RuntimeMgmtPanel.getString("sm.title.notregistered");
        } else if (theColumn == 4) {
            procs = stats.getNotDeployedProcesses();
            title = RuntimeMgmtPanel.getString("sm.title.notdeployed");
        } else if (theColumn == 1) {
            procs = stats.getProcesses();
            title = RuntimeMgmtPanel.getString("sm.title.all");
        }
        if (!procs.isEmpty()) {
            try {
                if (this.pnlProcMgmt == null) {
                    RuntimeMgmtManager manager = ModelManager.getRuntimeMgmtManager(this.connection);
                    this.pnlProcMgmt = new ProcessMgmtPanel(manager);
                    if (this.disabled) {
                        this.pnlProcMgmt.setActionsDisabled();
                    }
                }
                this.pnlProcMgmt.load(procs);
                DialogWindow.show(this, RuntimeMgmtUtils.getString("pm.title", new Object[]{title, host}), this.pnlProcMgmt);
            }
            catch (Exception theException) {
                ExceptionUtility.showMessage(RuntimeMgmtUtils.getString("msg.configmgrproblem", new Object[]{this.getClass().getName(), "showProcessDetails"}), theException.getMessage(), theException);
                LogManager.logError((String)"RUNTIME", (Throwable)theException, (String)(this.getClass().getName() + "showProcessDetails"));
            }
        }
    }

    private void showServiceDetails(int theRow, int theColumn) {
        HostData host = (HostData)this.tblProcStats.getValueAt(theRow, 0);
        HostStatistics stats = (HostStatistics)this.hostStats.get(host);
        List servs = null;
        String title = "";
        if (theColumn == 2) {
            servs = stats.getSynchedServices();
            title = RuntimeMgmtPanel.getString("sm.title.running");
        } else if (theColumn == 3) {
            servs = stats.getSynchedServices();
            title = RuntimeMgmtPanel.getString("sm.title.synched");
        } else if (theColumn == 4) {
            servs = stats.getNotRegisteredServices();
            title = RuntimeMgmtPanel.getString("sm.title.notregistered");
        } else if (theColumn == 5) {
            servs = stats.getNotDeployedServices();
            title = RuntimeMgmtPanel.getString("sm.title.notdeployed");
        } else if (theColumn == 6) {
            servs = stats.getFailedServices();
            title = RuntimeMgmtPanel.getString("sm.title.failed");
        } else if (theColumn == 7) {
            servs = stats.getStoppedServices();
            title = RuntimeMgmtPanel.getString("sm.title.stopped");
        } else if (theColumn == 8) {
            servs = stats.getInitFailedServices();
            title = RuntimeMgmtPanel.getString("sm.title.initfailed");
        } else if (theColumn == 9) {
            servs = stats.getNotInitServices();
            title = RuntimeMgmtPanel.getString("sm.title.notstarted");
        } else if (theColumn == 1) {
            servs = stats.getServices();
            title = RuntimeMgmtPanel.getString("sm.title.all");
        }
        if (!servs.isEmpty()) {
            if (this.pnlServMgmt == null) {
                this.pnlServMgmt = new ServiceMgmtPanel(this.getRuntimeMgmtManager());
                if (this.disabled) {
                    this.pnlServMgmt.setActionsDisabled();
                }
            }
            this.pnlServMgmt.load(servs);
            DialogWindow.show(this, RuntimeMgmtUtils.getString("sm.title", new Object[]{title, host}), this.pnlServMgmt);
        }
    }

    private void shutdown() throws ExternalException {
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.shutdown.msg");
        DialogWindow.show(this, RuntimeMgmtPanel.getString("dlg.shutdown.title"), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            ConnectionInfo connection = this.getConnection();
            this.getRuntimeMgmtManager().shutdownServer();
            ModelManager.removeConnectionLo(connection);
            if (ModelManager.getNumberofConnections() < 1) {
                ConsoleMainFrame.getInstance().exitConsole();
            } else {
                ConnectionProcessor cp = ConnectionProcessor.getInstance();
                cp.removeConnection(connection);
            }
        }
    }

    @Override
    public void startOperation() throws ExternalException {
        Object userObj;
        DefaultTreeNode node = this.getSelectedNode();
        this.lastSelectedObj = userObj = node.getContent();
        if (userObj instanceof ServiceData) {
            this.getRuntimeMgmtManager().startService((ServiceData)userObj);
        } else if (userObj instanceof ProcessData) {
            this.getRuntimeMgmtManager().startProcess((ProcessData)userObj);
        } else if (userObj instanceof PSCData) {
            this.getRuntimeMgmtManager().startPsc((PSCData)userObj);
        } else if (userObj instanceof HostData) {
            this.getRuntimeMgmtManager().startHost((HostData)userObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopOperation() throws ExternalException {
        Object userObj;
        String msgId = null;
        String titleId = null;
        DefaultTreeNode node = this.getSelectedNode();
        this.lastSelectedObj = userObj = node.getContent();
        if (userObj instanceof ServiceData) {
            msgId = "dlg.stopservice.msg";
            titleId = "dlg.stopservice.title";
        } else if (userObj instanceof ProcessData) {
            Number number;
            msgId = "dlg.stopprocess.msg";
            if (this.procsTblModel.getRowCount() == 1 && (number = (Number)this.procsTblModel.getValueAt(0, 1)).intValue() == 1) {
                msgId = "dlg.stoponlyprocess.msg";
            }
            titleId = "dlg.stopprocess.title";
        } else if (userObj instanceof PSCData) {
            msgId = "dlg.stoppsc.msg";
            titleId = "dlg.stoppsc.title";
        } else if (userObj instanceof HostData) {
            msgId = this.procsTblModel.getRowCount() == 1 ? "dlg.stoponlyhost.msg" : "dlg.stophost.msg";
            titleId = "dlg.stophost.title";
        }
        ConfirmationPanel pnlConfirm = new ConfirmationPanel(msgId, new Object[]{userObj});
        DialogWindow.show(this, RuntimeMgmtPanel.getString(titleId, new Object[]{userObj}), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            try {
                StaticUtilities.startWait(this);
                if (userObj instanceof ServiceData) {
                    this.getRuntimeMgmtManager().stopService((ServiceData)userObj);
                } else if (userObj instanceof ProcessData) {
                    this.getRuntimeMgmtManager().stopProcess((ProcessData)userObj);
                } else if (userObj instanceof PSCData) {
                    this.getRuntimeMgmtManager().stopPsc((PSCData)userObj);
                } else if (userObj instanceof HostData) {
                    this.getRuntimeMgmtManager().stopHost((HostData)userObj);
                }
            }
            finally {
                StaticUtilities.endWait(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopNowOperation() throws ExternalException {
        Object userObj;
        String msgId = null;
        String titleId = null;
        DefaultTreeNode node = this.getSelectedNode();
        this.lastSelectedObj = userObj = node.getContent();
        if (userObj instanceof ServiceData) {
            msgId = "dlg.stopnowservice.msg";
            titleId = "dlg.stopnowservice.title";
        } else if (userObj instanceof ProcessData) {
            Number number;
            msgId = "dlg.stopnowprocess.msg";
            if (this.procsTblModel.getRowCount() == 1 && (number = (Number)this.procsTblModel.getValueAt(0, 1)).intValue() == 1) {
                msgId = "dlg.stopnowonlyprocess.msg";
            }
            titleId = "dlg.stopnowprocess.title";
        } else if (userObj instanceof PSCData) {
            msgId = "dlg.stopnowpsc.msg";
            titleId = "dlg.stopnowpsc.title";
        } else if (userObj instanceof HostData) {
            msgId = this.procsTblModel.getRowCount() == 1 ? "dlg.stopnowonlyhost.msg" : "dlg.stopnowhost.msg";
            titleId = "dlg.stopnowhost.title";
        }
        ConfirmationPanel pnlConfirm = new ConfirmationPanel(msgId, new Object[]{userObj});
        DialogWindow.show(this, RuntimeMgmtPanel.getString(titleId, new Object[]{userObj}), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            try {
                StaticUtilities.startWait(this);
                if (userObj instanceof ServiceData) {
                    this.getRuntimeMgmtManager().stopServiceNow((ServiceData)userObj);
                } else if (userObj instanceof ProcessData) {
                    this.getRuntimeMgmtManager().stopProcessNow((ProcessData)userObj);
                } else if (userObj instanceof PSCData) {
                    this.getRuntimeMgmtManager().stopPscNow((PSCData)userObj);
                } else if (userObj instanceof HostData) {
                    this.getRuntimeMgmtManager().stopHostNow((HostData)userObj);
                }
            }
            finally {
                StaticUtilities.endWait(this);
            }
        }
    }

    @Override
    public void showServcieError() throws ExternalException {
        ServiceData data;
        Object userObj;
        Throwable theError = null;
        String titleId = null;
        DefaultTreeNode node = this.getSelectedNode();
        this.lastSelectedObj = userObj = node.getContent();
        if (userObj != null && userObj instanceof ServiceData && (theError = (data = (ServiceData)userObj).getInitError()) != null) {
            titleId = "dlg.showserviceError.title";
            String errorMsg = theError.getMessage();
            if (errorMsg == null || errorMsg.length() == 0) {
                errorMsg = "Error message was null.";
            }
            ExceptionUtility.showMessage(RuntimeMgmtPanel.getString(titleId, new Object[]{userObj}), errorMsg, theError);
        }
    }

    private void synch() throws ExternalException {
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.synch.msg");
        DialogWindow.show(this, RuntimeMgmtPanel.getString("dlg.synch.title"), pnlConfirm);
        this.paintImmediately(this.getBounds());
        if (!this.iSSyncing && pnlConfirm.isConfirmed()) {
            Thread thread = new Thread("console-synchronize"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        StaticUtilities.startWait(RuntimeMgmtPanel.this);
                        Object object = RuntimeMgmtPanel.this.mutex;
                        synchronized (object) {
                            RuntimeMgmtPanel.this.iSSyncing = true;
                            RuntimeMgmtPanel.this.getRuntimeMgmtManager().synchronizeServer();
                            ModelManager.getConfigurationManager(RuntimeMgmtPanel.this.connection).setRefreshNeeded();
                        }
                    }
                    catch (ExternalException e) {
                        ExceptionUtility.showMessage(RuntimeMgmtUtils.getString("msg.configmgrproblem", new Object[]{this.getClass().getName(), "showProcessDetails"}), e.getMessage(), (Throwable)((Object)e));
                        LogManager.logError((String)"RUNTIME", (Throwable)((Object)e), (String)(this.getClass().getName() + "showProcessDetails"));
                    }
                    finally {
                        RuntimeMgmtPanel.this.iSSyncing = false;
                        StaticUtilities.endWait(RuntimeMgmtPanel.this);
                    }
                }
            };
            thread.start();
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent theEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent theEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent theEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent theEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object userObj;
                RuntimeMgmtPanel.this.hostStats = RuntimeMgmtPanel.this.treeModel.getStatistics();
                RuntimeMgmtPanel.this.serviceList = RuntimeMgmtPanel.this.treeModel.getServiceList();
                RuntimeMgmtPanel.this.procsTblModel.setNumRows(0);
                RuntimeMgmtPanel.this.servsTblModel.setNumRows(0);
                if (RuntimeMgmtPanel.this.hostStats != null) {
                    for (HostStatistics stats : RuntimeMgmtPanel.this.hostStats.values()) {
                        RuntimeMgmtPanel.this.procsTblModel.addRow(stats.getProcessStats());
                        RuntimeMgmtPanel.this.servsTblModel.addRow(stats.getServiceStats());
                    }
                }
                RuntimeMgmtPanel.this.tblProcStats.sizeColumnsToFitData();
                RuntimeMgmtPanel.this.tblServStats.sizeColumnsToFitData();
                RuntimeMgmtPanel.this.setLastChangeDate(RuntimeMgmtPanel.this.hostStats);
                DefaultTreeNode node = RuntimeMgmtPanel.this.treeModel.getUserObjectNode(RuntimeMgmtPanel.this.lastSelectedObj);
                StaticTreeUtilities.expandAll(RuntimeMgmtPanel.this.tree);
                if (node != null && node.getContent() != null && (userObj = node.getContent()) instanceof ServiceData) {
                    RuntimeMgmtPanel.this.pnlOps.setServiceData((ServiceData)userObj);
                }
                if (RuntimeMgmtPanel.this.tree.getRowCount() > 0) {
                    if (node == null) {
                        RuntimeMgmtPanel.this.tree.setSelectionRow(0);
                    } else {
                        RuntimeMgmtPanel.this.selectNode(node);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public ArrayList getRunningList() {
        ArrayList<ServiceData> serviceRunningList = new ArrayList<ServiceData>();
        for (ServiceData sd : this.serviceList) {
            int state = sd.getCurrentState();
            if (state != 1 && state != 3) continue;
            serviceRunningList.add(sd);
        }
        return serviceRunningList;
    }

    @Override
    public QueueStatisticsFrame startShowQueue(ServiceData sd) throws ExternalException {
        try {
            return this.qsdh.startDisplayForService(sd.getName(), sd, this.qsrh.getQueueStatistics(sd));
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    @Override
    public VMStatisticsFrame startShowProcess(ProcessData pd) {
        if (this.vmdh != null && this.qsrh.getProcessStatistics(pd) != null) {
            return this.vmdh.startDisplayForProcess(pd.getName(), pd, this.qsrh.getProcessStatistics(pd));
        }
        return null;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public void refreshService(ServiceData sd) {
        this.qsrh.refreshRequested(sd);
    }

    @Override
    public void refreshProcess(ProcessData pd) {
        this.qsrh.refreshProcessRequested(pd);
    }

    @Override
    public boolean isProcessDisplayed(ProcessData pd) {
        return this.vmdh.isProcessDisplayed(pd);
    }

    @Override
    public boolean isServiceDisplayed(ServiceData sd) {
        return this.qsdh.isServiceDisplayed(sd);
    }

    @Override
    public void valueChanged(TreeSelectionEvent theEvent) {
        if (this.serviceHM == null) {
            this.serviceHM = this.qsrh.getServiceMap(this.getRunningList());
        }
        if (this.tree.isSelectionEmpty()) {
            this.pnlOps.setEnabled(false);
        } else {
            TreePath path = theEvent.getNewLeadSelectionPath();
            DefaultTreeNode node = (DefaultTreeNode)path.getLastPathComponent();
            Object userObj = node.getContent();
            boolean[] enablements = new boolean[7];
            if (userObj instanceof ServiceData) {
                enablements = this.nodeSelected((ServiceData)userObj);
            } else if (userObj instanceof PSCData) {
                ProcessData process = (ProcessData)node.getParent().getContent();
                enablements = this.nodeSelected((PSCData)userObj, process);
            } else if (userObj instanceof ProcessData) {
                enablements = this.nodeSelected((ProcessData)userObj);
            } else if (userObj instanceof HostData) {
                enablements = this.nodeSelected((HostData)userObj);
            }
            this.pnlOps.setEnabled(enablements);
        }
    }

    private boolean[] nodeSelected(HostData hostData) {
        this.pnlOps.setVisibleService(false, 0, false);
        this.tree.setPopupMenuFactory(this.popTree);
        return RuntimeMgmtUtils.getOperationsEnablements(hostData);
    }

    private boolean[] nodeSelected(ProcessData processData) {
        this.pnlOps.setVisibleProcess(true);
        this.pnlOps.setEnabledShowProcess(processData);
        this.pnlOps.setProcessDate(processData);
        if (this.processPopupTree == null) {
            this.processPopupTree = new TreeMenuFactory(this.tree, this.pnlOps.getActions());
        }
        this.tree.setPopupMenuFactory(this.processPopupTree);
        return RuntimeMgmtUtils.getOperationsEnablements(processData);
    }

    private boolean[] nodeSelected(PSCData pscData, ProcessData process) {
        this.pnlOps.setVisibleService(false, 0, false);
        this.tree.setPopupMenuFactory(this.popTree);
        return RuntimeMgmtUtils.getOperationsEnablements(pscData, process);
    }

    private boolean[] nodeSelected(ServiceData serviceData) {
        if (serviceData.getCurrentState() == 1 && !this.serviceHM.containsKey(serviceData)) {
            this.serviceHM = this.qsrh.getServiceMap(this.getRunningList());
        }
        if (serviceData.getInitError() != null) {
            this.pnlOps.setVisibleService(true, 0, true);
            this.tree.setPopupMenuFactory(new TreeMenuFactory(this.tree, this.pnlOps.getActions()));
        } else {
            Integer queueNumber = (Integer)this.serviceHM.get(serviceData);
            int numberOfQueues = 0;
            if (queueNumber != null) {
                numberOfQueues = queueNumber;
            }
            if (numberOfQueues != 0) {
                this.pnlOps.setServiceData(serviceData);
                if (numberOfQueues == 1) {
                    this.pnlOps.setVisibleService(true, numberOfQueues, false);
                    if (this.servicePopQueueTree == null) {
                        this.servicePopQueueTree = new TreeMenuFactory(this.tree, this.pnlOps.getActions());
                    }
                    this.tree.setPopupMenuFactory(this.servicePopQueueTree);
                } else {
                    this.pnlOps.setVisibleService(true, numberOfQueues, false);
                    if (this.servicePopQueuesTree == null) {
                        this.servicePopQueuesTree = new TreeMenuFactory(this.tree, this.pnlOps.getActions());
                    }
                    this.tree.setPopupMenuFactory(this.servicePopQueuesTree);
                }
                if (serviceData.getCurrentState() == 1) {
                    this.pnlOps.setShowQueue(true);
                } else {
                    this.pnlOps.setShowQueue(false);
                }
            } else {
                this.pnlOps.setVisibleService(false, 0, false);
                this.tree.setPopupMenuFactory(this.popTree);
            }
        }
        this.qsrh.setServiceData(serviceData);
        return RuntimeMgmtUtils.getOperationsEnablements(serviceData);
    }

    @Override
    public AutoRefresher getAutoRefresher() {
        return this.arRefresher;
    }

    @Override
    public void setAutoRefreshEnabled(boolean b) {
        this.arRefresher.setAutoRefreshEnabled(b);
    }

    @Override
    public void setAutoRefresher(AutoRefresher ar) {
        this.arRefresher = ar;
    }

    @Override
    public void setRefreshRate(int rate) {
        this.arRefresher.setRefreshRate(rate);
    }

    static {
        SPLIT_INIT = (double)RuntimeMgmtUtils.getInt("split.init_location", 70) / 100.0;
        PROC_STATS_HDRS = new String[5];
        RuntimeMgmtPanel.PROC_STATS_HDRS[0] = RuntimeMgmtPanel.getString("prochost.hdr");
        RuntimeMgmtPanel.PROC_STATS_HDRS[1] = RuntimeMgmtPanel.getString("totalprocs.hdr");
        RuntimeMgmtPanel.PROC_STATS_HDRS[2] = RuntimeMgmtPanel.getString("synchedprocs.hdr");
        RuntimeMgmtPanel.PROC_STATS_HDRS[3] = RuntimeMgmtPanel.getString("notregisteredprocs.hdr");
        RuntimeMgmtPanel.PROC_STATS_HDRS[4] = RuntimeMgmtPanel.getString("notdeployedprocs.hdr");
        SERV_STATS_HDRS = new String[11];
        RuntimeMgmtPanel.SERV_STATS_HDRS[0] = RuntimeMgmtPanel.getString("servhost.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[1] = RuntimeMgmtPanel.getString("totalservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[2] = RuntimeMgmtPanel.getString("runningservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[3] = RuntimeMgmtPanel.getString("synchedservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[4] = RuntimeMgmtPanel.getString("notregisteredservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[5] = RuntimeMgmtPanel.getString("notdeployedservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[6] = RuntimeMgmtPanel.getString("failedservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[7] = RuntimeMgmtPanel.getString("stoppedservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[8] = RuntimeMgmtPanel.getString("initfailedservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[9] = RuntimeMgmtPanel.getString("notinitservs.hdr");
        RuntimeMgmtPanel.SERV_STATS_HDRS[10] = RuntimeMgmtPanel.getString("datasourceunavailableservs.hdr");
    }

    private static class TreeMenuFactory
    extends DefaultPopupMenuFactory {
        JPopupMenu pop = new JPopupMenu();

        public TreeMenuFactory(TreeWidget theTree, List popActions) {
            int size = popActions.size();
            for (int i = 0; i < size; ++i) {
                MenuEntry me = (MenuEntry)popActions.get(i);
                this.pop.add(me.getAction());
            }
        }

        @Override
        protected JPopupMenu createTreePopupMenu(TreeWidget tree) {
            return this.pop;
        }

        @Override
        public JPopupMenu getPopupMenu(Component context) {
            if (context instanceof TreeWidget && ((TreeWidget)context).getSelectionCount() != 0) {
                return this.pop;
            }
            return null;
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int SHUTDOWN = 0;
        public static final int BOUNCE = 1;
        public static final int REFRESH = 2;
        public static final int SYNCH = 3;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("ShortDescription", RuntimeMgmtPanel.getString("actionShutdown.tip"));
                this.putValue("menu.item.name", RuntimeMgmtPanel.getString("actionShutdown.menu"));
            } else if (theType == 1) {
                this.putValue("ShortDescription", RuntimeMgmtPanel.getString("actionBounce.tip"));
                this.putValue("menu.item.name", RuntimeMgmtPanel.getString("actionBounce.menu"));
            } else if (theType == 3) {
                this.putValue("ShortDescription", RuntimeMgmtPanel.getString("actionSynch.tip"));
                this.putValue("menu.item.name", RuntimeMgmtPanel.getString("actionSynch.menu"));
            } else {
                throw new IllegalArgumentException("The action type <" + theType + "> is invalid.");
            }
        }

        @Override
        public void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                RuntimeMgmtPanel.this.shutdown();
            } else if (this.type == 1) {
                RuntimeMgmtPanel.this.bounce();
                RuntimeMgmtPanel.this.refresh();
            } else if (this.type == 3) {
                RuntimeMgmtPanel.this.synch();
            }
        }

        @Override
        protected void handleError(Exception theException) {
            String emsg = null;
            if (this.type == 0) {
                emsg = RuntimeMgmtPanel.getString("msg.shutdownerror");
            } else if (this.type == 1) {
                emsg = RuntimeMgmtPanel.getString("msg.bounceerror");
            } else if (this.type == 3) {
                emsg = RuntimeMgmtPanel.getString("msg.syncherror");
            }
            if (emsg != null) {
                ExceptionUtility.showMessage(emsg, theException.getMessage(), theException);
                LogManager.logError((String)"RUNTIME", (Throwable)theException, (String)this.paramString());
            } else {
                super.handleError(theException);
            }
        }
    }
}

