/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.views.runtime.util.RuntimeMgmtUtils;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeCellRenderer;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;

public final class RuntimeStateCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon HOST_ICON = RuntimeMgmtUtils.getIcon("icon.host");
    private static final Icon PROCESS_ICON = RuntimeMgmtUtils.getIcon("icon.process");
    private static final Icon SERVICE_ICON = RuntimeMgmtUtils.getIcon("icon.service");
    private static final Icon PSC_ICON = RuntimeMgmtUtils.getIcon("icon.psc");
    private static Color saveBackNonSelectColor;
    private static Color saveBackSelectColor;
    private static Color saveForeNonSelectColor;
    private static Color saveForeSelectColor;

    public RuntimeStateCellRenderer() {
        if (saveBackSelectColor == null) {
            saveBackNonSelectColor = this.getBackgroundNonSelectionColor();
            saveBackSelectColor = this.getBackgroundSelectionColor();
            saveForeNonSelectColor = this.getTextNonSelectionColor();
            saveForeSelectColor = this.getTextSelectionColor();
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        if (value == null) {
            return this;
        }
        Object userObj = ((DefaultTreeNode)value).getContent();
        boolean deployed = false;
        boolean registered = false;
        String stateTxt = null;
        Color txtColor = null;
        Icon icon = null;
        if (userObj instanceof ServiceData) {
            icon = SERVICE_ICON;
            ServiceData service = (ServiceData)userObj;
            deployed = service.isDeployed();
            registered = service.isRegistered();
            int state = service.getCurrentState();
            txtColor = RuntimeMgmtUtils.getServiceStateColor(state);
            if (service.getName().equalsIgnoreCase("ODBCService") && state == 6) {
                state = 99;
            }
            stateTxt = RuntimeMgmtUtils.getServiceStateText(state);
        } else if (userObj instanceof PSCData) {
            icon = PSC_ICON;
        } else if (userObj instanceof ProcessData) {
            icon = PROCESS_ICON;
        } else if (userObj instanceof HostData) {
            icon = HOST_ICON;
        }
        Color color = RuntimeMgmtUtils.getStateColor(deployed, registered);
        if (color == null) {
            this.setBackgroundSelectionColor(saveBackSelectColor);
            this.setBackgroundNonSelectionColor(saveBackNonSelectColor);
        } else {
            this.setBackgroundSelectionColor(color);
            this.setBackgroundNonSelectionColor(color);
        }
        if (txtColor == null) {
            this.setTextSelectionColor(saveForeSelectColor);
            this.setTextNonSelectionColor(saveForeNonSelectColor);
        } else {
            this.setTextSelectionColor(txtColor);
            this.setTextNonSelectionColor(txtColor);
        }
        super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        this.setIcon(icon);
        if (userObj instanceof ServiceData) {
            this.setText(this.getText() + RuntimeMgmtUtils.getString("state.msg", new Object[]{stateTxt}));
        }
        return this;
    }
}

