/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.ui.views.runtime.ConfirmationPanel;
import com.metamatrix.console.ui.views.runtime.OperationsDelegate;
import com.metamatrix.console.ui.views.runtime.OperationsPanel;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.VMStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.util.RuntimeMgmtUtils;
import com.metamatrix.console.ui.views.runtime.util.ServiceStateConstants;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.UIDefaults;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableCellRenderer;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public final class ServiceMgmtPanel
extends DialogPanel
implements ListSelectionListener,
OperationsDelegate,
ServiceStateConstants {
    private static String[] HDRS = new String[7];
    private static final int SERV_COL = 0;
    private static final int ID_COL = 1;
    private static final int STATE_COL = 2;
    private static final int DEPLOYED_COL = 3;
    private static final int REGISTERED_COL = 4;
    private static final int ESSENTIAL_COL = 5;
    private static final int TIME_COL = 6;
    private TableWidget tbl;
    private OperationsPanel pnlOps;
    private DefaultTableModel tblModel;
    private RuntimeMgmtManager manager;

    public ServiceMgmtPanel(RuntimeMgmtManager mgr) {
        this.manager = mgr;
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(RuntimeMgmtUtils.EMPTY_BORDER);
        this.tbl = new TableWidget();
        this.tblModel = (DefaultTableModel)this.tbl.getModel();
        this.tblModel.setColumnIdentifiers(HDRS);
        this.tbl.setEditable(false);
        this.tbl.setPreferredScrollableViewportSize(new Dimension(this.tbl.getPreferredSize().width, RuntimeMgmtUtils.getInt("servicerows", 12) * this.tbl.getRowHeight()));
        this.tbl.setAutoResizeMode(4);
        this.tbl.setSortable(true);
        this.tbl.getSelectionModel().setSelectionMode(0);
        this.tbl.getSelectionModel().addListSelectionListener(this);
        ServiceMgmtCellRenderer renderer = new ServiceMgmtCellRenderer();
        TableColumnModel columnModel = this.tbl.getColumnModel();
        columnModel.getColumn(2).setCellRenderer(renderer);
        columnModel.getColumn(6).setCellRenderer(renderer);
        JScrollPane spn = new JScrollPane(this.tbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pnl.add((Component)spn, gbc);
        this.pnlOps = new OperationsPanel(this);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        pnl.add((Component)this.pnlOps, gbc);
        this.setContent(pnl);
        ButtonWidget btnOk = this.getAcceptButton();
        btnOk.setText(RuntimeMgmtUtils.getString("sm.btnOk"));
        this.removeNavigationButton(this.getCancelButton());
    }

    private ServiceData getSelectedService() {
        int row = this.tbl.getSelectedRow();
        return (ServiceData)this.tblModel.getValueAt(row, 0);
    }

    public void load(List theServices) {
        this.tblModel.setNumRows(0);
        if (theServices != null && !theServices.isEmpty()) {
            int size = theServices.size();
            for (int i = 0; i < size; ++i) {
                ServiceData service = (ServiceData)theServices.get(i);
                Vector<Object> row = new Vector<Object>(HDRS.length);
                row.setSize(HDRS.length);
                row.setElementAt(service, 0);
                row.setElementAt(service.getServiceID(), 1);
                int state = service.getCurrentState();
                if (service.getName().equalsIgnoreCase("ODBCService") && state == 6) {
                    state = 99;
                }
                row.setElementAt(new Integer(state), 2);
                row.setElementAt(new Boolean(service.isDeployed()), 3);
                row.setElementAt(new Boolean(service.isRegistered()), 4);
                row.setElementAt(new Boolean(service.isEssential()), 5);
                row.setElementAt(service.getStateChangeTime(), 6);
                this.tblModel.addRow(row);
            }
            this.tbl.setRowSelectionInterval(0, 0);
        }
        this.tbl.sizeColumnsToFitData();
    }

    public void setActionsDisabled() {
        this.pnlOps.setActionsDisabled();
    }

    @Override
    public void startOperation() throws ExternalException {
        ServiceData service = this.getSelectedService();
        this.manager.startService(service);
        this.tblModel.setValueAt(new Integer(1), this.tbl.getSelectedRow(), 2);
        this.pnlOps.setEnabled(RuntimeMgmtUtils.getServiceOperationsEnablements(1));
    }

    @Override
    public void stopOperation() throws ExternalException {
        ServiceData service = this.getSelectedService();
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.stopservice.msg", new Object[]{service});
        DialogWindow.show(this, RuntimeMgmtUtils.getString("dlg.stopservice.title"), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.manager.stopService(service);
            this.tblModel.setValueAt(new Integer(2), this.tbl.getSelectedRow(), 2);
            this.pnlOps.setEnabled(RuntimeMgmtUtils.getServiceOperationsEnablements(2));
        }
    }

    @Override
    public void stopNowOperation() throws ExternalException {
        ServiceData service = this.getSelectedService();
        ConfirmationPanel pnlConfirm = new ConfirmationPanel("dlg.stopnowservice.msg", new Object[]{service});
        DialogWindow.show(this, RuntimeMgmtUtils.getString("dlg.stopnowservice.title"), pnlConfirm);
        if (pnlConfirm.isConfirmed()) {
            this.manager.stopServiceNow(service);
            this.tblModel.setValueAt(new Integer(2), this.tbl.getSelectedRow(), 2);
            this.pnlOps.setEnabled(RuntimeMgmtUtils.getServiceOperationsEnablements(2));
        }
    }

    @Override
    public void showServcieError() throws ExternalException {
        Throwable theError = null;
        String titleId = null;
        ServiceData service = this.getSelectedService();
        if (service != null && (theError = service.getInitError()) != null) {
            titleId = "dlg.showserviceError.title";
            String errorMsg = theError.getMessage();
            if (errorMsg == null || errorMsg.length() == 0) {
                errorMsg = "Error message was null.";
            }
            ExceptionUtility.showMessage(RuntimeMgmtUtils.getString(titleId, new Object[]{service}), errorMsg, theError);
        }
    }

    @Override
    public QueueStatisticsFrame startShowQueue(ServiceData sd) {
        return null;
    }

    @Override
    public boolean isServiceDisplayed(ServiceData sd) {
        return false;
    }

    @Override
    public void refreshService(ServiceData sd) {
    }

    @Override
    public VMStatisticsFrame startShowProcess(ProcessData pd) {
        return null;
    }

    @Override
    public boolean isProcessDisplayed(ProcessData pd) {
        return false;
    }

    @Override
    public void refreshProcess(ProcessData pd) {
    }

    @Override
    public void valueChanged(ListSelectionEvent theEvent) {
        if (!theEvent.getValueIsAdjusting()) {
            if (this.tbl.getSelectedRowCount() > 0) {
                ServiceData service = this.getSelectedService();
                this.pnlOps.setEnabled(RuntimeMgmtUtils.getOperationsEnablements(service));
            } else {
                this.pnlOps.setEnabled(false);
            }
        }
    }

    static {
        ServiceMgmtPanel.HDRS[0] = RuntimeMgmtUtils.getString("sm.service.hdr");
        ServiceMgmtPanel.HDRS[1] = RuntimeMgmtUtils.getString("sm.id.hdr");
        ServiceMgmtPanel.HDRS[2] = RuntimeMgmtUtils.getString("sm.state.hdr");
        ServiceMgmtPanel.HDRS[3] = RuntimeMgmtUtils.getString("sm.deployed.hdr");
        ServiceMgmtPanel.HDRS[4] = RuntimeMgmtUtils.getString("sm.registered.hdr");
        ServiceMgmtPanel.HDRS[5] = RuntimeMgmtUtils.getString("sm.essential.hdr");
        ServiceMgmtPanel.HDRS[6] = RuntimeMgmtUtils.getString("sm.time.hdr");
    }

    public final class ServiceMgmtCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable theTable, Object theValue, boolean theSelectedFlag, boolean theHasFocusFlag, int theRow, int theColumn) {
            Component comp = super.getTableCellRendererComponent(theTable, theValue, theSelectedFlag, theHasFocusFlag, theRow, theColumn);
            if (theColumn == 2) {
                int state = (Integer)theValue;
                ((JLabel)comp).setText(RuntimeMgmtUtils.getServiceStateText(state));
            } else if (theColumn == 6) {
                ((JLabel)comp).setText(RuntimeMgmtUtils.DATE_FORMATTER.format((Date)theValue));
            }
            if (theHasFocusFlag) {
                ((JComponent)comp).setBorder(UIDefaults.getInstance().getBorder("Table.focusCellHighlightBorder"));
            } else {
                ((JComponent)comp).setBorder(UIDefaults.getInstance().getBorder("Table.noFocusBorder"));
            }
            if (theSelectedFlag) {
                comp.setBackground(theTable.getSelectionBackground());
            } else {
                comp.setBackground(theTable.getBackground());
            }
            return comp;
        }
    }
}

