/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

class SingleQueueStatisticsPanel
extends JPanel {
    private String queueName;
    private TextFieldWidget currentSizeTFW;
    private TextFieldWidget highestSizeTFW;
    private TextFieldWidget totalEnqueuedTFW;
    private TextFieldWidget totalDequeuedTFW;
    private TextFieldWidget numThreadsTFW;

    public SingleQueueStatisticsPanel(String queName) {
        this.queueName = queName;
        this.init();
    }

    private void init() {
        this.setBorder(new TitledBorder("Queue: " + this.queueName));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        LabelWidget currentSizeLabel = new LabelWidget("Current size:");
        LabelWidget highestSizeLabel = new LabelWidget("Highest size:");
        LabelWidget totalEnqueuedLabel = new LabelWidget("Total enqueued:");
        LabelWidget totalDequeuedLabel = new LabelWidget("Total dequeued:");
        LabelWidget numThreadsLabel = new LabelWidget("Num. threads:");
        this.currentSizeTFW = new TextFieldWidget(10);
        this.currentSizeTFW.setEditable(false);
        this.highestSizeTFW = new TextFieldWidget();
        this.highestSizeTFW.setEditable(false);
        this.totalEnqueuedTFW = new TextFieldWidget();
        this.totalEnqueuedTFW.setEditable(false);
        this.totalDequeuedTFW = new TextFieldWidget();
        this.totalDequeuedTFW.setEditable(false);
        this.numThreadsTFW = new TextFieldWidget();
        this.numThreadsTFW.setEditable(false);
        this.add(currentSizeLabel);
        this.add(highestSizeLabel);
        this.add(totalEnqueuedLabel);
        this.add(totalDequeuedLabel);
        this.add(numThreadsLabel);
        this.add(this.currentSizeTFW);
        this.add(this.highestSizeTFW);
        this.add(this.totalEnqueuedTFW);
        this.add(this.totalDequeuedTFW);
        this.add(this.numThreadsTFW);
        layout.setConstraints(currentSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(highestSizeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(totalEnqueuedLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(totalDequeuedLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(numThreadsLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(this.currentSizeTFW, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(this.highestSizeTFW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(this.totalEnqueuedTFW, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(this.totalDequeuedTFW, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(this.numThreadsTFW, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void populate(Integer currentSize, Integer highestSize, Integer totalEnqueued, Integer totalDequeued, Integer numThreads) {
        if (currentSize == null) {
            this.currentSizeTFW.setText("");
        } else {
            this.currentSizeTFW.setText(currentSize.toString());
        }
        if (highestSize == null) {
            this.highestSizeTFW.setText("");
        } else {
            this.highestSizeTFW.setText(highestSize.toString());
        }
        if (totalEnqueued == null) {
            this.totalEnqueuedTFW.setText("");
        } else {
            this.totalEnqueuedTFW.setText(totalEnqueued.toString());
        }
        if (totalDequeued == null) {
            this.totalDequeuedTFW.setText("");
        } else {
            this.totalDequeuedTFW.setText(totalDequeued.toString());
        }
        if (numThreads == null) {
            this.numThreadsTFW.setText("");
        } else {
            this.numThreadsTFW.setText(numThreads.toString());
        }
    }

    public String getQueueName() {
        return this.queueName;
    }
}

