/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.views.runtime.OperationsPanel;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsRefreshRequestHandler;
import com.metamatrix.console.ui.views.runtime.VMStatisticsFrame;
import com.metamatrix.console.ui.views.runtime.VMStatisticsPanel;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import java.util.HashMap;
import java.util.Map;

public class VMStatisticsDisplayHandler {
    public QueueStatisticsRefreshRequestHandler caller;
    private OperationsPanel operationsPnl;
    private VMStatisticsFrame statisticsFrame;
    private Map currentlyShowing = new HashMap();

    public VMStatisticsDisplayHandler(QueueStatisticsRefreshRequestHandler vmrrh) {
        this.caller = vmrrh;
    }

    public boolean isProcessDisplayed(ProcessData pd) {
        return this.currentlyShowing.containsKey(pd);
    }

    public Map getDialogs() {
        return this.currentlyShowing;
    }

    public VMStatisticsFrame startDisplayForProcess(String processDisplayName, ProcessData pd, ProcessStatistics vmstatistics) {
        VMStatisticsPanel panel = new VMStatisticsPanel(this.caller, pd, vmstatistics);
        this.statisticsFrame = new VMStatisticsFrame(this, processDisplayName, pd, panel);
        this.currentlyShowing.put(pd, this.statisticsFrame);
        return this.statisticsFrame;
    }

    public void setOperationsPnl(OperationsPanel op) {
        this.operationsPnl = op;
    }

    public void refreshDisplayForProcess(String processDisplayName, ProcessData pd, ProcessStatistics vmstatistics) {
        VMStatisticsFrame statisticsFrame = (VMStatisticsFrame)this.currentlyShowing.get(pd);
        VMStatisticsPanel panel = statisticsFrame.getPanel();
        panel.repopulate(vmstatistics);
    }

    public void frameClosing(ProcessData pd) {
        this.currentlyShowing.remove(pd);
        this.operationsPnl.setEnabledShowProcess(pd);
    }
}

