/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.views.runtime.VMStatisticsDisplayHandler;
import com.metamatrix.console.ui.views.runtime.VMStatisticsPanel;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

class VMStatisticsFrame
extends JFrame {
    private static final float MIN_SCREEN_WIDTH_PROPORTION = 0.3f;
    VMStatisticsDisplayHandler caller;
    VMStatisticsPanel panel;
    ProcessData pd;

    public VMStatisticsFrame(VMStatisticsDisplayHandler cllr, String processDisplayName, ProcessData pd, VMStatisticsPanel pnl) {
        super(processDisplayName + " Process Status");
        this.caller = cllr;
        this.pd = pd;
        this.panel = pnl;
        this.init();
    }

    private void init() {
        this.setIconImage(ViewManager.CONSOLE_ICON_IMAGE);
        GridBagLayout layout = new GridBagLayout();
        layout.setConstraints(this.panel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().setLayout(layout);
        this.getContentPane().add(this.panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                VMStatisticsFrame.this.dispose();
            }
        });
        this.panel.getCloseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                VMStatisticsFrame.this.dispose();
            }
        });
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension firstSize = this.getSize();
        int height = firstSize.height;
        int width = Math.max(firstSize.width, (int)((float)screenSize.width * 0.3f));
        this.setSize(width, height);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    public ProcessData getProcessData() {
        return this.pd;
    }

    public VMStatisticsPanel getPanel() {
        return this.panel;
    }

    @Override
    public void dispose() {
        this.caller.frameClosing(this.pd);
        super.dispose();
    }
}

