/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime;

import com.metamatrix.console.ui.views.runtime.ProcessVMStatisticsPanel;
import com.metamatrix.console.ui.views.runtime.QueueStatisticsRefreshRequestHandler;
import com.metamatrix.console.ui.views.runtime.QueueVMStatisticsPanel;
import com.metamatrix.console.ui.views.runtime.SocketVMStatisticsPanel;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class VMStatisticsPanel
extends JPanel {
    private ProcessData processData;
    private QueueStatisticsRefreshRequestHandler controller;
    private ProcessStatistics vmStatistics;
    private ProcessVMStatisticsPanel processPanel;
    private QueueVMStatisticsPanel queuePanel;
    private SocketVMStatisticsPanel socketPanel;
    private AbstractButton closeButton;

    public VMStatisticsPanel(QueueStatisticsRefreshRequestHandler ctrlr, ProcessData pd, ProcessStatistics vmStats) {
        this.controller = ctrlr;
        this.processData = pd;
        this.vmStatistics = vmStats;
        this.init();
    }

    private void init() {
        this.closeButton = new ButtonWidget("Close");
        ButtonWidget refreshButton = new ButtonWidget("Refresh");
        ButtonWidget runButton = new ButtonWidget("Run Garbage Collection");
        if (this.controller != null) {
            final ProcessData pd = this.processData;
            refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    VMStatisticsPanel.this.controller.refreshProcessRequested(pd);
                }
            });
            runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    VMStatisticsPanel.this.controller.runGarbageCollection(pd);
                    VMStatisticsPanel.this.controller.refreshProcessRequested(pd);
                }
            });
        } else {
            refreshButton.setVisible(false);
        }
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagLayout statsLayout = new GridBagLayout();
        JPanel statsPanel = new JPanel(statsLayout);
        this.processPanel = new ProcessVMStatisticsPanel(this.vmStatistics.name);
        this.processPanel.populate(this.vmStatistics);
        this.queuePanel = new QueueVMStatisticsPanel();
        this.queuePanel.populate(this.vmStatistics);
        this.socketPanel = new SocketVMStatisticsPanel();
        this.socketPanel.populate(this.vmStatistics);
        statsPanel.add(this.processPanel);
        statsPanel.add(this.queuePanel);
        statsPanel.add(this.socketPanel);
        this.add(statsPanel);
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 3, 40, 0));
        buttonsPanel.add(refreshButton);
        buttonsPanel.add(this.closeButton);
        buttonsPanel.add(runButton);
        this.add(buttonsPanel);
        statsLayout.setConstraints(this.processPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        statsLayout.setConstraints(this.queuePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        statsLayout.setConstraints(this.socketPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(statsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void repopulate(ProcessStatistics vmStat) {
        this.vmStatistics = vmStat;
        this.processPanel.populate(this.vmStatistics);
        this.queuePanel.populate(this.vmStatistics);
        this.socketPanel.populate(this.vmStatistics);
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }
}

