/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime.model;

import com.metamatrix.console.ui.views.runtime.model.StatisticsConstants;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import java.util.ArrayList;
import java.util.List;

public class HostStatistics
implements StatisticsConstants {
    private HostData host;
    ArrayList synchedProcs = new ArrayList();
    ArrayList notRegProcs = new ArrayList();
    ArrayList notDeployedProcs = new ArrayList();
    private Object[] processStats = new Object[5];
    ArrayList runningServs = new ArrayList();
    ArrayList synchedServs = new ArrayList();
    ArrayList notRegServs = new ArrayList();
    ArrayList notDeployedServs = new ArrayList();
    ArrayList failedServs = new ArrayList();
    ArrayList stoppedServs = new ArrayList();
    ArrayList initFailedServs = new ArrayList();
    ArrayList notInitServs = new ArrayList();
    ArrayList dataSourceUnavailableServs = new ArrayList();
    private Object[] serviceStats = new Object[11];

    public HostStatistics(HostData theHost) {
        this.host = theHost;
    }

    public void addProcess(ProcessData theProcess) {
        if (theProcess.isDeployed()) {
            if (theProcess.isRegistered()) {
                this.synchedProcs.add(theProcess);
            } else {
                this.notRegProcs.add(theProcess);
            }
        } else if (theProcess.isRegistered()) {
            this.notDeployedProcs.add(theProcess);
        } else {
            this.synchedProcs.add(theProcess);
        }
    }

    public void addService(ServiceData theService) {
        boolean registered = theService.isRegistered();
        if (theService.isDeployed()) {
            if (registered) {
                this.synchedServs.add(theService);
            } else {
                this.notRegServs.add(theService);
            }
        } else if (registered) {
            this.notDeployedServs.add(theService);
        } else {
            this.synchedServs.add(theService);
        }
        if (registered) {
            int state = theService.getCurrentState();
            if (state == 1) {
                this.runningServs.add(theService);
            } else if (state == 2) {
                this.stoppedServs.add(theService);
            } else if (state == 3) {
                this.failedServs.add(theService);
            } else if (state == 4) {
                this.initFailedServs.add(theService);
            } else if (state == 0) {
                this.notInitServs.add(theService);
            } else if (state == 6) {
                this.dataSourceUnavailableServs.add(theService);
            }
        }
    }

    public List getFailedServices() {
        return this.failedServs;
    }

    public List getInitFailedServices() {
        return this.initFailedServs;
    }

    public List getNotDeployedProcesses() {
        return this.notDeployedProcs;
    }

    public List getNotDeployedServices() {
        return this.notDeployedServs;
    }

    public List getNotInitServices() {
        return this.notInitServs;
    }

    public List getNotRegisteredProcesses() {
        return this.notRegProcs;
    }

    public List getNotRegisteredServices() {
        return this.notRegServs;
    }

    public List getDataSourceUnavailableServices() {
        return this.dataSourceUnavailableServs;
    }

    public List getProcesses() {
        List clone = (List)this.synchedProcs.clone();
        clone.addAll(this.notRegProcs);
        clone.addAll(this.notDeployedProcs);
        return clone;
    }

    public Object[] getProcessStats() {
        this.processStats[0] = this.host;
        this.processStats[2] = new Integer(this.synchedProcs.size());
        this.processStats[3] = new Integer(this.notRegProcs.size());
        this.processStats[4] = new Integer(this.notDeployedProcs.size());
        this.processStats[1] = new Integer((Integer)this.processStats[2] + (Integer)this.processStats[3] + (Integer)this.processStats[4]);
        return this.processStats;
    }

    public List getRunningServices() {
        return this.runningServs;
    }

    public List getServices() {
        List clone = (List)this.synchedServs.clone();
        clone.addAll(this.notRegServs);
        clone.addAll(this.notDeployedServs);
        return clone;
    }

    public Object[] getServiceStats() {
        this.serviceStats[0] = this.host;
        this.serviceStats[2] = new Integer(this.runningServs.size());
        this.serviceStats[3] = new Integer(this.synchedServs.size());
        this.serviceStats[4] = new Integer(this.notRegServs.size());
        this.serviceStats[5] = new Integer(this.notDeployedServs.size());
        this.serviceStats[6] = new Integer(this.failedServs.size());
        this.serviceStats[7] = new Integer(this.stoppedServs.size());
        this.serviceStats[8] = new Integer(this.initFailedServs.size());
        this.serviceStats[9] = new Integer(this.notInitServs.size());
        this.serviceStats[10] = new Integer(this.dataSourceUnavailableServs.size());
        this.serviceStats[1] = new Integer((Integer)this.serviceStats[2] + (Integer)this.serviceStats[6] + (Integer)this.serviceStats[7] + (Integer)this.serviceStats[8] + (Integer)this.serviceStats[9] + (Integer)this.serviceStats[10]);
        return this.serviceStats;
    }

    public List getStoppedServices() {
        return this.stoppedServs;
    }

    public List getSynchedProcesses() {
        return this.synchedProcs;
    }

    public List getSynchedServices() {
        return this.synchedServs;
    }
}

