/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime.model;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.tree.SortableChildrenNode;
import com.metamatrix.console.ui.views.runtime.model.HostStatistics;
import com.metamatrix.console.ui.views.runtime.model.StatisticsConstants;
import com.metamatrix.console.ui.views.runtime.util.RuntimeMgmtUtils;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeModel;
import com.metamatrix.toolbox.ui.widget.tree.DefaultTreeNode;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class RuntimeMgmtModel
extends DefaultTreeModel
implements StatisticsConstants {
    private static final long MIN_REFRESH_DELAY = 5000L;
    private DefaultTreeNode root;
    private HashMap objNodeMap = new HashMap();
    private HashMap hostStatisticsMap = new HashMap();
    private ArrayList serviceList = new ArrayList();
    private Date lastChangeDate = null;
    private ConnectionInfo connectionInfo = null;
    private long lastRefresh;
    private Timer timer = new Timer(true);

    public RuntimeMgmtModel(ConnectionInfo connectionInfo) throws ExternalException {
        super(new DefaultTreeNode());
        this.connectionInfo = connectionInfo;
        this.root = (DefaultTreeNode)this.getRoot();
    }

    private void addHost(HostData theHost) {
        DefaultTreeNode hostNode = this.createNode(theHost, this.root);
        HostStatistics stats = new HostStatistics(theHost);
        this.hostStatisticsMap.put(theHost, stats);
        Collection procs = theHost.getProcesses();
        if (procs != null) {
            Iterator procItr = procs.iterator();
            while (procItr.hasNext()) {
                this.addProcess((ProcessData)procItr.next(), hostNode, stats);
            }
        }
    }

    private void addProcess(ProcessData theProcess, DefaultTreeNode theHostNode, HostStatistics theStats) {
        theStats.addProcess(theProcess);
        DefaultTreeNode procNode = this.createNode(theProcess, theHostNode);
        Collection pscs = theProcess.getPSCs();
        if (pscs != null) {
            Iterator pscItr = pscs.iterator();
            while (pscItr.hasNext()) {
                this.addPsc((PSCData)pscItr.next(), procNode, theStats);
            }
        }
    }

    private void addPsc(PSCData thePsc, DefaultTreeNode theProcessNode, HostStatistics theStats) {
        DefaultTreeNode pscNode = this.createNode(thePsc, theProcessNode);
        Collection services = thePsc.getServices();
        if (services != null) {
            Iterator serviceItr = services.iterator();
            while (serviceItr.hasNext()) {
                this.addService((ServiceData)serviceItr.next(), pscNode, theStats);
            }
        }
    }

    private void addService(ServiceData theService, DefaultTreeNode thePscNode, HostStatistics theStats) {
        theStats.addService(theService);
        this.serviceList.add(theService);
        Date changeDate = theService.getStateChangeTime();
        if (this.lastChangeDate == null) {
            this.lastChangeDate = changeDate;
        } else if (changeDate.after(this.lastChangeDate)) {
            this.lastChangeDate = changeDate;
        }
        this.createNode(theService, thePscNode);
    }

    public ArrayList getServiceList() {
        return this.serviceList;
    }

    private DefaultTreeNode createNode(Object theUserObject, DefaultTreeNode theParent) {
        SortableChildrenNode child = new SortableChildrenNode(theUserObject);
        theParent.addChild(child);
        this.objNodeMap.put(theUserObject, child);
        this.fireNodeAddedEvent(this, child);
        return child;
    }

    public Date getLastChangeDate() {
        return this.lastChangeDate;
    }

    public DefaultTreeNode getUserObjectNode(Object theUserObject) {
        return (DefaultTreeNode)this.objNodeMap.get(theUserObject);
    }

    public Map getStatistics() {
        return this.hostStatisticsMap;
    }

    public void refresh() {
        this.timer.schedule((TimerTask)new RefreshRunner(), 0L);
    }

    private void refreshImpl() {
        try {
            RuntimeMgmtManager manager = ModelManager.getRuntimeMgmtManager(this.connectionInfo);
            if (manager == null) {
                return;
            }
            SystemState state = manager.getServerState();
            Collection hosts = state.getHosts();
            if (hosts == null || hosts.isEmpty()) {
                LogManager.logCritical((String)"RUNTIME", (String)"RuntimeMgmtModel.updateSystemState:No hosts found.");
            } else {
                this.objNodeMap.clear();
                this.hostStatisticsMap.clear();
                this.serviceList.clear();
                this.root.removeAllChildren();
                for (HostData host : hosts) {
                    this.addHost(host);
                }
            }
            this.fireModelChangedEvent(this, this.root);
        }
        catch (Exception theException) {
            LogManager.logError((String)"RUNTIME", (Throwable)theException, (String)"RuntimeMgmtModel.refreshImpl");
            ExceptionUtility.showMessage(RuntimeMgmtUtils.getString("refreshproblem.msg"), theException.getMessage(), theException);
        }
    }

    private class RefreshRunner
    extends TimerTask {
        private RefreshRunner() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - RuntimeMgmtModel.this.lastRefresh > 5000L) {
                RuntimeMgmtModel.this.lastRefresh = System.currentTimeMillis();
                PanelsTree tree = PanelsTree.getInstance(RuntimeMgmtModel.this.connectionInfo);
                tree.setCursor(Cursor.getPredefinedCursor(3));
                RuntimeMgmtModel.this.refreshImpl();
                tree.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

