/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.runtime.util;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.ui.views.runtime.util.ServiceStateConstants;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public final class RuntimeMgmtUtils
implements ServiceStateConstants {
    public static final int ODBC_UNAVAILABLE_SERVICE_STATE = 99;
    public static final EmptyBorder EMPTY_BORDER;
    public static final String PROPS = "com/metamatrix/console/ui/views/runtime/data/ui";
    public static final SimpleDateFormat DATE_FORMATTER;
    public static final boolean[][] VALID_SERV_OPS;
    private static PropertyProvider propProvider;

    private RuntimeMgmtUtils() {
    }

    public static TextFieldWidget createTextField(String theType) {
        return GuiComponentFactory.createTextField(theType);
    }

    public static boolean getBoolean(String theKey) {
        return propProvider.getBoolean(theKey);
    }

    public static Color getColor(String theKey) {
        return (Color)propProvider.getObject(theKey);
    }

    public static Icon getIcon(String theKey) {
        return propProvider.getIcon(theKey);
    }

    public static int getInt(String theKey, int theDefault) {
        return propProvider.getInt(theKey, theDefault);
    }

    public static int getMnemonic(String theKey) {
        String key = propProvider.getString(theKey, true);
        return key == null ? 0 : (int)key.charAt(0);
    }

    public static boolean isSameHost(HostData theHost, ConnectionInfo connection) {
        return connection.isConnectedHost(theHost.getName());
    }

    public static boolean isSameHost(ProcessData theProcess, ConnectionInfo connection) {
        return connection.isConnectedHost(theProcess.getHostName(), theProcess.getPort());
    }

    public static boolean[] getOperationsEnablements(HostData theHost) {
        boolean[] enablements = new boolean[7];
        if (theHost.isRegistered()) {
            enablements[1] = true;
            enablements[2] = true;
        } else {
            enablements[0] = true;
        }
        return enablements;
    }

    public static boolean[] getOperationsEnablements(ProcessData theProcess) {
        boolean[] enablements = new boolean[7];
        if (theProcess.isRegistered()) {
            enablements[1] = true;
            enablements[2] = true;
        } else {
            enablements[0] = true;
        }
        return enablements;
    }

    public static boolean[] getOperationsEnablements(PSCData thePsc, ProcessData theProcess) {
        boolean[] enablements = new boolean[7];
        if (thePsc.isRegistered()) {
            enablements[1] = true;
            enablements[2] = true;
        } else if (theProcess.isRegistered()) {
            enablements[0] = true;
        }
        Collection services = thePsc.getServices();
        if (services != null && !services.isEmpty()) {
            for (ServiceData service : services) {
                int state = service.getCurrentState();
                if (state != 1) {
                    enablements[0] = true;
                    continue;
                }
                if (state != 4 && state != 3 && state != 6) continue;
                enablements[3] = true;
            }
        }
        return enablements;
    }

    public static boolean[] getOperationsEnablements(ServiceData theService) {
        return RuntimeMgmtUtils.getServiceOperationsEnablements(theService.getCurrentState());
    }

    public static boolean[] getServiceOperationsEnablements(int theState) {
        boolean[] enablements = VALID_SERV_OPS[theState];
        return enablements;
    }

    public static Color getServiceStateColor(int theState) {
        Color color = null;
        if (theState == 1) {
            color = RuntimeMgmtUtils.getColor("state.open.color");
        } else if (theState == 2) {
            color = RuntimeMgmtUtils.getColor("state.closed.color");
        } else if (theState == 3) {
            color = RuntimeMgmtUtils.getColor("state.failed.color");
        } else if (theState == 4) {
            color = RuntimeMgmtUtils.getColor("state.initfailed.color");
        } else if (theState == 0) {
            color = RuntimeMgmtUtils.getColor("state.notinit.color");
        } else if (theState == 5) {
            color = RuntimeMgmtUtils.getColor("state.notregisteredservice.color");
        } else if (theState == 6) {
            color = RuntimeMgmtUtils.getColor("state.datasourceunavailable.color");
        }
        return color;
    }

    public static String getServiceStateText(int theState) {
        String stateTxt = RuntimeMgmtUtils.getString("state.unknown");
        if (theState == 1) {
            stateTxt = RuntimeMgmtUtils.getString("state.open");
        } else if (theState == 2) {
            stateTxt = RuntimeMgmtUtils.getString("state.closed");
        } else if (theState == 3) {
            stateTxt = RuntimeMgmtUtils.getString("state.failed");
        } else if (theState == 4) {
            stateTxt = RuntimeMgmtUtils.getString("state.initfailed");
        } else if (theState == 0) {
            stateTxt = RuntimeMgmtUtils.getString("state.notinit");
        } else if (theState == 5) {
            stateTxt = RuntimeMgmtUtils.getString("state.notregistered");
        } else if (theState == 6) {
            stateTxt = RuntimeMgmtUtils.getString("state.datasourceunavailable");
        } else if (theState == 99) {
            stateTxt = RuntimeMgmtUtils.getString("state.odbcsourceunavailable");
        }
        return stateTxt;
    }

    public static String getServiceStateToolTip(ServiceData theService) {
        boolean registered = theService.isRegistered();
        boolean deployed = theService.isDeployed();
        String txt = null;
        if (registered && deployed) {
            txt = RuntimeMgmtUtils.getString("state.synched.tip", true);
        } else if (registered && !deployed) {
            txt = RuntimeMgmtUtils.getString("state.notdeployed.tip", true);
        } else if (!registered && deployed) {
            txt = RuntimeMgmtUtils.getString("state.notregistered.tip", true);
        }
        return txt;
    }

    public static Color getStateColor(boolean theDeployedFlag, boolean theRegisteredFlag) {
        Color color = null;
        if (theRegisteredFlag && theDeployedFlag) {
            color = RuntimeMgmtUtils.getColor("state.synched.color");
        } else if (theRegisteredFlag && !theDeployedFlag) {
            color = RuntimeMgmtUtils.getColor("state.notdeployed.color");
        } else if (!theRegisteredFlag && theDeployedFlag) {
            color = RuntimeMgmtUtils.getColor("state.notregistered.color");
        }
        return color;
    }

    public static String getString(String theKey) {
        return propProvider.getString(theKey);
    }

    public static String getString(String theKey, boolean theReturnNullFlag) {
        return propProvider.getString(theKey, theReturnNullFlag);
    }

    public static String getString(String theKey, Object[] theArgs) {
        return propProvider.getString(theKey, theArgs);
    }

    static {
        ArrayList<String> propFiles = new ArrayList<String>();
        propFiles.add(PROPS);
        propFiles.add("com/metamatrix/console/ui/data/common_ui");
        propFiles.add("com/metamatrix/console/ui/data/type_defs");
        propProvider = new PropertyProvider(propFiles);
        int inset = RuntimeMgmtUtils.getInt("emptyinsets", 10);
        EMPTY_BORDER = new EmptyBorder(inset, inset, inset, inset);
        String pattern = RuntimeMgmtUtils.getString("datepattern", true);
        if (pattern == null) {
            pattern = "MMM dd, yyyy hh:mm:ss";
        }
        DATE_FORMATTER = new SimpleDateFormat(pattern);
        VALID_SERV_OPS = new boolean[7][7];
        RuntimeMgmtUtils.VALID_SERV_OPS[1] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[1][0] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[1][1] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[1][2] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[1][3] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[2] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[2][0] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[2][1] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[2][2] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[2][3] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[3] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[3][0] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[3][1] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[3][2] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[3][3] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[4] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[4][0] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[4][1] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[4][2] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[4][3] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[0] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[0][0] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[0][1] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[0][2] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[0][3] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[5] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[5][0] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[5][1] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[5][2] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[5][3] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[6] = new boolean[7];
        RuntimeMgmtUtils.VALID_SERV_OPS[6][0] = false;
        RuntimeMgmtUtils.VALID_SERV_OPS[6][1] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[6][2] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[6][3] = true;
        RuntimeMgmtUtils.VALID_SERV_OPS[6][3] = true;
    }
}

