/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.sessions;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.SessionManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.DefaultConsoleTableSorter;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.sessions.SessionInfoIndexPair;
import com.metamatrix.console.ui.views.sessions.SessionTableCellRenderer;
import com.metamatrix.console.ui.views.sessions.SessionTableModel;
import com.metamatrix.console.ui.views.sessions.SessionTableWidget;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class SessionPanel
extends BasePanel
implements WorkspacePanel,
ListSelectionListener,
AutoRefreshable {
    public static final String SESSION_PANEL_NAME = "Session Panel Name.";
    public static final String SESSION_TABLE_NAME = ConsolePlugin.Util.getString("SessionPanel.SessionTable_2");
    public static final String SESSION_TABLE_HDR_NAME = "SessionTable.header";
    public static final int TERMINATE = 0;
    public static final int REFRESH = 1;
    private static final String TITLE = ConsolePlugin.Util.getString("SessionPanel.Sessions_30");
    private static final Insets BORDER_THICKNESS = new Insets(5, 5, 5, 5);
    private static final String EXPIRED_TEXT = ConsolePlugin.Util.getString("SessionPanel.Expired_9");
    private static final String ACTIVE_TEXT = ConsolePlugin.Util.getString("SessionPanel.Active_10");
    private static final String CLOSED_TEXT = ConsolePlugin.Util.getString("SessionPanel.Closed_11");
    private static final String TERMINATED_TEXT = ConsolePlugin.Util.getString("SessionPanel.Terminated_12");
    private static final String DEFAULT_TEXT = ConsolePlugin.Util.getString("SessionPanel.Unknown_14");
    private static final String NO_PRODUCT = ConsolePlugin.Util.getString("SessionPanel.none_18");
    private static final String CANNOTTERMHDR = ConsolePlugin.Util.getString("SessionPanel.cannotTerminateMsgHdr");
    private static final String CANNOTTERMHDR1 = ConsolePlugin.Util.getString("SessionPanel.cannotTerminate_1");
    private static final String CANNOTTERMHDR2 = ConsolePlugin.Util.getString("SessionPanel.cannotTerminate_2");
    private ConnectionInfo connection;
    private SessionTableWidget sessionTable;
    private SessionTableModel tableModel;
    private ArrayList actions = new ArrayList();
    private AbstractAction refreshAction;
    private AbstractAction terminateAction;
    private MenuEntry terminateMenuAction = null;
    private MenuEntry refreshMenuAction = null;
    private AutoRefresher arRefresher = null;
    private List allSessions;
    private boolean programaticSelectionChange = false;
    private UserCapabilities cap;

    public SessionPanel(ConnectionInfo conn) {
        this.connection = conn;
    }

    private MenuEntry createMenuAction(int action) {
        class PanelAction
        extends AbstractPanelAction {
            public PanelAction(int theType) {
                super(theType);
                if (theType == 0) {
                    this.putValue("Name", ConsolePlugin.Util.getString("SessionPanel.Terminate_31"));
                    this.putValue("ShortDescription", ConsolePlugin.Util.getString("SessionPanel.Terminates_all_selected_sessions_32"));
                } else if (theType == 1) {
                    this.putValue("Name", ConsolePlugin.Util.getString("SessionPanel.Refresh_33"));
                    this.putValue("ShortDescription", ConsolePlugin.Util.getString("SessionPanel.Query_for_current_list_of_sessions_34"));
                }
            }

            @Override
            protected void actionImpl(ActionEvent theEvent) throws ExternalException {
                if (this.type == 0) {
                    SessionPanel.this.terminateSelectedSessions();
                } else if (this.type == 1) {
                    SessionPanel.this.refresh();
                }
            }
        }
        if (action == 0 && this.terminateAction != null) {
            return this.terminateMenuAction;
        }
        if (action == 1 && this.refreshAction != null) {
            return this.refreshMenuAction;
        }
        MenuEntry me = null;
        if (action == 0) {
            this.terminateAction = new PanelAction(action);
            this.terminateAction.setEnabled(false);
            me = new MenuEntry("action", this.terminateAction);
        } else if (action == 1) {
            this.refreshAction = new PanelAction(action);
            this.refreshAction.putValue("SmallIcon", DeployPkgUtils.getIcon("icon.refresh"));
            me = new MenuEntry("view.refresh", this.refreshAction);
        }
        return me;
    }

    public void createComponent() throws Exception {
        this.initializeTable();
        JScrollPane scrollPane = new JScrollPane(this.sessionTable);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.setBorder(new EmptyBorder(BORDER_THICKNESS));
        this.add(scrollPane);
        layout.setConstraints(scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.actions.add(this.createMenuAction(1));
        this.cap = null;
        try {
            this.cap = UserCapabilities.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cap.canModifySessions(this.connection)) {
            this.actions.add(this.createMenuAction(0));
            this.sessionTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent ev) {
                    if (ev.isPopupTrigger() || SwingUtilities.isRightMouseButton(ev)) {
                        int row = SessionPanel.this.sessionTable.rowAtPoint(ev.getPoint());
                        if (SessionPanel.this.sessionTable.getSelectionModel().isSelectedIndex(row)) {
                            SessionPanel.this.handlePopupTrigger(ev, SessionPanel.this.sessionTable);
                        }
                    }
                }
            });
        }
        this.arRefresher = new AutoRefresher(this, 15, false, this.connection);
        this.arRefresher.init();
        this.arRefresher.startTimer();
    }

    private void initializeTable() {
        this.tableModel = new SessionTableModel();
        this.sessionTable = new SessionTableWidget(this.tableModel);
        this.sessionTable.setName(SESSION_TABLE_NAME);
        this.sessionTable.getTableHeader().setName(SESSION_TABLE_HDR_NAME);
        this.sessionTable.setAutoResizeMode(4);
        this.sessionTable.getSelectionModel().addListSelectionListener(this);
        this.sessionTable.setEditable(false);
        this.sessionTable.setSortable(true);
        this.sessionTable.setComparator(DefaultConsoleTableComparator.getInstance());
        this.sessionTable.setSorter(DefaultConsoleTableSorter.getInstance());
        EnhancedTableColumn nameColumn = (EnhancedTableColumn)this.sessionTable.getColumn(SessionTableModel.LOGGED_IN_AT);
        this.sessionTable.setColumnSortedAscending(nameColumn, false);
        this.sessionTable.sizeColumnsToFitData();
        this.sessionTable.getSelectionModel().setSelectionMode(2);
        this.sessionTable.setRowSelectionAllowed(true);
        this.sessionTable.setColumnSelectionAllowed(false);
        this.sessionTable.setAllowsMultipleColumnSorting(false);
        SessionTableCellRenderer renderer = new SessionTableCellRenderer();
        for (int i = 0; i < SessionTableModel.COLUMN_NAMES.length; ++i) {
            TableColumn col = this.sessionTable.getColumnModel().getColumn(i);
            col.setCellRenderer(renderer);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (!this.programaticSelectionChange && !ev.getValueIsAdjusting()) {
            if (this.sessionTable.getSelectedRow() == -1) {
                if (this.terminateAction != null && this.terminateAction.isEnabled()) {
                    this.terminateAction.setEnabled(false);
                }
            } else if (this.terminateAction != null && !this.terminateAction.isEnabled()) {
                this.terminateAction.setEnabled(true);
            }
        }
    }

    private void deselectSessionRow(int theRow, String msgHdr, String theMessage) {
        StaticUtilities.displayModalDialogWithOK(msgHdr, theMessage, 2);
        this.programaticSelectionChange = true;
        this.sessionTable.getSelectionModel().removeSelectionInterval(theRow, theRow);
        this.programaticSelectionChange = false;
        if (this.sessionTable.getSelectedRowCount() == 0 && this.terminateAction != null && this.terminateAction.isEnabled()) {
            this.terminateAction.setEnabled(false);
        }
    }

    private boolean terminationAllowed(int theRow, MetaMatrixSessionID[] consoleSessionIDs) {
        boolean canTerminate = true;
        int modelIndex = this.sessionTable.convertRowIndexToModel(theRow);
        String rowSessionID = (String)this.tableModel.getValueAt(modelIndex, 2);
        boolean isAConsoleSession = false;
        int i = 0;
        while (i < consoleSessionIDs.length && !isAConsoleSession) {
            String curConsoleSessionID = consoleSessionIDs[i].toString();
            if (rowSessionID.equals(curConsoleSessionID)) {
                String msg = CANNOTTERMHDR1 + ' ' + rowSessionID + ' ' + CANNOTTERMHDR2;
                this.deselectSessionRow(theRow, CANNOTTERMHDR, msg);
                isAConsoleSession = true;
                canTerminate = false;
                continue;
            }
            ++i;
        }
        return canTerminate;
    }

    private MetaMatrixSessionID[] getConsoleSessionIDs() {
        ConnectionInfo[] consoleSessions = ConsoleMainFrame.getInstance().getConnections();
        MetaMatrixSessionID[] ids = new MetaMatrixSessionID[consoleSessions.length];
        for (int i = 0; i < consoleSessions.length; ++i) {
            ids[i] = consoleSessions[i].getSessionID();
        }
        return ids;
    }

    private void repopulateModel() {
        try {
            this.tableModel.setDataVector(this.getSessionData());
            this.setSortingColumns(this.sessionTable.getSortedColumns());
        }
        catch (NullPointerException e) {
            LogManager.logError((String)"SESSIONS", (Throwable)e, (String)ConsolePlugin.Util.getString("SessionPanel.repopulateModel()_NullPointerException_15"));
            ExceptionUtility.showMessage(ConsolePlugin.Util.getString("SessionPanel.Error_repopulating_Session_table_16"), e);
        }
        this.sessionTable.sizeColumnsToFitData();
        this.sessionTable.getColumnModel().setColumnMargin(5);
        this.sessionTable.sort();
        this.sessionTable.setEditable(false);
        this.sessionTable.setVisible(true);
    }

    private Object[][] getSessionData() {
        Iterator iterator = this.allSessions.iterator();
        Object[][] data = new Object[this.allSessions.size()][SessionTableModel.COLUMN_COUNT];
        int i = 0;
        while (iterator.hasNext()) {
            String sessionState;
            MetaMatrixSessionInfo u = (MetaMatrixSessionInfo)iterator.next();
            data[i][2] = u.getSessionID().toString();
            data[i][0] = u.getUserName();
            data[i][1] = u.getApplicationName();
            data[i][3] = new Date(u.getTimeCreated());
            data[i][7] = new Date(u.getLastPingTime());
            String vdbName = u.getProductInfo("VirtualDatabaseName");
            data[i][4] = vdbName != null ? vdbName : "";
            String vdbVersStr = u.getProductInfo("VirtualDatabaseVersion");
            vdbVersStr = vdbVersStr != null ? vdbVersStr.trim() : "";
            data[i][5] = vdbVersStr;
            switch (u.getState()) {
                case 4: {
                    sessionState = EXPIRED_TEXT;
                    break;
                }
                case 1: {
                    sessionState = ACTIVE_TEXT;
                    break;
                }
                case 3: {
                    sessionState = CLOSED_TEXT;
                    break;
                }
                case 5: {
                    sessionState = TERMINATED_TEXT;
                    break;
                }
                default: {
                    sessionState = DEFAULT_TEXT;
                }
            }
            data[i][8] = sessionState;
            data[i][6] = u.getProductName();
            ++i;
        }
        return data;
    }

    private void setSortingColumns(List columns) {
        Iterator it = columns.iterator();
        int i = 0;
        while (it.hasNext()) {
            boolean clearPrevious;
            EnhancedTableColumn col = (EnhancedTableColumn)it.next();
            boolean ascending = col.isSortedAscending();
            boolean bl = clearPrevious = i == 0;
            if (ascending) {
                this.sessionTable.setColumnSortedAscending(col, !clearPrevious);
            } else {
                this.sessionTable.setColumnSortedDescending(col, !clearPrevious);
            }
            ++i;
        }
    }

    public List getCurrentSelections() {
        ArrayList<SessionInfoIndexPair> result = new ArrayList<SessionInfoIndexPair>();
        ListSelectionModel lsm = this.sessionTable.getSelectionModel();
        for (int i = lsm.getMinSelectionIndex(); i <= lsm.getMaxSelectionIndex(); ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            int modelIndex = this.sessionTable.convertRowIndexToModel(i);
            MetaMatrixSessionInfo sessInfo = (MetaMatrixSessionInfo)this.allSessions.get(modelIndex);
            result.add(new SessionInfoIndexPair(sessInfo, modelIndex));
        }
        return result;
    }

    private void handlePopupTrigger(MouseEvent ev, Component comp) {
        JPopupMenu popupMenu = new JPopupMenu();
        if (!this.terminateAction.isEnabled()) {
            this.terminateAction.setEnabled(true);
        }
        popupMenu.add(this.terminateAction);
        popupMenu.show(comp, ev.getX() + 10, ev.getY());
    }

    public void terminateSelectedSessions() {
        boolean confirmed;
        SessionTableWidget table = this.sessionTable;
        List selections = this.getCurrentSelections();
        int numSelections = selections.size();
        int numDeletableSessions = 0;
        MetaMatrixSessionID[] consoleSessionIDs = this.getConsoleSessionIDs();
        int[] selectedRows = table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            boolean canTerminateSession = this.terminationAllowed(selectedRows[i], consoleSessionIDs);
            if (!canTerminateSession) continue;
            ++numDeletableSessions;
        }
        if (numDeletableSessions == 0) {
            return;
        }
        if (numSelections > 1) {
            confirmed = DialogUtility.yesNoDialog(null, ConsolePlugin.Util.getString("SessionPanel.Terminate_the__19") + numDeletableSessions + ConsolePlugin.Util.getString("SessionPanel._selected_sessions__20"), ConsolePlugin.Util.getString("SessionPanel.Confirm_Termination_21"));
        } else {
            int tableRow = this.sessionTable.getSelectedRow();
            int modelRow = this.sessionTable.convertRowIndexToModel(tableRow);
            MetaMatrixSessionInfo sessToKill = (MetaMatrixSessionInfo)this.allSessions.get(modelRow);
            String session = sessToKill.toString();
            confirmed = DialogUtility.yesNoDialog(null, ConsolePlugin.Util.getString("SessionPanel.Terminate_Session__23") + session + "?", ConsolePlugin.Util.getString("SessionPanel.Confirm_Termination_25"));
        }
        if (confirmed) {
            Object[] pairArray = this.getCurrentSelections().toArray();
            Arrays.sort(pairArray);
            ArrayList<Object> orderedSelections = new ArrayList<Object>(Arrays.asList(pairArray));
            Iterator<Object> it = orderedSelections.iterator();
            try {
                while (it.hasNext()) {
                    SessionInfoIndexPair pair = (SessionInfoIndexPair)it.next();
                    MetaMatrixSessionInfo sessInfo = pair.sessInfo;
                    int modelIndex = pair.modelIndex;
                    MetaMatrixSessionID id = sessInfo.getSessionID();
                    if (id.equals((Object)this.connection.getSessionID())) continue;
                    this.getSessionManager().terminateSession(sessInfo);
                    if (this.allSessions.get(modelIndex) == sessInfo) {
                        this.allSessions.remove(modelIndex);
                        this.tableModel.removeRow(modelIndex);
                        continue;
                    }
                    throw new RuntimeException(ConsolePlugin.Util.getString("SessionPanel.SessionTab_sessinfo_and_index_aren__t_paired_up_correctly._26"));
                }
                this.sessionTable.getSelectionModel().clearSelection();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage(ConsolePlugin.Util.getString("SessionPanel.Error_terminating_session_27"), e);
            }
        }
    }

    @Override
    public void refresh() {
        this.refreshTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTable() {
        boolean continuing = true;
        Collection sessions = null;
        try {
            sessions = this.getSessionManager().getSessions();
        }
        catch (Exception ex) {
            LogManager.logError((String)"SESSIONS", (Throwable)ex, (String)ConsolePlugin.Util.getString("SessionPanel.Error_retrieving_sessions_information_28"));
            ExceptionUtility.showMessage(ConsolePlugin.Util.getString("SessionPanel.Error_retrieving_session_information_29"), ex);
            continuing = false;
        }
        if (continuing) {
            try {
                StaticUtilities.startWait(this);
                this.allSessions = new ArrayList(sessions);
                this.repopulateModel();
            }
            finally {
                StaticUtilities.endWait(this);
            }
        }
    }

    private SessionManager getSessionManager() {
        return ModelManager.getSessionManager(this.connection);
    }

    @Override
    public List resume() {
        Iterator iter = this.getCurrentSelections().iterator();
        this.refresh();
        if (!iter.hasNext() && this.terminateAction != null) {
            this.terminateAction.setEnabled(false);
        }
        while (iter.hasNext()) {
            SessionInfoIndexPair pair = (SessionInfoIndexPair)iter.next();
            MetaMatrixSessionInfo sessInfo = pair.sessInfo;
            MetaMatrixSessionID id = sessInfo.getSessionID();
            int rowCount = this.sessionTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                String rowId = (String)this.sessionTable.getValueAt(i, 2);
                if (!id.toString().equals(rowId)) continue;
                this.sessionTable.addRowSelectionInterval(i, i);
            }
        }
        return this.actions;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public String getName() {
        return "data.session";
    }

    @Override
    public void setAutoRefreshEnabled(boolean b) {
        this.arRefresher.setAutoRefreshEnabled(b);
    }

    @Override
    public void setRefreshRate(int iRate) {
        this.arRefresher.setRefreshRate(iRate);
    }

    @Override
    public void setAutoRefresher(AutoRefresher ar) {
        this.arRefresher = ar;
    }

    @Override
    public AutoRefresher getAutoRefresher() {
        return this.arRefresher;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }
}

