/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.sessions;

import com.metamatrix.console.ui.util.TableCellRendererFactory;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SessionTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color ACCENTUATED_SESSION_UNSELECTED_BACKGROUND = StaticUtilities.averageRGBVals(new Color[]{Color.white, Color.white, Color.lightGray});
    private static final Color ACCENTUATED_SESSION_SELECTED_BACKGROUND = StaticUtilities.averageRGBVals(new Color[]{Color.lightGray, Color.lightGray, Color.white});
    private static final TableCellRenderer STRING_RENDERER;
    private static final TableCellRenderer LONG_RENDERER;
    private static final TableCellRenderer INTEGER_RENDERER;
    private static final TableCellRenderer DATE_RENDERER;

    @Override
    public Component getTableCellRendererComponent(JTable jtable, Object value, boolean isSelected, boolean hasFocus, int displayRow, int column) {
        TableWidget table = (TableWidget)jtable;
        int row = table.convertRowIndexToModel(displayRow);
        Component comp = value instanceof String ? STRING_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : (value instanceof Long ? LONG_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : (value instanceof Integer ? INTEGER_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : (value instanceof Date ? DATE_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column))));
        if (this.rowIsForAccentuatedSession(table.getModel(), row)) {
            if (isSelected) {
                comp.setBackground(ACCENTUATED_SESSION_SELECTED_BACKGROUND);
            } else {
                comp.setBackground(ACCENTUATED_SESSION_UNSELECTED_BACKGROUND);
            }
        }
        return comp;
    }

    private boolean rowIsForAccentuatedSession(TableModel model, int row) {
        boolean fromAccentuated = false;
        return fromAccentuated;
    }

    static {
        TableWidget tempTable = new TableWidget();
        STRING_RENDERER = tempTable.getDefaultRenderer(String.class);
        LONG_RENDERER = tempTable.getDefaultRenderer(Long.class);
        INTEGER_RENDERER = tempTable.getDefaultRenderer(Integer.class);
        SimpleDateFormat formatter = StaticUtilities.getDefaultDateFormat();
        DATE_RENDERER = TableCellRendererFactory.createDateRenderer(formatter);
    }
}

