/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.summary;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelChangedEvent;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.IconComponent;
import com.metamatrix.console.ui.views.summary.SummaryConnectionInfo;
import com.metamatrix.console.ui.views.summary.SummaryHostInfo;
import com.metamatrix.console.ui.views.summary.SummaryInfoProvider;
import com.metamatrix.console.ui.views.summary.SummaryTableWidget;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.DaysHoursMinutesSeconds;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SummaryPanel
extends JPanel
implements ActionListener,
WorkspacePanel,
AutoRefreshable {
    private ConnectionInfo connection;
    private ArrayList aryActions = new ArrayList();
    private SummaryInfoProvider summaryInfoProvider;
    private String sysURL;
    private String sysName;
    private int activeSessionCount;
    private int systemState;
    private Date startTime;
    private SummaryHostInfo[] hostInfo;
    private SummaryConnectionInfo[] connectionInfo;
    private JPanel hostPanel;
    private JPanel sessionsPanel;
    private JPanel connectionsPanel;
    private JPanel systemStatePanel;
    private TextFieldWidget runningTFW;
    private TextFieldWidget startTimeTFW;
    private LabelWidget runJL;
    private LabelWidget startedJL;
    private TextFieldWidget activeSessionCountTFW;
    private TableWidget connectionsTable;
    private JPanel stopLightPanel;
    private String[] connectionsTableColumns = new String[]{"Product", "Connections"};
    private TableWidget hostTable;
    private String[] hostTableColumns = new String[]{"Host Identifier", "Status"};
    private GridBagLayout sysStateLayout;
    private AutoRefresher arRefresher;
    public static final IconComponent RED_LIGHT = new IconComponent(IconFactory.getIconForImageFile("red.gif"));
    public static final IconComponent YELLOW_LIGHT = new IconComponent(IconFactory.getIconForImageFile("yellow.gif"));
    public static final IconComponent GREEN_LIGHT = new IconComponent(IconFactory.getIconForImageFile("green.gif"));
    private boolean columnsSized = false;
    private boolean paintedSinceResumeCalled = false;

    public SummaryPanel(ConnectionInfo conn) {
        this.connection = conn;
        this.summaryInfoProvider = ModelManager.getSummaryManager(this.connection);
        this.getURL();
        this.sysName = this.getSystemName();
        this.createComponent();
    }

    public void addActionToList(String sId, Action act) {
        this.aryActions.add(new MenuEntry(sId, act));
    }

    private String getURL() {
        this.sysURL = this.getConnection().getURL();
        return this.sysURL;
    }

    public void createComponent() {
        GridBagLayout pnlOuterLayout = new GridBagLayout();
        this.setLayout(pnlOuterLayout);
        LabelWidget systemJL = new LabelWidget("System Name:");
        TextFieldWidget systemName = new TextFieldWidget(120);
        systemName.setEditable(false);
        if (this.sysName == null) {
            systemName.setText("");
        } else {
            systemName.setText(this.sysName);
        }
        JPanel sysPanel = new JPanel();
        GridBagLayout uls = new GridBagLayout();
        sysPanel.setLayout(uls);
        sysPanel.add(systemJL);
        sysPanel.add(systemName);
        uls.setConstraints(systemJL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        uls.setConstraints(systemName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        LabelWidget urlJL = new LabelWidget("System URL:");
        TextFieldWidget urlName = new TextFieldWidget(120);
        urlName.setEditable(false);
        if (this.sysURL == null) {
            urlName.setText("");
        } else {
            urlName.setText(this.sysURL);
        }
        JPanel urlPanel = new JPanel();
        GridBagLayout ul = new GridBagLayout();
        urlPanel.setLayout(ul);
        urlPanel.add(urlJL);
        urlPanel.add(urlName);
        ul.setConstraints(urlJL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        ul.setConstraints(urlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        LabelWidget userJL = new LabelWidget("User:");
        TextFieldWidget userName = new TextFieldWidget(120);
        userName.setEditable(false);
        String userText = "";
        try {
            MetaMatrixPrincipalName princ = UserCapabilities.getLoggedInUser(this.connection);
            userText = princ.getName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        userName.setText(userText);
        JPanel userPanel = new JPanel();
        GridBagLayout userLayout = new GridBagLayout();
        userPanel.setLayout(userLayout);
        userPanel.add(userJL);
        userPanel.add(userName);
        userLayout.setConstraints(userJL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        userLayout.setConstraints(userName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        JPanel connectionPanel = new JPanel(new GridLayout(2, 2, 16, 5));
        connectionPanel.add(sysPanel);
        connectionPanel.add(userPanel);
        connectionPanel.add(urlPanel);
        this.systemStatePanel = this.buildSysStatePanel();
        TitledBorder tBorder = new TitledBorder("System State");
        tBorder.setTitleJustification(1);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        this.systemStatePanel.setBorder(tBorder);
        this.hostPanel = this.buildHostPanel();
        tBorder = new TitledBorder("Hosts");
        tBorder.setTitleJustification(1);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        this.hostPanel.setBorder(tBorder);
        this.sessionsPanel = this.buildSessionPanel();
        tBorder = new TitledBorder("Sessions");
        tBorder.setTitleJustification(1);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        this.sessionsPanel.setBorder(tBorder);
        this.connectionsPanel = this.buildConnectionsPanel();
        tBorder = new TitledBorder("Connections");
        tBorder.setTitleJustification(1);
        tBorder.setTitleFont(tBorder.getTitleFont().deriveFont(1));
        this.connectionsPanel.setBorder(tBorder);
        ButtonWidget refreshButton = new ButtonWidget("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SummaryPanel.this.refresh();
            }
        });
        pnlOuterLayout.setConstraints(connectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JPanel upperBoxPanel = new JPanel();
        upperBoxPanel.setLayout(new GridLayout(1, 2, 10, 0));
        upperBoxPanel.add(this.systemStatePanel);
        upperBoxPanel.add(this.sessionsPanel);
        JPanel lowerBoxPanel = new JPanel();
        lowerBoxPanel.setLayout(new GridLayout(1, 2, 10, 0));
        lowerBoxPanel.add(this.hostPanel);
        lowerBoxPanel.add(this.connectionsPanel);
        pnlOuterLayout.setConstraints(upperBoxPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        pnlOuterLayout.setConstraints(lowerBoxPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        pnlOuterLayout.setConstraints(refreshButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add(connectionPanel);
        this.add(upperBoxPanel);
        this.add(lowerBoxPanel);
        this.add(refreshButton);
        this.arRefresher = new AutoRefresher(this, 15, false, this.connection);
        this.arRefresher.init();
        this.arRefresher.startTimer();
    }

    private void getHostsInfo() {
        try {
            this.hostInfo = this.summaryInfoProvider.getHostInfo();
        }
        catch (Exception e) {
            LogManager.logError((String)"SUMMARY", (Throwable)e, (String)"Error retrieving summary panel host information.");
            this.hostInfo = null;
        }
    }

    public JPanel buildHostPanel() {
        Object[][] data = this.getHostTableData();
        DefaultTableModel tableModel = new DefaultTableModel(data, this.hostTableColumns);
        this.hostTable = new SummaryTableWidget(tableModel, true);
        this.hostTable.setEditable(false);
        this.hostTable.setName("System Summary host table");
        JScrollPane scrollPane = new JScrollPane(this.hostTable){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SummaryPanel.this.hostTable.sizeColumnsToFitData();
                    }
                });
            }
        };
        JPanel hostPanel = new JPanel(new BorderLayout());
        hostPanel.add((Component)scrollPane, "Center");
        return hostPanel;
    }

    private Object[][] getHostTableData() {
        Object[][] data;
        if (this.hostInfo == null || this.hostInfo.length == 0) {
            data = new Object[1][3];
            data[0][0] = "";
            data[0][1] = "";
        } else {
            data = new Object[this.hostInfo.length][3];
            for (int i = 0; i < this.hostInfo.length; ++i) {
                data[i][0] = this.hostInfo[i].getHostName();
                if (this.hostInfo[i].getHostStatus() == 1) {
                    data[i][1] = "Running";
                    continue;
                }
                if (this.hostInfo[i].getHostStatus() != 2) continue;
                data[i][1] = "Not Running";
            }
        }
        return data;
    }

    private String getSystemName() {
        try {
            return this.summaryInfoProvider.getSystemName();
        }
        catch (Exception e) {
            LogManager.logError((String)"SUMMARY", (Throwable)e, (String)"Error retrieving system name.");
            return "";
        }
    }

    private void getSystemStateInfo() {
        try {
            this.systemState = this.summaryInfoProvider.getSystemState();
        }
        catch (Exception e) {
            LogManager.logError((String)"SUMMARY", (Throwable)e, (String)"Error retrieving current system state.");
        }
        try {
            this.startTime = this.summaryInfoProvider.getSystemStartUpTime();
        }
        catch (Exception e) {
            LogManager.logError((String)"SUMMARY", (Throwable)e, (String)"Error retrieving system start-up time.");
        }
    }

    private JPanel buildSysStatePanel() {
        this.getSystemStateInfo();
        this.sysStateLayout = new GridBagLayout();
        JPanel sysPanel = new JPanel();
        sysPanel.setLayout(this.sysStateLayout);
        LabelWidget currentJL = new LabelWidget("Current Status:");
        this.stopLightPanel = new JPanel();
        currentJL.setName("SummaryPanel.System State1");
        this.startedJL = new LabelWidget("Started:");
        this.startedJL.setName("SummaryPanel.System State2");
        this.startTimeTFW = new TextFieldWidget(105);
        this.startTimeTFW.setEditable(false);
        this.runJL = new LabelWidget("Running:");
        this.runningTFW = new TextFieldWidget(105);
        this.runningTFW.setEditable(false);
        this.runningTFW.setName("SummaryPanel.System State3");
        if (this.startTime == null) {
            this.startTimeTFW.setText("");
            this.startTimeTFW.setVisible(false);
            this.runningTFW.setVisible(false);
            this.runJL.setVisible(false);
            this.startedJL.setVisible(false);
        } else {
            this.startTimeTFW.setText(this.startTime.toString());
            this.runningTFW.setText(this.createRunningDate(this.startTime));
        }
        sysPanel.add(currentJL);
        sysPanel.add(this.stopLightPanel);
        sysPanel.add(this.startedJL);
        sysPanel.add(this.startTimeTFW);
        sysPanel.add(this.runJL);
        sysPanel.add(this.runningTFW);
        this.sysStateLayout.setConstraints(currentJL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.setStopLightPanelConstraints();
        this.sysStateLayout.setConstraints(this.startedJL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.sysStateLayout.setConstraints(this.startTimeTFW, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.sysStateLayout.setConstraints(this.runJL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.sysStateLayout.setConstraints(this.runningTFW, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        return sysPanel;
    }

    private void setStopLightPanelConstraints() {
        this.sysStateLayout.setConstraints(this.stopLightPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    private void getSessionInfo() {
        try {
            this.activeSessionCount = this.summaryInfoProvider.getActiveSessionCount();
        }
        catch (Exception e) {
            LogManager.logError((String)"SUMMARY", (Throwable)e, (String)"Error retrieving active session count.");
        }
    }

    private String createRunningDate(Date startupDate) {
        String displayString = null;
        if (startupDate != null) {
            Date currentDate = new Date();
            long startupLong = startupDate.getTime();
            long currentLong = currentDate.getTime();
            long timeDiffInMilliseconds = currentLong - startupLong;
            int timeDiffInSeconds = 0;
            if (timeDiffInMilliseconds > 0L) {
                timeDiffInSeconds = (int)(timeDiffInMilliseconds / 1000L);
            }
            DaysHoursMinutesSeconds dhms = new DaysHoursMinutesSeconds(timeDiffInSeconds);
            displayString = dhms.toDisplayString(false);
        }
        return displayString;
    }

    private JPanel buildSessionPanel() {
        GridBagLayout sessionLayout = new GridBagLayout();
        JPanel sessionPanel = new JPanel(sessionLayout);
        LabelWidget activeSessionCountJL = new LabelWidget("Active:");
        activeSessionCountJL.setName("SummaryPanel.sessionState");
        this.activeSessionCountTFW = new TextFieldWidget(105);
        this.activeSessionCountTFW.setEditable(false);
        this.activeSessionCountTFW.setText("" + this.activeSessionCount);
        LabelWidget lastSessionJL = new LabelWidget("Last Logged In:");
        lastSessionJL.setName("SummaryPanel.sessionState1");
        sessionLayout.setConstraints(activeSessionCountJL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        sessionLayout.setConstraints(this.activeSessionCountTFW, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        sessionLayout.setConstraints(lastSessionJL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        sessionPanel.add(activeSessionCountJL);
        sessionPanel.add(this.activeSessionCountTFW);
        sessionPanel.add(lastSessionJL);
        return sessionPanel;
    }

    private void getConnectionInfo() {
        try {
            this.connectionInfo = this.summaryInfoProvider.getConnectionInfo();
        }
        catch (Exception e) {
            LogManager.logError((String)"SUMMARY", (Throwable)e, (String)"Error retrieving current connection information.");
            this.connectionInfo = null;
        }
    }

    private JPanel buildConnectionsPanel() {
        Object[][] data = this.getConnectionsTableData();
        DefaultTableModel tableModel = new DefaultTableModel(data, this.connectionsTableColumns);
        this.connectionsTable = new SummaryTableWidget(tableModel);
        this.connectionsTable.setEditable(false);
        this.connectionsTable.setName("System Summary connection table");
        JScrollPane scrollPane = new JScrollPane(this.connectionsTable){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SummaryPanel.this.connectionsTable.sizeColumnsToFitData();
                    }
                });
            }
        };
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.add((Component)scrollPane, "Center");
        return cPanel;
    }

    private Object[][] getConnectionsTableData() {
        Object[][] data;
        if (this.connectionInfo == null || this.connectionInfo.length == 0) {
            data = new Object[1][2];
            data[0][0] = "";
            data[0][1] = "";
        } else {
            data = new Object[this.connectionInfo.length + 1][2];
            int totalCurrent = 0;
            for (int i = 0; i < this.connectionInfo.length; ++i) {
                data[i][0] = this.connectionInfo[i].getProductName();
                data[i][1] = new Integer(this.connectionInfo[i].getCurrentCount());
                totalCurrent += this.connectionInfo[i].getCurrentCount();
            }
            data[this.connectionInfo.length][0] = "Total";
            data[this.connectionInfo.length][1] = new Integer(totalCurrent);
        }
        return data;
    }

    public void refreshData() {
        PanelsTree tree = PanelsTree.getInstance(this.getConnection());
        tree.setCursor(Cursor.getPredefinedCursor(3));
        this.refreshImpl();
        if (!StaticUtilities.isShowingWaitCursor()) {
            tree.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void refreshImpl() {
        this.getSessionInfo();
        this.getSystemStateInfo();
        this.getHostsInfo();
        this.getConnectionInfo();
        IconComponent stopLightIcon = this.systemState == 1 ? GREEN_LIGHT : (this.systemState == 2 ? YELLOW_LIGHT : RED_LIGHT);
        if (this.stopLightPanel != stopLightIcon || !this.paintedSinceResumeCalled) {
            this.systemStatePanel.remove(this.stopLightPanel);
            this.stopLightPanel = stopLightIcon;
            this.systemStatePanel.add(this.stopLightPanel);
            this.setStopLightPanelConstraints();
            ConsoleMainFrame.getInstance().repaintNeeded();
        }
        this.activeSessionCountTFW.setText(new Integer(this.activeSessionCount).toString());
        Object[][] hostData = this.getHostTableData();
        ((DefaultTableModel)this.hostTable.getModel()).setNumRows(0);
        ((DefaultTableModel)this.hostTable.getModel()).setDataVector(hostData, this.hostTableColumns);
        this.hostTable.setEditable(false);
        Object[][] connectionData = this.getConnectionsTableData();
        ((DefaultTableModel)this.connectionsTable.getModel()).setNumRows(0);
        ((DefaultTableModel)this.connectionsTable.getModel()).setDataVector(connectionData, this.connectionsTableColumns);
        this.connectionsTable.setEditable(false);
        this.updateRunning();
        if (!this.columnsSized) {
            this.updateTableColumnWidths();
            this.columnsSized = true;
        }
    }

    public void updateTableColumnWidths() {
        this.connectionsTable.sizeColumnsToFitData();
        this.hostTable.sizeColumnsToFitData();
    }

    private void updateRunning() {
        if (this.startTime != null) {
            this.startTimeTFW.setText(this.startTime.toString());
            this.runningTFW.setText(this.createRunningDate(this.startTime));
            this.startedJL.setVisible(true);
            this.runJL.setVisible(true);
            this.startTimeTFW.setVisible(true);
            this.runningTFW.setVisible(true);
        } else {
            this.startTimeTFW.setText("");
            this.runningTFW.setText("");
            this.startedJL.setVisible(false);
            this.runJL.setVisible(false);
            this.startTimeTFW.setVisible(false);
            this.runningTFW.setVisible(false);
        }
    }

    @Override
    public List resume() {
        this.paintedSinceResumeCalled = false;
        this.refreshData();
        ArrayList result = new ArrayList();
        return result;
    }

    @Override
    public String getTitle() {
        return "Summary";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    public void modelChanged(ModelChangedEvent e) {
        this.refreshImpl();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    @Override
    public String getName() {
        return "data.summary";
    }

    @Override
    public void refresh() {
        this.refreshData();
    }

    @Override
    public void setAutoRefreshEnabled(boolean b) {
        this.arRefresher.setAutoRefreshEnabled(b);
    }

    @Override
    public void setRefreshRate(int iRate) {
        this.arRefresher.setRefreshRate(iRate);
    }

    @Override
    public void setAutoRefresher(AutoRefresher ar) {
        this.arRefresher = ar;
    }

    @Override
    public AutoRefresher getAutoRefresher() {
        return this.arRefresher;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintedSinceResumeCalled = true;
    }
}

