/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EditValueDialog
extends JDialog {
    private ButtonWidget okButton;
    private ButtonWidget cancelButton;
    private boolean cancelled = false;
    private TextFieldWidget valueField;

    public EditValueDialog(int initialVal) {
        super((Frame)ConsoleMainFrame.getInstance(), "Edit Max Rows Value");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                EditValueDialog.this.cancelled = true;
            }
        });
        this.initialize(initialVal);
    }

    private void initialize(int initialVal) {
        this.okButton = new ButtonWidget("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditValueDialog.this.dispose();
            }
        });
        this.cancelButton = new ButtonWidget("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditValueDialog.this.cancelled = true;
                EditValueDialog.this.dispose();
            }
        });
        this.valueField = new TextFieldWidget(5);
        this.valueField.setText(Integer.toString(initialVal));
        this.valueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                EditValueDialog.this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                EditValueDialog.this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                EditValueDialog.this.textChanged();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        LabelWidget label = new LabelWidget("Maximum rows allowed per query:");
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        this.getContentPane().add(label);
        this.getContentPane().add(this.valueField);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 4, 0, 0), 0, 0));
        layout.setConstraints(this.valueField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 4), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 4, 4, 4), 0, 0));
        this.pack();
        int height = this.getSize().height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int newHeight = Math.max(height, (int)((double)screenHeight * 0.2));
        this.setSize(new Dimension(this.getSize().width, newHeight));
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    public Integer getNewValue() {
        Integer newVal = null;
        if (!this.cancelled) {
            newVal = new Integer(this.valueField.getText().trim());
        }
        return newVal;
    }

    private void textChanged() {
        Integer newVal = null;
        try {
            newVal = new Integer(this.valueField.getText().trim());
            int val = newVal;
            if (val <= 0) {
                newVal = null;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean valid = newVal != null;
        this.okButton.setEnabled(valid);
    }
}

