/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.views.syslog.EditValueDialog;
import com.metamatrix.console.ui.views.syslog.MaxRecordsPerQueryListener;
import com.metamatrix.console.ui.views.syslog.ValueWarningDialog;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class MaxRecordsPerQueryPanel
extends JPanel {
    public static final int MAX_TEXT_FIELD_SIZE = 5;
    public static final String MAX_ROWS_LABEL = "Maximum rows allowed per query:";
    private MaxRecordsPerQueryListener listener;
    private int warningThresholdValue;
    private ButtonWidget editButton;
    private TextFieldWidget maxTextField;

    public MaxRecordsPerQueryPanel(MaxRecordsPerQueryListener listener, int warningThresholdValue, int initialValue) {
        this.listener = listener;
        this.warningThresholdValue = warningThresholdValue;
        this.initialize(initialValue);
    }

    private void initialize(int initialVal) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.maxTextField = new TextFieldWidget(5);
        this.setValue(initialVal, false);
        this.maxTextField.setEditable(false);
        this.editButton = new ButtonWidget("Edit...");
        this.editButton.setToolTipText("Edit the maximum number of rows.");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MaxRecordsPerQueryPanel.this.editPressed();
            }
        });
        LabelWidget maxRowsLabel = new LabelWidget(MAX_ROWS_LABEL);
        JPanel innerPanel = new JPanel();
        GridBagLayout innerLayout = new GridBagLayout();
        innerPanel.setLayout(innerLayout);
        innerPanel.add(maxRowsLabel);
        innerPanel.add(this.maxTextField);
        innerPanel.add(this.editButton);
        innerLayout.setConstraints(maxRowsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        innerLayout.setConstraints(this.maxTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 4), 0, 0));
        innerLayout.setConstraints(this.editButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(innerPanel);
        layout.setConstraints(innerPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void setValue(int value, boolean informListener) {
        int currentVal = -1;
        boolean numberSet = false;
        if (this.maxTextField.getText().length() > 0) {
            currentVal = new Integer(this.maxTextField.getText());
            numberSet = true;
        }
        if (!numberSet || value != currentVal) {
            this.maxTextField.setText(Integer.toString(value));
            if (informListener) {
                this.listener.maximumChanged(value);
            }
        }
    }

    public void setValue(int value) {
        this.setValue(value, true);
    }

    public int getMaxRows() {
        int max = new Integer(this.maxTextField.getText());
        return max;
    }

    private void editPressed() {
        int currentVal = new Integer(this.maxTextField.getText());
        EditValueDialog dialog = new EditValueDialog(currentVal);
        dialog.show();
        Integer newValInteger = dialog.getNewValue();
        if (newValInteger != null) {
            boolean continuing = true;
            int newVal = newValInteger;
            if (newVal != currentVal) {
                if (this.warningThresholdValue > 0 && newVal >= this.warningThresholdValue) {
                    ValueWarningDialog warningDlg = new ValueWarningDialog(newVal);
                    warningDlg.show();
                    continuing = warningDlg.wasOKPressed();
                    if (warningDlg.suppressWarningChecked()) {
                        this.listener.doNotDisplayWarningMessage();
                        this.warningThresholdValue = -1;
                    }
                }
                if (continuing) {
                    this.maxTextField.setText(newValInteger.toString());
                    this.listener.maximumChanged(newVal);
                }
            }
        }
    }
}

