/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.views.syslog.SysLogUtils;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.DialogPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.event.WidgetActionEvent;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RowsNotSelectedPanel
extends DialogPanel {
    private static int displayedPanelCount = 0;

    public static void incrementDisplayedPanelCount() {
        ++displayedPanelCount;
    }

    public static void decrementDisplayedPanelCount() {
        --displayedPanelCount;
    }

    public static boolean isCurrentlyDisplayed() {
        return displayedPanelCount > 0;
    }

    public RowsNotSelectedPanel(int theCount, int maxRecords) {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        LabelWidget lbl = new LabelWidget();
        if (theCount == 0) {
            ((JLabel)lbl).setText(SysLogUtils.getString("msg.norowsselected"));
        } else {
            ((JLabel)lbl).setText(SysLogUtils.getString("msg.toomanyrowsselected", new Object[]{"" + theCount, "" + maxRecords}));
        }
        lbl.setIcon(SysLogUtils.getIcon("icon.info"));
        pnl.add(lbl);
        this.setContent(pnl);
        ButtonWidget btnOk = this.getAcceptButton();
        btnOk.setText(SysLogUtils.getString("btnOk"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RowsNotSelectedPanel.this.okPressed();
            }
        });
        this.removeNavigationButton(this.getCancelButton());
    }

    @Override
    protected void cancel(WidgetActionEvent event) {
        this.exitingPanel();
    }

    private void okPressed() {
        this.exitingPanel();
    }

    private void exitingPanel() {
        RowsNotSelectedPanel.decrementDisplayedPanelCount();
    }
}

