/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.reader.LogEntry;
import com.metamatrix.common.log.reader.LogEntryPropertyNames;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.directory.DirectoryEntry;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.DirectoryEntryView;
import com.metamatrix.common.tree.directory.FileSystemFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.ServerLogManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.ColumnSortInfo;
import com.metamatrix.console.ui.util.TableCellRendererFactory;
import com.metamatrix.console.ui.util.property.GuiComponentFactory;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.console.ui.views.syslog.MaxRecordsPerQueryListener;
import com.metamatrix.console.ui.views.syslog.MaxRecordsPerQueryPanel;
import com.metamatrix.console.ui.views.syslog.RowsNotSelectedPanel;
import com.metamatrix.console.ui.views.syslog.SysLogUtils;
import com.metamatrix.console.ui.views.syslog.TimeSpanPanel;
import com.metamatrix.console.ui.views.syslog.TimeSpanPanelValidityListener;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.core.log.MessageLevel;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ZipFileUtil;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.AccumulatorPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.DirectoryChooserPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableCellRenderer;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class SysLogPanel
extends JPanel
implements TimeSpanPanelValidityListener,
ActionListener,
ListDataListener,
ListSelectionListener,
TypeConstants,
WorkspacePanel,
MaxRecordsPerQueryListener,
AutoRefreshable {
    public static final String LAST_SAVE_DIR_PREF_NAME = "metamatrix.console.lastsyslogsavedirectory";
    public static final String MAX_LOG_ROWS_RETURNED = "metamatrix.log.maxRows";
    public static final int WARNING_THRESHOLD_VALUE = 20000;
    public static boolean SUPPRESS_HIGH_LIMIT_WARNING = false;
    public static int MAX_ROWS_VALUE = -1;
    public static boolean MAX_ROWS_HAS_BEEN_RESET = false;
    private static final String DBNAME_SUFFIX = ".dbname";
    private static final String HEADER_SUFFIX = ".hdr";
    private static final String MSG_LEVEL_PREFIX = "msglevel.";
    private static final String POSITION_SUFFIX = ".pos";
    private static final String DB_TIMESTAMP_NAME = SysLogPanel.getString("timestamp.dbname");
    private static final String DB_LEVEL_NAME = SysLogPanel.getString("level.dbname");
    private static final String DB_CONTEXT_NAME = SysLogPanel.getString("context.dbname");
    private static final String DB_HOST_NAME = SysLogPanel.getString("host.dbname");
    private static final String DB_PROCESS_NAME = SysLogPanel.getString("process.dbname");
    private static final String DB_THREAD_NAME = SysLogPanel.getString("thread.dbname");
    private static final String DB_MSG_NAME = SysLogPanel.getString("msg.dbname");
    private static final String DB_EXCEPTION_NAME = SysLogPanel.getString("exception.dbname");
    private static final int LEVEL_COL = SysLogUtils.getInt(DB_LEVEL_NAME + ".pos", 4);
    private static final int EXCEPTION_COL = SysLogUtils.getInt(DB_EXCEPTION_NAME + ".pos", 0);
    private static final int TIME_COL = SysLogUtils.getInt(DB_TIMESTAMP_NAME + ".pos", 1);
    private static final int MSG_COL = SysLogUtils.getInt(DB_MSG_NAME + ".pos", 2);
    private LabelWidget lblRecNum;
    private ConsoleAccumulatorPanel pnlAccum;
    private TimeSpanPanel pnlTimeSpan;
    private MaxRecordsPerQueryPanel pnlMaxRows;
    private JPanel pnlContexts;
    private JPanel pnlFilter;
    private JPanel pnlEntries;
    private Splitter splitMain;
    private Splitter splitMinor;
    private TableWidget tblEntries;
    private JTextArea txaMessage;
    private JTextArea txaException;
    private TextFieldWidget txfDetailTime;
    private TextFieldWidget txfLevel;
    private TextFieldWidget txfContext;
    private TextFieldWidget txfHost;
    private TextFieldWidget txfProcess;
    private TextFieldWidget txfThread;
    private ArrayList actions = new ArrayList();
    private PanelAction actionApply;
    private PanelAction actionReset;
    private PanelAction actionWriteFile;
    private PanelAction actionExportLogs;
    private String[] dbColumnNames;
    private DefaultTableModel tblModel;
    private String[] headers;
    private Vector headersAsVector;
    private Vector levelCheckBoxes;
    private int rowCount = 0;
    private boolean[] originalLevels;
    private boolean levelSelected;
    private boolean levelsDiffFromOriginal;
    private boolean contextsDiffFromOriginal;
    private boolean timeSpanValid = true;
    private boolean contextSelected = true;
    private boolean timeSpanChangedFromOriginal = false;
    private SimpleDateFormat formatter;
    private AutoRefresher arRefresher = null;
    private int paintCount = 0;
    private ConnectionInfo connection;
    private ServerLogManager logManager;
    private int startingMaxRows;
    private boolean maxRowsDiffFromOriginal = false;

    public SysLogPanel(ConnectionInfo conn) throws Exception {
        this.connection = conn;
        this.logManager = ModelManager.getServerLogManager(this.connection);
        this.setLayout(new GridLayout(1, 1, 10, 10));
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.construct();
        ArrayList allContexts = new ArrayList(this.logManager.getAllContexts());
        this.pnlAccum = new ConsoleAccumulatorPanel(allContexts);
        this.pnlAccum.setInitialValues(allContexts);
        this.pnlAccum.setValues(allContexts);
        this.pnlAccum.setAllowsReorderingValues(false);
        this.pnlAccum.setMinimumValuesAllowed(0);
        this.pnlAccum.getAcceptButton().setVisible(false);
        this.pnlAccum.getCancelButton().setVisible(false);
        this.pnlAccum.remove(this.pnlAccum.getNavigationBar());
        this.pnlAccum.getAvailableValuesHeader().setText(SysLogPanel.getString("pnlAccum.availablevalues.hdr"));
        this.pnlAccum.getValuesHeader().setText(SysLogPanel.getString("pnlAccum.selectedvalues.hdr"));
        this.pnlAccum.addListDataListener(this);
        this.pnlContexts.add(this.pnlAccum);
        List columnNames = LogEntryPropertyNames.COLUMN_NAMES;
        int size = columnNames.size();
        this.dbColumnNames = new String[size];
        this.headers = new String[size];
        this.headersAsVector = new Vector(size);
        this.headersAsVector.setSize(size);
        for (int i = 0; i < size; ++i) {
            String hdr;
            String dbName = (String)columnNames.get(i);
            int position = SysLogUtils.getInt(dbName + POSITION_SUFFIX, i);
            this.headers[position] = hdr = SysLogPanel.getString(dbName + HEADER_SUFFIX);
            this.headersAsVector.setElementAt(hdr, position);
            this.dbColumnNames[position] = dbName;
        }
        this.tblModel = SysLogUtils.setup(this.tblEntries, this.headers, SysLogUtils.getInt("tblrows", 20), null);
        PropertyProvider propProvider = PropertyProvider.getDefault();
        String patternKey = "date.formatter.date-time";
        String formatKey = SysLogUtils.getString("formatterKey", true);
        if (formatKey != null) {
            patternKey = formatKey;
        }
        this.formatter = (SimpleDateFormat)propProvider.getObject(patternKey);
        this.checkResetState();
    }

    @Override
    public void actionPerformed(ActionEvent theEvent) {
        Object source = theEvent.getSource();
        if (source instanceof CheckBox) {
            this.levelsDiffFromOriginal = false;
            this.levelSelected = false;
            int size = this.levelCheckBoxes.size();
            for (int i = 1; i < size; ++i) {
                CheckBox chk = (CheckBox)this.levelCheckBoxes.get(i);
                if (!this.levelSelected && chk.isSelected()) {
                    this.levelSelected = true;
                }
                if (!this.levelsDiffFromOriginal && chk.isSelected() != this.originalLevels[i]) {
                    this.levelsDiffFromOriginal = true;
                }
                if (this.levelSelected && this.levelsDiffFromOriginal) break;
            }
            this.checkResetState();
        }
    }

    private void checkResetState() {
        this.actionApply.setEnabled(this.timeSpanValid && this.levelSelected && this.contextSelected);
        this.actionReset.setEnabled(this.levelsDiffFromOriginal || this.timeSpanChangedFromOriginal || this.contextsDiffFromOriginal || this.maxRowsDiffFromOriginal);
    }

    private void clearDetailPanel() {
        this.txfDetailTime.setText("");
        this.txfLevel.setText("");
        this.txfContext.setText("");
        this.txfHost.setText("");
        this.txfProcess.setText("");
        this.txfThread.setText("");
        this.txaMessage.setText("");
        this.txaException.setText("");
    }

    private void construct() throws Exception {
        this.actionApply = new PanelAction(0);
        this.actionApply.setEnabled(false);
        this.actions.add(new MenuEntry("action", this.actionApply));
        this.actionReset = new PanelAction(1);
        this.actionReset.setEnabled(false);
        this.actions.add(new MenuEntry("action", this.actionReset));
        this.actionWriteFile = new PanelAction(3);
        this.actionWriteFile.setEnabled(false);
        this.actions.add(new MenuEntry("action", this.actionWriteFile));
        this.actionExportLogs = new PanelAction(4);
        this.actionExportLogs.setEnabled(true);
        this.actions.add(new MenuEntry("action", this.actionExportLogs));
        Insets INSETS = new Insets(3, 3, 0, 0);
        this.splitMain = new Splitter(0);
        this.splitMain.setOneTouchExpandable(true);
        this.add(this.splitMain);
        this.pnlFilter = new JPanel(new GridBagLayout());
        this.splitMain.setTopComponent(new JScrollPane(this.pnlFilter));
        GridBagConstraints gbcFilter = new GridBagConstraints();
        gbcFilter.gridx = 0;
        gbcFilter.gridy = 0;
        gbcFilter.insets = INSETS;
        JTabbedPane tpnFilter = new JTabbedPane();
        gbcFilter.fill = 1;
        gbcFilter.weightx = 1.0;
        gbcFilter.weighty = 1.0;
        this.pnlFilter.add((Component)tpnFilter, gbcFilter);
        Date serverStartTime = null;
        serverStartTime = this.getRuntimeAPI().getServerStartTime();
        if (serverStartTime == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(10, -1);
            serverStartTime = cal.getTime();
        }
        this.pnlTimeSpan = new TimeSpanPanel(serverStartTime, new Date(), this);
        tpnFilter.addTab(SysLogPanel.getString("tpnFilter.timeframe.tab"), this.pnlTimeSpan);
        JPanel pnlLevels = new JPanel(new GridBagLayout());
        tpnFilter.addTab(SysLogPanel.getString("tpnFilter.levels.tab"), pnlLevels);
        GridBagConstraints gbcLevels = new GridBagConstraints();
        gbcLevels.gridx = 0;
        gbcLevels.gridy = 0;
        LabelWidget lblLevelMsg = new LabelWidget(SysLogPanel.getString("lblLevelMsg"));
        gbcLevels.gridwidth = 0;
        gbcLevels.insets = new Insets(20, 3, 20, 3);
        pnlLevels.add((Component)lblLevelMsg, gbcLevels);
        int maxLevel = MessageLevel.getMaximumLevel();
        int minLevel = MessageLevel.getMinimumLevel();
        this.levelCheckBoxes = new Vector(maxLevel - minLevel + 1);
        this.levelCheckBoxes.setSize(maxLevel - minLevel + 1);
        this.originalLevels = new boolean[maxLevel - minLevel + 1];
        gbcLevels.gridy = 1;
        gbcLevels.insets = new Insets(3, 3, 3, 10);
        gbcLevels.gridwidth = 1;
        for (int i = minLevel + 1; i < maxLevel + 1; ++i) {
            CheckBox chk = new CheckBox(SysLogPanel.getString(MSG_LEVEL_PREFIX + i));
            chk.addActionListener(this);
            this.levelCheckBoxes.set(i, chk);
            pnlLevels.add((Component)chk, gbcLevels);
            ++gbcLevels.gridx;
        }
        int[] defaultLevelIndexes = (int[])SysLogUtils.getObject("msglevel.defaults");
        if (defaultLevelIndexes != null) {
            if (defaultLevelIndexes.length > 0) {
                this.levelSelected = true;
            }
            for (int i = 0; i < defaultLevelIndexes.length; ++i) {
                CheckBox chk = (CheckBox)this.levelCheckBoxes.get(defaultLevelIndexes[i]);
                chk.setSelected(true);
                this.originalLevels[defaultLevelIndexes[i]] = true;
            }
        }
        this.pnlContexts = new JPanel(new GridLayout(1, 1));
        tpnFilter.addTab(SysLogPanel.getString("tpnFilter.contexts.tab"), this.pnlContexts);
        int warningThresholdVal = SUPPRESS_HIGH_LIMIT_WARNING ? -1 : 20000;
        if (!MAX_ROWS_HAS_BEEN_RESET) {
            String maxRowsString = this.getConfigAPI().getCurrentConfiguration().getProperty(MAX_LOG_ROWS_RETURNED);
            try {
                MAX_ROWS_VALUE = Integer.parseInt(maxRowsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.startingMaxRows = MAX_ROWS_VALUE;
        this.pnlMaxRows = new MaxRecordsPerQueryPanel(this, warningThresholdVal, MAX_ROWS_VALUE);
        tpnFilter.addTab(SysLogPanel.getString("tpnFilter.maxrows.tab"), this.pnlMaxRows);
        JPanel pnlOps = new JPanel();
        gbcFilter.gridx = 1;
        gbcFilter.fill = 0;
        gbcFilter.weightx = 0.0;
        gbcFilter.weighty = 0.0;
        this.pnlFilter.add((Component)pnlOps, gbcFilter);
        JPanel pnlOpsSizer = new JPanel(new GridLayout(2, 1, 0, 5));
        pnlOps.add(pnlOpsSizer);
        ButtonWidget btnApply = new ButtonWidget();
        this.actionApply.addComponent(btnApply);
        pnlOpsSizer.add(btnApply);
        ButtonWidget btnReset = new ButtonWidget();
        this.actionReset.addComponent(btnReset);
        pnlOpsSizer.add(btnReset);
        this.splitMinor = new Splitter(0);
        this.splitMinor.setOneTouchExpandable(true);
        this.splitMain.setBottomComponent(this.splitMinor);
        this.pnlEntries = new JPanel(new GridLayout(1, 1));
        this.splitMinor.setTopComponent(this.pnlEntries);
        this.tblEntries = new TableWidget();
        this.tblEntries.setEditable(false);
        this.tblEntries.getSelectionModel().addListSelectionListener(this);
        JScrollPane spnEntries = new JScrollPane(this.tblEntries);
        this.pnlEntries.add(spnEntries);
        JPanel pnlDetail = new JPanel(new GridBagLayout());
        JScrollPane spn = new JScrollPane(pnlDetail);
        this.splitMinor.setBottomComponent(spn);
        GridBagConstraints gbcDetail = new GridBagConstraints();
        gbcDetail.gridx = 0;
        gbcDetail.gridy = 0;
        gbcDetail.insets = INSETS;
        LabelWidget lblDetailTime = new LabelWidget(SysLogPanel.getString("lblDetailTime"));
        gbcDetail.anchor = 13;
        pnlDetail.add((Component)lblDetailTime, gbcDetail);
        this.txfDetailTime = GuiComponentFactory.createTextField("timestamp");
        this.txfDetailTime.setEditable(false);
        gbcDetail.gridx = 1;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)this.txfDetailTime, gbcDetail);
        LabelWidget lblLevel = new LabelWidget(SysLogPanel.getString("lblLevel"));
        gbcDetail.gridx = 2;
        gbcDetail.anchor = 13;
        pnlDetail.add((Component)lblLevel, gbcDetail);
        this.txfLevel = GuiComponentFactory.createTextField("loglevelname");
        this.txfLevel.setEditable(false);
        gbcDetail.gridx = 3;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)this.txfLevel, gbcDetail);
        this.lblRecNum = new LabelWidget();
        gbcDetail.gridx = 4;
        pnlDetail.add((Component)this.lblRecNum, gbcDetail);
        LabelWidget lblContext = new LabelWidget(SysLogPanel.getString("lblContext"));
        gbcDetail.gridx = 0;
        gbcDetail.gridy = 1;
        gbcDetail.anchor = 13;
        pnlDetail.add((Component)lblContext, gbcDetail);
        this.txfContext = GuiComponentFactory.createTextField("logcontextname");
        this.txfContext.setEditable(false);
        gbcDetail.gridx = 1;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)this.txfContext, gbcDetail);
        LabelWidget lblThread = new LabelWidget(SysLogPanel.getString("lblThread"));
        gbcDetail.gridx = 2;
        gbcDetail.anchor = 13;
        pnlDetail.add((Component)lblThread, gbcDetail);
        this.txfThread = GuiComponentFactory.createTextField("threadname");
        this.txfThread.setEditable(false);
        gbcDetail.gridx = 3;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)this.txfThread, gbcDetail);
        LabelWidget lblHost = new LabelWidget(SysLogPanel.getString("lblHost"));
        gbcDetail.gridx = 0;
        gbcDetail.gridy = 2;
        gbcDetail.anchor = 13;
        gbcDetail.gridwidth = 1;
        pnlDetail.add((Component)lblHost, gbcDetail);
        this.txfHost = GuiComponentFactory.createTextField("hostname");
        this.txfHost.setEditable(false);
        gbcDetail.gridx = 1;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)this.txfHost, gbcDetail);
        LabelWidget lblProcess = new LabelWidget(SysLogPanel.getString("lblProcess"));
        gbcDetail.gridx = 2;
        gbcDetail.anchor = 13;
        pnlDetail.add((Component)lblProcess, gbcDetail);
        this.txfProcess = GuiComponentFactory.createTextField("processname");
        this.txfProcess.setEditable(false);
        gbcDetail.gridx = 3;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)this.txfProcess, gbcDetail);
        LabelWidget lblMessage = new LabelWidget(SysLogPanel.getString("lblMessage"));
        gbcDetail.gridx = 0;
        gbcDetail.gridy = 3;
        gbcDetail.anchor = 13;
        gbcDetail.gridwidth = 1;
        pnlDetail.add((Component)lblMessage, gbcDetail);
        this.txaMessage = new JTextArea();
        this.txaMessage.setWrapStyleWord(true);
        this.txaMessage.setLineWrap(true);
        this.txaMessage.setEditable(false);
        this.txaMessage.setRows(SysLogUtils.getInt("txaMessage.rows", 2));
        JScrollPane spnMessage = new JScrollPane(this.txaMessage);
        gbcDetail.gridx = 1;
        gbcDetail.gridwidth = 0;
        gbcDetail.weightx = 1.0;
        gbcDetail.weighty = 1.0;
        gbcDetail.fill = 1;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)spnMessage, gbcDetail);
        LabelWidget lblException = new LabelWidget(SysLogPanel.getString("lblException"));
        gbcDetail.gridx = 0;
        gbcDetail.gridy = 4;
        gbcDetail.gridwidth = 1;
        gbcDetail.weightx = 0.0;
        gbcDetail.weighty = 0.0;
        gbcDetail.fill = 0;
        gbcDetail.anchor = 13;
        pnlDetail.add((Component)lblException, gbcDetail);
        this.txaException = new JTextArea();
        this.txaException.setWrapStyleWord(true);
        this.txaException.setLineWrap(true);
        this.txaException.setEditable(false);
        this.txaException.setRows(SysLogUtils.getInt("txaException.rows", 2));
        JScrollPane spnException = new JScrollPane(this.txaException);
        gbcDetail.gridx = 1;
        gbcDetail.gridwidth = 0;
        gbcDetail.weightx = 1.0;
        gbcDetail.weighty = 1.0;
        gbcDetail.fill = 1;
        gbcDetail.anchor = 17;
        pnlDetail.add((Component)spnException, gbcDetail);
        this.pnlFilter.setPreferredSize(this.pnlFilter.getMinimumSize());
        pnlDetail.setMinimumSize(pnlDetail.getPreferredSize());
        this.arRefresher = new AutoRefresher(this, 15, false, this.connection);
        this.arRefresher.init();
        this.arRefresher.startTimer();
    }

    @Override
    public void doNotDisplayWarningMessage() {
        SUPPRESS_HIGH_LIMIT_WARNING = true;
    }

    @Override
    public void maximumChanged(int newVal) {
        MAX_ROWS_VALUE = newVal;
        MAX_ROWS_HAS_BEEN_RESET = true;
        this.maxRowsDiffFromOriginal = newVal != this.startingMaxRows;
        this.checkResetState();
    }

    @Override
    public void timeSpanValidityChanged(boolean isNowValid) {
        this.timeSpanValid = isNowValid;
        this.checkResetState();
    }

    @Override
    public void timeSpanChangedFromOriginal(boolean nowChanged) {
        this.timeSpanChangedFromOriginal = nowChanged;
        this.checkResetState();
    }

    @Override
    public void contentsChanged(ListDataEvent theEvent) {
        List initVals;
        List currVals = this.pnlAccum.getValues();
        this.contextsDiffFromOriginal = !currVals.containsAll(initVals = this.pnlAccum.getInitialValues()) || currVals.size() != initVals.size();
        this.contextSelected = currVals.size() != 0;
        this.checkResetState();
    }

    private List getSelectedContexts() {
        List availableValues = this.pnlAccum.getAvailableValues();
        if (availableValues == null || availableValues.isEmpty()) {
            return null;
        }
        return new ArrayList(this.pnlAccum.getValues());
    }

    private List getSelectedLevels() {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        int size = this.levelCheckBoxes.size();
        for (int i = 1; i < size; ++i) {
            CheckBox chk = (CheckBox)this.levelCheckBoxes.get(i);
            if (!chk.isSelected()) continue;
            levels.add(new Integer(i));
        }
        return levels;
    }

    private static String getString(String theKey) {
        return SysLogUtils.getString(theKey);
    }

    @Override
    public String getTitle() {
        return SysLogPanel.getString("title");
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void intervalAdded(ListDataEvent theEvent) {
        this.contentsChanged(theEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent theEvent) {
        this.contentsChanged(theEvent);
    }

    private void populateTable(List entries) {
        Vector rows = new Vector();
        for (LogEntry entry : entries) {
            Vector<Object> row = new Vector<Object>(this.dbColumnNames.length);
            row.add(entry.getException());
            row.add(entry.getDate());
            row.add(entry.getMessage());
            row.add(entry.getContext());
            row.add(new Integer(entry.getLevel()));
            row.add(entry.getHostName());
            row.add(entry.getProcessName());
            row.add(entry.getThreadName());
            rows.add(row);
        }
        ColumnSortInfo[] columnSortInfo = ColumnSortInfo.getTableColumnSortInfo(this.tblEntries);
        this.tblModel.setDataVector(rows, this.headersAsVector);
        ColumnSortInfo.setColumnSortOrder(columnSortInfo, this.tblEntries);
        this.tblEntries.createModelRowMap();
        this.tblEntries.setEditable(false);
        SysLogTableCellRenderer rend = new SysLogTableCellRenderer();
        TableColumn col = this.tblEntries.getColumnModel().getColumn(LEVEL_COL);
        col.setCellRenderer(rend);
        col = this.tblEntries.getColumnModel().getColumn(EXCEPTION_COL);
        col.setCellRenderer(rend);
        col = this.tblEntries.getColumnModel().getColumn(TIME_COL);
        col.setCellRenderer(TableCellRendererFactory.createDateRenderer(this.formatter));
        col = this.tblEntries.getColumnModel().getColumn(MSG_COL);
        col.setMaxWidth(SysLogUtils.getInt(DB_MSG_NAME + ".col.width.max", col.getMaxWidth()));
        this.tblEntries.sizeColumnsToFitData(SysLogUtils.getInt("sizedatarowcount", 100));
        this.rowCount = this.tblEntries.getRowCount();
        if (this.rowCount > 0) {
            this.tblEntries.setRowSelectionInterval(0, 0);
            this.tblEntries.scrollRectToVisible(this.tblEntries.getCellRect(0, 0, true));
            this.tblEntries.requestFocus();
        }
    }

    private void reset() {
        if (this.levelsDiffFromOriginal) {
            int size = this.levelCheckBoxes.size();
            for (int i = 1; i < size; ++i) {
                CheckBox chk = (CheckBox)this.levelCheckBoxes.get(i);
                chk.setSelected(this.originalLevels[i]);
            }
            this.levelsDiffFromOriginal = false;
        }
        this.pnlAccum.resetValues();
        this.pnlTimeSpan.reset();
        this.pnlMaxRows.setValue(this.startingMaxRows);
        this.checkResetState();
    }

    @Override
    public List resume() {
        Date systemStartTime = null;
        try {
            systemStartTime = this.getRuntimeAPI().getServerStartTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (systemStartTime != null) {
            this.pnlTimeSpan.resetStartTime(systemStartTime);
        }
        return this.actions;
    }

    private void submitRequest(boolean showWarnings) {
        int maxRows = this.pnlMaxRows.getMaxRows();
        this.tblModel.setNumRows(0);
        this.clearDetailPanel();
        List levels = this.getSelectedLevels();
        List contexts = this.getSelectedContexts();
        try {
            List entries = this.logManager.getLogEntries(this.pnlTimeSpan.getStartingTime(), this.pnlTimeSpan.endsNow() ? null : this.pnlTimeSpan.getEndingTime(), levels, contexts, maxRows);
            int size = entries.size();
            if (size != 0) {
                this.populateTable(entries);
                if (!this.actionWriteFile.isEnabled()) {
                    this.actionWriteFile.setEnabled(true);
                }
            } else {
                if (this.actionWriteFile.isEnabled()) {
                    this.actionWriteFile.setEnabled(false);
                }
                this.lblRecNum.setText(SysLogUtils.getString("lblRecNum", new Object[]{"0", "0"}));
                if (!RowsNotSelectedPanel.isCurrentlyDisplayed()) {
                    RowsNotSelectedPanel pnl = new RowsNotSelectedPanel(size, maxRows);
                    String title = SysLogPanel.getString("title.norowsselected");
                    RowsNotSelectedPanel.incrementDisplayedPanelCount();
                    if (showWarnings) {
                        DialogWindow.show(ConsoleMainFrame.getInstance(), title, pnl);
                    }
                }
            }
            this.tblEntries.setPreferredSize(null);
            this.tblEntries.revalidate();
            this.checkResetState();
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage(theException.getMessage(), theException);
            LogManager.logError((String)"SYSTEMLOGGING", (Throwable)theException, (String)theException.getMessage());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent theEvent) {
        if (!theEvent.getValueIsAdjusting()) {
            this.clearDetailPanel();
            int row = this.tblEntries.getSelectedRow();
            if (row != -1) {
                row = this.tblEntries.convertRowIndexToModel(this.tblEntries.getSelectedRow());
                for (int i = 0; i < this.dbColumnNames.length; ++i) {
                    Object obj = this.tblModel.getValueAt(row, i);
                    if (obj == null) continue;
                    String value = obj.toString();
                    if (this.dbColumnNames[i].equals(DB_TIMESTAMP_NAME)) {
                        this.txfDetailTime.setText(this.formatter.format((Date)obj));
                        continue;
                    }
                    if (this.dbColumnNames[i].equals(DB_LEVEL_NAME)) {
                        this.txfLevel.setText(SysLogPanel.getString(MSG_LEVEL_PREFIX + value));
                        continue;
                    }
                    if (this.dbColumnNames[i].equals(DB_CONTEXT_NAME)) {
                        this.txfContext.setText(value);
                        continue;
                    }
                    if (this.dbColumnNames[i].equals(DB_HOST_NAME)) {
                        this.txfHost.setText(value);
                        continue;
                    }
                    if (this.dbColumnNames[i].equals(DB_PROCESS_NAME)) {
                        this.txfProcess.setText(value);
                        continue;
                    }
                    if (this.dbColumnNames[i].equals(DB_THREAD_NAME)) {
                        this.txfThread.setText(value);
                        continue;
                    }
                    if (this.dbColumnNames[i].equals(DB_MSG_NAME)) {
                        this.txaMessage.setText(value);
                        this.txaMessage.setCaretPosition(0);
                        continue;
                    }
                    if (!this.dbColumnNames[i].equals(DB_EXCEPTION_NAME)) continue;
                    if (value.trim().equalsIgnoreCase("null")) {
                        value = "";
                    }
                    this.txaException.setText(value);
                    this.txaException.setCaretPosition(0);
                }
            }
            this.lblRecNum.setText(SysLogUtils.getString("lblRecNum", new Object[]{"" + (row + 1), "" + this.rowCount}));
        }
    }

    @Override
    public String getName() {
        return "data.syslog";
    }

    @Override
    public void refresh() {
        if (this.timeSpanValid && this.levelSelected && this.contextSelected) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SysLogPanel.this.submitRequest(false);
                }
            });
        }
    }

    @Override
    public void setAutoRefreshEnabled(boolean b) {
        this.arRefresher.setAutoRefreshEnabled(b);
    }

    @Override
    public void setRefreshRate(int iRate) {
        this.arRefresher.setRefreshRate(iRate);
    }

    @Override
    public void setAutoRefresher(AutoRefresher ar) {
        this.arRefresher = ar;
    }

    @Override
    public AutoRefresher getAutoRefresher() {
        return this.arRefresher;
    }

    private void writeFile() {
        String[] extensions = new String[]{"txt"};
        FileSystemView view = new FileSystemView();
        String dirTxt = (String)UserPreferences.getInstance().getValue(LAST_SAVE_DIR_PREF_NAME);
        if (dirTxt != null) {
            try {
                view.setHome((TreeNode)view.lookup(dirTxt));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileSystemFilter[] filters = null;
        FileSystemFilter filter = new FileSystemFilter(view, extensions, "Log Files (*.txt)");
        filters = new FileSystemFilter[]{filter};
        DirectoryChooserPanel pnlChooser = new DirectoryChooserPanel((DirectoryEntryView)view, 1, (DirectoryEntryFilter[])filters);
        pnlChooser.setAcceptButtonLabel(SysLogPanel.getString("chooser.save"));
        pnlChooser.setShowPassThruFilter(false);
        DialogWindow.show(this, SysLogPanel.getString("chooser.title"), pnlChooser);
        if (pnlChooser.getSelectedButton() == pnlChooser.getAcceptButton()) {
            DirectoryEntry result = (DirectoryEntry)pnlChooser.getSelectedTreeNode();
            String LINE_SEP = System.getProperty("line.separator");
            int cols = this.tblEntries.getColumnModel().getColumnCount();
            StringBuffer txt = new StringBuffer();
            TableColumnModel colModel = this.tblEntries.getColumnModel();
            for (int i = 0; i < cols; ++i) {
                TableColumn col = colModel.getColumn(i);
                if (i == EXCEPTION_COL) {
                    txt.append(SysLogPanel.getString("exception.hdr"));
                } else {
                    txt.append(col.getHeaderValue());
                }
                if (i >= cols - 1) continue;
                txt.append("\t");
            }
            txt.append(LINE_SEP);
            int rows = this.tblModel.getRowCount();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    Object value = this.tblModel.getValueAt(i, j);
                    if (value != null) {
                        if (j == LEVEL_COL || j == TIME_COL) {
                            TableCellRenderer rend = this.tblEntries.getCellRenderer(i, j);
                            JLabel lbl = (JLabel)rend.getTableCellRendererComponent(this.tblEntries, value, false, false, i, j);
                            txt.append(lbl.getText());
                        } else {
                            txt.append(((String)value).replace('\t', ' '));
                        }
                    }
                    if (j >= cols - 1) continue;
                    txt.append("\t");
                }
                txt.append(LINE_SEP);
            }
            try {
                String filename = result.getNamespace();
                FileWriter writer = new FileWriter(filename);
                writer.write(txt.toString());
                writer.flush();
                writer.close();
                int index = filename.lastIndexOf(File.separatorChar);
                String path = filename.substring(0, index);
                UserPreferences.getInstance().setValue(LAST_SAVE_DIR_PREF_NAME, path);
                UserPreferences.getInstance().saveChanges();
            }
            catch (Exception theException) {
                theException.printStackTrace();
                ExceptionUtility.showMessage(theException.getMessage(), theException);
                LogManager.logError((String)"SYSTEMLOGGING", (Throwable)theException, (String)(this.getClass() + ":writeFile"));
            }
        }
    }

    private void exportLogs() {
        String[] extensions = new String[]{"zip"};
        FileSystemView view = new FileSystemView();
        String dirTxt = (String)UserPreferences.getInstance().getValue(LAST_SAVE_DIR_PREF_NAME);
        if (dirTxt != null) {
            try {
                view.setHome((TreeNode)view.lookup(dirTxt));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileSystemFilter[] filters = null;
        FileSystemFilter filter = new FileSystemFilter(view, extensions, "Zip Files (*.zip)");
        filters = new FileSystemFilter[]{filter};
        DirectoryChooserPanel pnlChooser = new DirectoryChooserPanel((DirectoryEntryView)view, 1, (DirectoryEntryFilter[])filters);
        pnlChooser.setAcceptButtonLabel(SysLogPanel.getString("chooser.save"));
        pnlChooser.setShowPassThruFilter(false);
        DialogWindow.show(this, SysLogPanel.getString("chooser.export.title"), pnlChooser);
        if (pnlChooser.getSelectedButton() == pnlChooser.getAcceptButton()) {
            DirectoryEntry result = (DirectoryEntry)pnlChooser.getSelectedTreeNode();
            String filename = result.getNamespace();
            ServerAdmin admin = null;
            try {
                admin = this.getConnection().getServerAdmin();
                byte[] logBytes = admin.exportLogs();
                FileUtils.write((byte[])logBytes, (File)new File(filename));
                String consoleLogDir = StaticProperties.getLogDirectory().getAbsolutePath();
                ZipFileUtil.addAll((File)new File(filename), (String)consoleLogDir, (String)"console");
            }
            catch (Exception theException) {
                theException.printStackTrace();
                ExceptionUtility.showMessage(theException.getMessage(), theException);
                LogManager.logError((String)"SYSTEMLOGGING", (Throwable)theException, (String)(this.getClass() + ":exportLogs"));
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.paintCount == 0) {
            this.paintCount = 1;
            Double mainLoc = (Double)SysLogUtils.getObject("splitter.main.pos");
            double mainDividerLoc = mainLoc != null ? mainLoc : 0.3;
            this.splitMain.setDividerLocation(mainDividerLoc);
        } else if (this.paintCount == 1) {
            this.paintCount = 2;
            Double minorLoc = (Double)SysLogUtils.getObject("splitter.minor.pos");
            double minorDividerLoc = minorLoc != null ? minorLoc : 0.5;
            this.splitMinor.setDividerLocation(minorDividerLoc);
        }
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    private RuntimeStateAdminAPI getRuntimeAPI() {
        return ModelManager.getRuntimeStateAPI(this.getConnection());
    }

    private ConfigurationAdminAPI getConfigAPI() {
        return ModelManager.getConfigurationAPI(this.getConnection());
    }

    class ConsoleAccumulatorPanel
    extends AccumulatorPanel {
        public ConsoleAccumulatorPanel(List l) {
            super(l);
            super.getResetButton().setVisible(false);
        }

        @Override
        protected DefaultListModel createDefaultListModel() {
            ConsoleDefaultListModel cdlm = new ConsoleDefaultListModel();
            return cdlm;
        }
    }

    class ConsoleDefaultListModel
    extends DefaultListModel {
        ConsoleDefaultListModel() {
        }

        public void add(int index, Object value) {
            super.add(index, value);
            if (value == null) {
                return;
            }
        }

        public void addElement(Object value) {
            super.addElement(value);
            List<Object> ac = Arrays.asList(this.toArray());
            Collections.sort(ac);
            int index = ac.indexOf(value);
            if (index != ac.size() - 1) {
                super.removeElement(value);
                this.add(index, value);
            }
        }
    }

    private class SysLogTableCellRenderer
    extends DefaultTableCellRenderer {
        private SysLogTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable theTable, Object theValue, boolean theSelectedFlag, boolean theHasFocusFlag, int theRow, int theColumn) {
            Object value = theValue;
            if (theColumn == LEVEL_COL) {
                try {
                    String txt = theValue.toString();
                    int level = Integer.parseInt(txt);
                    value = SysLogPanel.getString(SysLogPanel.MSG_LEVEL_PREFIX + level);
                }
                catch (NumberFormatException theException) {
                    value = theValue;
                }
            } else if (theColumn == EXCEPTION_COL) {
                boolean isNull;
                if (value == null) {
                    isNull = true;
                } else {
                    String str = value.toString();
                    isNull = str.trim().equalsIgnoreCase("null");
                }
                value = new Boolean(!isNull);
            }
            Component comp = super.getTableCellRendererComponent(theTable, value, theSelectedFlag, theHasFocusFlag, theRow, theColumn);
            return comp;
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int APPLY = 0;
        public static final int RESET = 1;
        public static final int WRITE_FILE = 3;
        public static final int EXPORT_LOGS = 4;

        public PanelAction(int theType) {
            super(theType);
            if (theType == 0) {
                this.putValue("Name", SysLogPanel.getString("actionApply"));
                this.putValue("ShortDescription", SysLogPanel.getString("actionApply.tip"));
                this.setMnemonic(SysLogUtils.getMnemonic("actionApply.mnemonic"));
            } else if (theType == 1) {
                this.putValue("Name", SysLogPanel.getString("actionReset"));
                this.putValue("ShortDescription", SysLogPanel.getString("actionReset.tip"));
                this.setMnemonic(SysLogUtils.getMnemonic("actionReset.mnemonic"));
            } else if (theType == 3) {
                this.putValue("ShortDescription", SysLogPanel.getString("actionWriteFile.tip"));
                this.putValue("menu.item.name", SysLogPanel.getString("actionWriteFile.menu"));
                this.setMnemonic(SysLogUtils.getMnemonic("actionWriteFile.mnemonic"));
            } else if (theType == 4) {
                this.putValue("ShortDescription", SysLogPanel.getString("actionExportLogs.tip"));
                this.putValue("menu.item.name", SysLogPanel.getString("actionExportLogs.menu"));
                this.setMnemonic(SysLogUtils.getMnemonic("actionExportLogs.mnemonic"));
            } else {
                throw new IllegalArgumentException(SysLogUtils.getString("invalidactiontype", new Object[]{"" + theType}));
            }
        }

        @Override
        protected void actionImpl(ActionEvent theEvent) {
            if (this.type == 0) {
                SysLogPanel.this.submitRequest(true);
            } else if (this.type == 1) {
                SysLogPanel.this.reset();
            } else if (this.type == 3) {
                SysLogPanel.this.writeFile();
            } else if (this.type == 4) {
                SysLogPanel.this.exportLogs();
            }
        }
    }
}

