/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.views.syslog.TimeSpanButtonSelectionListener;
import com.metamatrix.console.ui.views.syslog.TimeSpanEndingPanel;
import com.metamatrix.console.ui.views.syslog.TimeSpanPanelValidityListener;
import com.metamatrix.console.ui.views.syslog.TimeSpanStartingPanel;
import com.metamatrix.console.util.QCDateTime;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TimeSpanPanel
extends JPanel
implements TimeSpanButtonSelectionListener,
DocumentListener {
    public static final int NOW_INDEX = 1;
    public static final int SYSTEM_START_INDEX = 1;
    public static final int SUBPANEL_CONFIGURABLE_INDEX = 1;
    public static final int SPECIFIED_TIME_INDEX = 2;
    public static final int BEFORE_AFTER_INDEX = 3;
    public static final int STARTING_PANEL_INITIAL_INDEX = 3;
    public static final int ENDING_PANEL_INITIAL_INDEX = 1;
    private Date startingDateTime;
    private Date currentDateTime;
    private TimeSpanPanelValidityListener listener;
    private boolean isNowValid = true;
    private TimeSpanStartingPanel startingPanel;
    private TimeSpanEndingPanel endingPanel;
    private int startingPanelCurrentSelection = 3;
    private int endingPanelCurrentSelection = 1;
    private boolean initialized = false;

    public TimeSpanPanel(Date starting, Date current, TimeSpanPanelValidityListener lstnr) {
        this.startingDateTime = starting;
        this.currentDateTime = current;
        this.listener = lstnr;
        this.init();
    }

    private void init() {
        this.startingPanel = new TimeSpanStartingPanel(this, this, this.startingDateTime);
        this.endingPanel = new TimeSpanEndingPanel(this, this, this.currentDateTime);
        this.startingPanel.addCalendarChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                TimeSpanPanel.this.calendarChanged(ev);
            }
        });
        this.endingPanel.addCalendarChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                TimeSpanPanel.this.calendarChanged(ev);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.startingPanel);
        this.add(this.endingPanel);
        layout.setConstraints(this.startingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        layout.setConstraints(this.endingPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.startingPanel.pressButton(3);
        this.initialized = true;
    }

    public void reset() {
        this.startingPanel.pressButton(3);
        this.endingPanel.pressButton(1);
        this.startingPanel.resetUnits();
        this.endingPanel.resetUnits();
        this.resetStartTime(this.startingDateTime);
        this.startingPanel.setCalendar(this.startingDateTime);
        this.currentDateTime = new Date();
        this.endingPanel.setCalendar(this.currentDateTime);
    }

    public void resetStartTime(Date systemStartTime) {
        this.startingPanel.resetStartTime(systemStartTime);
        this.startingDateTime = systemStartTime;
    }

    public boolean endsNow() {
        return this.endingPanelCurrentSelection == 1;
    }

    public Date getStartingTime() {
        Date startTime = null;
        switch (this.startingPanelCurrentSelection) {
            case 1: {
                startTime = this.startingDateTime;
                break;
            }
            case 2: {
                startTime = this.startingPanel.getSecondItemCalendarPanelTime();
                break;
            }
            case 3: {
                Date endTime = this.getEndingTime();
                long endTimeLong = endTime.getTime();
                int numUnits = this.startingPanel.getThirdItemNumUnits();
                long numMillisecondsPerUnit = 0L;
                if (this.startingPanel.isMinutesSelected()) {
                    numMillisecondsPerUnit = 60000L;
                } else if (this.startingPanel.isHoursSelected()) {
                    numMillisecondsPerUnit = 3600000L;
                } else if (this.startingPanel.isDaysSelected()) {
                    numMillisecondsPerUnit = 86400000L;
                }
                long millisecondsToSubtract = (long)numUnits * numMillisecondsPerUnit;
                long adjustedTime = endTimeLong - millisecondsToSubtract;
                startTime = new Date(adjustedTime);
            }
        }
        return startTime;
    }

    public Date getEndingTime() {
        Date endTime = null;
        switch (this.endingPanelCurrentSelection) {
            case 1: {
                endTime = new Date();
                break;
            }
            case 2: {
                endTime = this.endingPanel.getSecondItemCalendarPanelTime();
                break;
            }
            case 3: {
                Date startTime = this.getStartingTime();
                long startTimeLong = startTime.getTime();
                int numUnits = this.endingPanel.getThirdItemNumUnits();
                long numMillisecondsPerUnit = 0L;
                if (this.endingPanel.isMinutesSelected()) {
                    numMillisecondsPerUnit = 60000L;
                } else if (this.endingPanel.isHoursSelected()) {
                    numMillisecondsPerUnit = 3600000L;
                } else if (this.endingPanel.isDaysSelected()) {
                    numMillisecondsPerUnit = 86400000L;
                }
                long millisecondsToAdd = (long)numUnits * numMillisecondsPerUnit;
                long adjustedTime = startTimeLong + millisecondsToAdd;
                endTime = new Date(adjustedTime);
            }
        }
        return endTime;
    }

    @Override
    public void buttonSelectionChanged(Component sender, int selection) {
        boolean handled = false;
        if (sender == this.startingPanel) {
            this.startingPanelCurrentSelection = selection;
            this.endingPanel.setThirdButtonEnabled(selection != 3);
            handled = true;
        } else if (sender == this.endingPanel) {
            this.endingPanelCurrentSelection = selection;
            this.startingPanel.setThirdButtonEnabled(selection != 3);
            handled = true;
        }
        if (handled) {
            this.checkForValidityChange();
            this.checkForChangeFromOriginal();
        }
    }

    public void calendarChanged(ChangeEvent ev) {
        this.checkForChangeFromOriginal();
    }

    private void checkForValidityChange() {
        if (this.listener != null) {
            int num;
            Integer n;
            boolean valid = true;
            if (this.startingPanelCurrentSelection == 3 && this.endingPanelCurrentSelection == 3) {
                valid = false;
            }
            if (valid && this.startingPanelCurrentSelection == 3 && this.startingPanel != null) {
                n = this.startingPanel.getThirdItemNumUnits();
                if (n == null) {
                    valid = false;
                } else {
                    num = n;
                    if (num <= 0) {
                        valid = false;
                    }
                }
            }
            if (valid && this.endingPanelCurrentSelection == 3 && this.endingPanel != null) {
                n = this.endingPanel.getThirdItemNumUnits();
                if (n == null) {
                    valid = false;
                } else {
                    num = n;
                    if (num <= 0) {
                        valid = false;
                    }
                }
            }
            if (valid != this.isNowValid) {
                this.isNowValid = valid;
                this.listener.timeSpanValidityChanged(this.isNowValid);
            }
        }
    }

    public boolean changedFromOriginal() {
        QCDateTime endingDateTimeForComparison;
        QCDateTime startingDateTimeForComparison;
        if (this.startingPanelCurrentSelection != 3) {
            return true;
        }
        if (this.endingPanelCurrentSelection != 1) {
            return true;
        }
        Date startingPanelCalendarDate = this.startingPanel.getSecondItemCalendarPanelTime();
        QCDateTime startingPanelDateForComparison = new QCDateTime(startingPanelCalendarDate, false, true);
        if (!startingPanelDateForComparison.equals(startingDateTimeForComparison = new QCDateTime(this.startingDateTime, false, true))) {
            return true;
        }
        Date endingPanelCalendarDate = this.endingPanel.getSecondItemCalendarPanelTime();
        QCDateTime endingPanelDateForComparison = new QCDateTime(endingPanelCalendarDate, false, true);
        if (!endingPanelDateForComparison.equals(endingDateTimeForComparison = new QCDateTime(this.currentDateTime, false, true))) {
            return true;
        }
        if (this.startingPanel.unitsChanged()) {
            return true;
        }
        return this.endingPanel.unitsChanged();
    }

    public void checkForChangeFromOriginal() {
        boolean changed = this.changedFromOriginal();
        this.listener.timeSpanChangedFromOriginal(changed);
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
        this.numUnitsTextFieldChanged(ev);
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.numUnitsTextFieldChanged(ev);
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        this.numUnitsTextFieldChanged(ev);
    }

    private void numUnitsTextFieldChanged(DocumentEvent ev) {
        this.checkForValidityChange();
        if (this.initialized) {
            this.checkForChangeFromOriginal();
        }
    }
}

