/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.syslog.TimeSpanButtonSelectionListener;
import com.metamatrix.console.ui.views.syslog.UnitsTypeSelector;
import com.metamatrix.toolbox.ui.widget.CalendarPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

public abstract class TimeSpanStartingOrEndingPanel
extends JPanel {
    public static final int DATE_TIME_TEXT_FIELD_WIDTH = 17;
    private static final int VERTICAL_GAP_BETWEEN_ROWS = 6;
    private static final int LEFT_MARGIN = 10;
    private static final int RIGHT_MARGIN = 10;
    private static final int RADIO_BUTTON_RIGHT_MARGIN = 0;
    private static final String UNITS_FIELD_INITIAL_TEXT = "30";
    private static final int UNITS_TYPE_INITIAL_INDEX = 0;
    private TimeSpanButtonSelectionListener buttonSelectionListener;
    private DocumentListener numUnitsListener;
    protected CalendarPanel secondItemCalendarPanel = new CalendarPanel(ConsoleMainFrame.getInstance());
    protected Date calendarPanelStartingDate;
    private TextFieldWidget thirdItemNumUnitsField;
    protected JRadioButton firstItemRadioButton = new JRadioButton("");
    protected JRadioButton secondItemRadioButton = new JRadioButton("");
    protected JRadioButton thirdItemRadioButton = new JRadioButton("");
    private JRadioButton lastButtonSelected = null;
    private boolean programmaticButtonSelection = false;
    protected JPanel firstRowPanel;
    protected GridBagLayout firstRowLayout;
    private UnitsTypeSelector unitsTypeSelector = new UnitsTypeSelector();
    private SimpleDateFormat format = new SimpleDateFormat("MMM dd, yyyy HH:mm");

    public TimeSpanStartingOrEndingPanel(TimeSpanButtonSelectionListener buttonListener, DocumentListener unitsListener, Date secondItemDate, String borderTitle, String thirdItemPhrase, int initiallySelectedButton) {
        this.buttonSelectionListener = buttonListener;
        this.numUnitsListener = unitsListener;
        this.calendarPanelStartingDate = secondItemDate;
        this.init(borderTitle, thirdItemPhrase, initiallySelectedButton);
    }

    private void init(String borderTitle, String thirdItemPhrase, int initiallySelectedButton) {
        this.setBorder(new TitledBorder(borderTitle));
        this.setLayout(new GridLayout(3, 1, 0, 6));
        ButtonGroup buttonGroup = new ButtonGroup();
        block12: for (int i = 0; i < 3; ++i) {
            JPanel curRowPanel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            curRowPanel.setLayout(layout);
            switch (i) {
                case 0: {
                    buttonGroup.add(this.firstItemRadioButton);
                    curRowPanel.add(this.firstItemRadioButton);
                    layout.setConstraints(this.firstItemRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
                    this.firstItemRadioButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            TimeSpanStartingOrEndingPanel.this.buttonPressed();
                        }
                    });
                    JPanel firstRowInfoPanel = new JPanel();
                    this.firstRowLayout = new GridBagLayout();
                    firstRowInfoPanel.setLayout(this.firstRowLayout);
                    curRowPanel.add(firstRowInfoPanel);
                    layout.setConstraints(firstRowInfoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
                    this.add(curRowPanel);
                    this.firstRowPanel = firstRowInfoPanel;
                    continue block12;
                }
                case 1: {
                    buttonGroup.add(this.secondItemRadioButton);
                    curRowPanel.add(this.secondItemRadioButton);
                    layout.setConstraints(this.secondItemRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
                    this.secondItemRadioButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            TimeSpanStartingOrEndingPanel.this.buttonPressed();
                        }
                    });
                    JPanel secondRowInfoPanel = new JPanel();
                    curRowPanel.add(secondRowInfoPanel);
                    layout.setConstraints(secondRowInfoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
                    GridBagLayout secondRowLayout = new GridBagLayout();
                    secondRowInfoPanel.setLayout(secondRowLayout);
                    LabelWidget secondRowAt = new LabelWidget("At:");
                    secondRowInfoPanel.add(secondRowAt);
                    secondRowLayout.setConstraints(secondRowAt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    secondRowInfoPanel.add(this.secondItemCalendarPanel);
                    secondRowLayout.setConstraints(this.secondItemCalendarPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 6, 0, 10), 0, 0));
                    this.secondItemCalendarPanel.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent ev) {
                            TimeSpanStartingOrEndingPanel.this.calendarPanelStateChanged();
                        }
                    });
                    this.setCalendar(this.calendarPanelStartingDate);
                    this.add(curRowPanel);
                    continue block12;
                }
                case 2: {
                    buttonGroup.add(this.thirdItemRadioButton);
                    curRowPanel.add(this.thirdItemRadioButton);
                    layout.setConstraints(this.thirdItemRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
                    this.thirdItemRadioButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            TimeSpanStartingOrEndingPanel.this.buttonPressed();
                        }
                    });
                    JPanel thirdRowInfoPanel = new JPanel();
                    curRowPanel.add(thirdRowInfoPanel);
                    layout.setConstraints(thirdRowInfoPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    GridBagLayout thirdRowLayout = new GridBagLayout();
                    thirdRowInfoPanel.setLayout(thirdRowLayout);
                    this.thirdItemNumUnitsField = new TextFieldWidget(5);
                    this.thirdItemNumUnitsField.getDocument().addDocumentListener(this.numUnitsListener);
                    try {
                        this.thirdItemNumUnitsField.setValidCharacters("0123456789");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.thirdItemNumUnitsField.setHorizontalAlignment(4);
                    this.thirdItemNumUnitsField.setMinimumSize(this.thirdItemNumUnitsField.getPreferredSize());
                    thirdRowInfoPanel.add(this.thirdItemNumUnitsField);
                    thirdRowLayout.setConstraints(this.thirdItemNumUnitsField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    thirdRowInfoPanel.add(this.unitsTypeSelector);
                    thirdRowLayout.setConstraints(this.unitsTypeSelector, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
                    this.resetUnits();
                    this.unitsTypeSelector.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            TimeSpanStartingOrEndingPanel.this.buttonPressed();
                        }
                    });
                    LabelWidget thirdRowRightLabel = new LabelWidget(thirdItemPhrase);
                    thirdRowInfoPanel.add(thirdRowRightLabel);
                    thirdRowLayout.setConstraints(thirdRowRightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 10), 0, 0));
                    this.add(curRowPanel);
                }
            }
        }
        switch (initiallySelectedButton) {
            case 1: {
                this.firstItemRadioButton.setSelected(true);
                this.lastButtonSelected = this.firstItemRadioButton;
                break;
            }
            case 2: {
                this.secondItemRadioButton.setSelected(true);
                this.lastButtonSelected = this.secondItemRadioButton;
                break;
            }
            case 3: {
                this.thirdItemRadioButton.setSelected(true);
                this.lastButtonSelected = this.thirdItemRadioButton;
            }
        }
        this.buttonPressed();
    }

    public void resetUnits() {
        if (this.thirdItemNumUnitsField != null && UNITS_FIELD_INITIAL_TEXT != null) {
            this.thirdItemNumUnitsField.setText(UNITS_FIELD_INITIAL_TEXT);
        }
        if (this.unitsTypeSelector != null) {
            this.unitsTypeSelector.setSelectedIndex(0);
        }
    }

    protected String formatDate(Date date) {
        return this.format.format(date);
    }

    private void calendarPanelStateChanged() {
        Date calDate = this.getSecondItemCalendarPanelTime();
        if (calDate == null) {
            this.setCalendar(this.calendarPanelStartingDate);
        }
    }

    public Date getSecondItemCalendarPanelTime() {
        return this.secondItemCalendarPanel.getTimestamp();
    }

    public void setCalendar(Date date) {
        this.calendarPanelStartingDate = date;
        if (this.secondItemCalendarPanel != null) {
            this.secondItemCalendarPanel.setDate(date);
        }
    }

    public void pressButton(int buttonIndicator) {
        switch (buttonIndicator) {
            case 1: {
                this.firstItemRadioButton.doClick();
                break;
            }
            case 2: {
                this.secondItemRadioButton.doClick();
                break;
            }
            case 3: {
                this.thirdItemRadioButton.doClick();
            }
        }
    }

    protected void buttonPressed() {
        if (!this.programmaticButtonSelection) {
            if (this.firstItemRadioButton.isSelected()) {
                this.secondItemCalendarPanel.setEnabled(false);
                this.thirdItemNumUnitsField.setEnabled(false);
                this.unitsTypeSelector.setEnabled(false);
                this.buttonSelectionListener.buttonSelectionChanged(this, 1);
            } else if (this.secondItemRadioButton.isSelected()) {
                this.secondItemCalendarPanel.setEnabled(true);
                this.thirdItemNumUnitsField.setEnabled(false);
                this.unitsTypeSelector.setEnabled(false);
                this.buttonSelectionListener.buttonSelectionChanged(this, 2);
            } else if (this.thirdItemRadioButton.isSelected()) {
                this.secondItemCalendarPanel.setEnabled(false);
                this.thirdItemNumUnitsField.setEnabled(true);
                this.unitsTypeSelector.setEnabled(true);
                this.buttonSelectionListener.buttonSelectionChanged(this, 3);
            } else {
                this.programmaticButtonSelection = true;
                this.lastButtonSelected.setSelected(true);
                this.programmaticButtonSelection = false;
            }
        }
    }

    public void setThirdButtonEnabled(boolean flag) {
        this.thirdItemRadioButton.setEnabled(flag);
    }

    public Integer getThirdItemNumUnits() {
        Integer numUnits = null;
        try {
            numUnits = new Integer(this.thirdItemNumUnitsField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return numUnits;
    }

    public boolean unitsChanged() {
        boolean changed = false;
        String unitsText = this.thirdItemNumUnitsField.getText();
        if (!unitsText.equals(UNITS_FIELD_INITIAL_TEXT)) {
            changed = true;
        } else {
            int unitsIndex = this.unitsTypeSelector.getSelectedIndex();
            if (unitsIndex != 0) {
                changed = true;
            }
        }
        return changed;
    }

    public void addCalendarChangeListener(ChangeListener listener) {
        this.secondItemCalendarPanel.addChangeListener(listener);
    }

    public boolean isMinutesSelected() {
        return this.unitsTypeSelector.isMinutesSelected();
    }

    public boolean isHoursSelected() {
        return this.unitsTypeSelector.isHoursSelected();
    }

    public boolean isDaysSelected() {
        return this.unitsTypeSelector.isDaysSelected();
    }
}

