/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.views.syslog.TimeSpanButtonSelectionListener;
import com.metamatrix.console.ui.views.syslog.TimeSpanStartingOrEndingPanel;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Date;
import javax.swing.event.DocumentListener;

public class TimeSpanStartingPanel
extends TimeSpanStartingOrEndingPanel {
    private TextFieldWidget startTimeTextField;

    public TimeSpanStartingPanel(TimeSpanButtonSelectionListener buttonSelectionListener, DocumentListener numUnitsListener, Date systemStartTime) {
        super(buttonSelectionListener, numUnitsListener, systemStartTime, "Starting", "before specified end time", 3);
        this.init(systemStartTime);
    }

    private void init(Date systemStartTime) {
        LabelWidget startTimeLabel = new LabelWidget("At system start time:");
        this.firstRowPanel.add(startTimeLabel);
        this.firstRowLayout.setConstraints(startTimeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.startTimeTextField = new TextFieldWidget(17);
        this.startTimeTextField.setEditable(false);
        this.startTimeTextField.setText(this.formatDate(systemStartTime));
        this.startTimeTextField.setMinimumSize(this.startTimeTextField.getPreferredSize());
        this.firstRowPanel.add(this.startTimeTextField);
        this.firstRowLayout.setConstraints(this.startTimeTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.secondItemCalendarPanel.setDate(systemStartTime);
    }

    public void resetStartTime(Date systemStartTime) {
        this.startTimeTextField.setText(this.formatDate(systemStartTime));
    }

    @Override
    protected void buttonPressed() {
        super.buttonPressed();
        if (this.startTimeTextField != null) {
            if (this.secondItemRadioButton.isSelected() || this.thirdItemRadioButton.isSelected()) {
                this.startTimeTextField.setEnabled(false);
            } else if (this.firstItemRadioButton.isSelected()) {
                this.startTimeTextField.setEnabled(true);
            }
        }
    }
}

