/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.syslog;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

class ValueWarningDialog
extends JDialog {
    private static final String WARNING_TEXT = "In the future, do not show this warning";
    private boolean okPressed = false;
    private ButtonWidget okButton;
    private ButtonWidget cancelButton;
    private CheckBox warningCheckBox;

    public ValueWarningDialog(int value) {
        super(ConsoleMainFrame.getInstance());
        String title = "Change Maximum Rows to " + value;
        this.setTitle(title);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
            }
        });
        this.initialize(value);
    }

    private void initialize(int value) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        JPanel textPanel = new JPanel();
        GridBagLayout textPanelLayout = new GridBagLayout();
        textPanel.setLayout(textPanelLayout);
        LabelWidget line1 = new LabelWidget("Are you sure?  Accepting a large number of result rows");
        LabelWidget line2 = new LabelWidget("may degrade Console performance.");
        textPanel.add(line1);
        textPanel.add(line2);
        textPanelLayout.setConstraints(line1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        textPanelLayout.setConstraints(line2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(textPanel);
        this.okButton = new ButtonWidget("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ValueWarningDialog.this.okPressed();
            }
        });
        this.cancelButton = new ButtonWidget("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ValueWarningDialog.this.cancelPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 20, 0));
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getContentPane().add(buttonsPanel);
        this.warningCheckBox = new CheckBox(WARNING_TEXT);
        this.getContentPane().add(this.warningCheckBox);
        layout.setConstraints(textPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        layout.setConstraints(this.warningCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 4, 4, 10), 0, 0));
        this.pack();
        int height = this.getSize().height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int newHeight = Math.max(height, (int)((double)screenHeight * 0.2));
        this.setSize(new Dimension(this.getSize().width, newHeight));
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void okPressed() {
        this.okPressed = true;
        this.dispose();
    }

    private void cancelPressed() {
        this.dispose();
    }

    public boolean wasOKPressed() {
        return this.okPressed;
    }

    public boolean suppressWarningChecked() {
        return this.warningCheckBox.isSelected();
    }
}

