/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.transactions;

import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransactionTableModel
extends DefaultTableModel {
    public static final int NUM_COLUMNS = 9;
    public static final int TRANSACTION_ID_COL = 0;
    public static final int SESSION_ID_COL = 1;
    public static final int STATUS_COL = 2;
    public static final int START_TIME_COL = 3;
    public static final int END_TIME_COL = 4;
    public static final int CONNECTOR_ID_COL = 5;
    public static final int PROCESSOR_ID_COL = 6;
    public static final int DATABASE_COL = 7;
    public static final int REQUEST_ID_COL = 8;
    public static final String TRANSACTION_ID_HDR = "Transaction ID";
    public static final String SESSION_ID_HDR = "Session ID";
    public static final String STATUS_HDR = "Status";
    public static final String START_TIME_HDR = "Start Time";
    public static final String END_TIME_HDR = "End Time";
    public static final String CONNECTOR_ID_HDR = "Connector ID";
    public static final String PROCESSOR_ID_HDR = "Processor ID";
    public static final String DATABASE_HDR = "Model";
    public static final String REQUEST_ID_HDR = "Request ID";
    private Map transMap;
    private String[] colHdrs = new String[9];

    public TransactionTableModel() {
        this.colHdrs[0] = TRANSACTION_ID_HDR;
        this.colHdrs[1] = SESSION_ID_HDR;
        this.colHdrs[2] = STATUS_HDR;
        this.colHdrs[3] = START_TIME_HDR;
        this.colHdrs[4] = END_TIME_HDR;
        this.colHdrs[5] = CONNECTOR_ID_HDR;
        this.colHdrs[6] = PROCESSOR_ID_HDR;
        this.colHdrs[7] = DATABASE_HDR;
        this.colHdrs[8] = REQUEST_ID_HDR;
        super.setColumnIdentifiers(this.colHdrs);
        super.setNumRows(0);
    }

    public Class getColumnClass(int columnIndex) {
        Class cls = columnIndex == 1 || columnIndex == 6 || columnIndex == 8 || columnIndex == 0 ? Long.class : (columnIndex == 3 || columnIndex == 4 ? Date.class : String.class);
        return cls;
    }

    public void resetFromTransactionsList(Collection tx) {
        this.transMap = new HashMap();
        int numRows = tx.size();
        String NA = "N/A";
        SimpleDateFormat formatter = StaticUtilities.getDefaultDateFormat();
        Object[][] data = new Object[numRows][9];
        Iterator it = tx.iterator();
        int row = 0;
        while (it.hasNext()) {
            data[row][0] = 0L;
            this.transMap.put(data[row][0], NA);
            data[row][1] = NA;
            data[row][2] = NA;
            Date beginTime = new Date();
            data[row][3] = beginTime == null ? null : formatter.format(new Date(beginTime.getTime()));
            Date endTime = new Date();
            data[row][4] = endTime == null ? null : formatter.format(new Date(endTime.getTime()));
            data[row][5] = null;
            data[row][6] = null;
            data[row][7] = NA;
            data[row][8] = new Long(0L);
            ++row;
        }
        this.setNumRows(0);
        this.setDataVector(data, this.colHdrs);
    }

    public TransactionID transactionIDForTransactionNum(Long transactionNum) {
        TransactionID id = null;
        if (this.transMap != null) {
            id = (TransactionID)this.transMap.get(transactionNum);
        }
        return id;
    }
}

