/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.transactions;

import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelChangedEvent;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.TransactionManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.views.transactions.TerminateAction;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.server.admin.api.TransactionAdminAPI;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableColumnModel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class TransactionsPanel
extends BasePanel
implements ManagerListener,
WorkspacePanel,
AutoRefreshable {
    private TransactionManager manager;
    private TableWidget table;
    private ConnectionInfo connection;
    private boolean canTerminateTransactions;
    private boolean isStopped = true;
    private AutoRefresher arRefresher = null;

    public TransactionsPanel(TransactionManager mgr, boolean canTerminate, ConnectionInfo conn) {
        this.manager = mgr;
        this.manager.addManagerListener(this);
        this.canTerminateTransactions = canTerminate;
        this.connection = conn;
        this.init();
    }

    private void init() {
        this.table = new TableWidget((TableModel)this.manager.getTableModel(), true);
        this.table.setRowSelectionAllowed(true);
        this.table.setEditable(false);
        this.table.setColumnSelectionAllowed(false);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JScrollPane jsp = new JScrollPane(this.table);
        this.add(jsp);
        layout.setConstraints(jsp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (this.canTerminateTransactions) {
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent ev) {
                    TransactionsPanel.this.checkMouseClick(ev);
                }
            });
        }
        this.arRefresher = new AutoRefresher(this, 15, false, this.connection);
        this.arRefresher.init();
        this.arRefresher.startTimer();
    }

    private void checkMouseClick(MouseEvent ev) {
        int clickRow;
        int row;
        int[] selectedRows;
        if (ev.isPopupTrigger() && (selectedRows = this.table.getSelectedRows()).length == 1 && (row = selectedRows[0]) == (clickRow = this.table.rowAtPoint(ev.getPoint()))) {
            Long transactionNum = (Long)this.table.getModel().getValueAt(row, 0);
            JPopupMenu popupMenu = new JPopupMenu();
            TerminateAction terminateAction = new TerminateAction(transactionNum, this);
            popupMenu.add(terminateAction);
            popupMenu.show(this.table, ev.getX() + 10, ev.getY());
        }
    }

    public void start() {
        this.isStopped = false;
        this.manager.refresh();
    }

    public void stop() {
        this.isStopped = true;
    }

    @Override
    public List resume() {
        AbstractPanelAction refreshAction = new AbstractPanelAction(0){

            @Override
            public void actionImpl(ActionEvent e) {
                TransactionsPanel.this.refresh();
            }
        };
        refreshAction.putValue("Name", "Refresh");
        MenuEntry menuEntry = new MenuEntry("view.refresh", refreshAction);
        ArrayList<MenuEntry> menuList = new ArrayList<MenuEntry>(1);
        menuList.add(menuEntry);
        ConsoleMenuBar.getInstance().addActionsFromMenuEntryObjects(menuList);
        return null;
    }

    @Override
    public String getTitle() {
        return "Transactions";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public void refresh() {
        this.manager.refresh();
        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)this.table.getColumnModel();
        columnModel.setColumnsNotSorted();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            columnModel.moveColumn(i, i);
            columnModel.setColumnHidden(columnModel.getColumn(i), false);
        }
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    public boolean isRefreshable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelChanged(ModelChangedEvent e) {
        if (!this.isStopped) {
            try {
                StaticUtilities.startWait(this);
                this.manager.refresh();
            }
            catch (Exception ex) {
                ExceptionUtility.showMessage("Update Transactions Table", ex);
            }
            finally {
                StaticUtilities.endWait(this);
            }
        }
    }

    public void doTermination(Long transactionNum) {
        try {
            TransactionAdminAPI api = ModelManager.getTransactionAPI(this.connection);
            api.terminateTransaction(this.manager.transactionIDForTransactionNum(transactionNum));
        }
        catch (XATransactionException ex) {
            StaticUtilities.displayModalDialogWithOK("Not Terminated", "Transaction " + transactionNum + " was not terminated.  The transaction may have already " + "completed.");
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Terminate Transaction", e);
        }
    }

    @Override
    public String getName() {
        return "data.transaction";
    }

    @Override
    public void setAutoRefreshEnabled(boolean b) {
        this.arRefresher.setAutoRefreshEnabled(b);
    }

    @Override
    public void setRefreshRate(int iRate) {
        this.arRefresher.setRefreshRate(iRate);
    }

    @Override
    public void setAutoRefresher(AutoRefresher ar) {
        this.arRefresher = ar;
    }

    @Override
    public AutoRefresher getAutoRefresher() {
        return this.arRefresher;
    }
}

