/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AddDialog
extends JDialog {
    private CheckBox[] items;
    private ButtonWidget okButton = new ButtonWidget("OK");
    private ButtonWidget cancelButton = new ButtonWidget("Cancel");

    public AddDialog(String title, String[] names) {
        super((Frame)ViewManager.getMainFrame(), title);
        this.init(names);
        this.okButton.setName("AddDialog.okButton");
        this.cancelButton.setName("AddDialog.cancelButton");
    }

    private void init(String[] names) {
        this.setModal(true);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddDialog.this.okPressed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddDialog.this.cancelPressed();
            }
        });
        this.items = new CheckBox[names.length];
        this.getRootPane().setDefaultButton(this.okButton);
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new CheckBox(names[i]);
            this.items[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    AddDialog.this.stateChanged();
                }
            });
        }
        int maxItem = this.maxCheckBoxItemLength();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int preferredWidth = Math.max(300, maxItem * 6 + 160);
        int preferredHeight = 30 * this.items.length + 160;
        this.setSize(new Dimension(Math.min(preferredWidth, (int)((double)screenSize.width * 0.75)), Math.min(preferredHeight, (int)((double)screenSize.height * 0.75))));
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridLayout(this.items.length, 1));
        for (int i = 0; i < this.items.length; ++i) {
            JPanel listItemPanel = new JPanel();
            GridBagLayout ll = new GridBagLayout();
            listItemPanel.setLayout(ll);
            listItemPanel.add(this.items[i]);
            ll.setConstraints(this.items[i], new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            listPanel.add(listItemPanel);
        }
        JScrollPane listJSP = new JScrollPane(listPanel);
        this.getContentPane().add(listJSP);
        layout.setConstraints(listJSP, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel();
        GridBagLayout bl = new GridBagLayout();
        buttonPanel.setLayout(bl);
        JPanel innerButtonPanel = new JPanel();
        innerButtonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        innerButtonPanel.add(this.okButton);
        innerButtonPanel.add(this.cancelButton);
        buttonPanel.add(innerButtonPanel);
        bl.setConstraints(innerButtonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(buttonPanel);
        layout.setConstraints(buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.setEnabled(false);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private int maxCheckBoxItemLength() {
        int max = 0;
        for (int i = 0; i < this.items.length; ++i) {
            int len = this.items[i].getText().length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private void stateChanged() {
        this.okButton.setEnabled(this.anyItemChecked());
    }

    private boolean anyItemChecked() {
        boolean checked = false;
        int i = 0;
        while (i < this.items.length && !checked) {
            if (this.items[i].isSelected()) {
                checked = true;
                continue;
            }
            ++i;
        }
        return checked;
    }

    private void cancelPressed() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setSelected(false);
        }
        this.dispose();
    }

    private void okPressed() {
        this.dispose();
    }

    public Collection getCheckedItems() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].isSelected()) continue;
            list.add(this.items[i].getText());
        }
        return list;
    }
}

