/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.users.GroupsTabMainPanel;
import com.metamatrix.console.ui.views.users.NotifyOnSelectionChange;
import com.metamatrix.console.ui.views.users.RoleDetail;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.ui.views.users.RolesList;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.toolbox.ui.widget.ListWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GroupTabSelectionHandler
implements NotifyOnSelectionChange {
    public static final boolean SHOW_USERS_ON_GROUPS_TREE = true;
    public static final String TOP_OF_METAMATRIX_BRANCH_INDICATOR = "THE TOP OF METAMATRIX BRANCH";
    private GroupsManager manager;
    private RolesList rolesList;
    private JPanel rightPanel;
    private boolean canEditPrincipalInfo;
    private boolean canEditRoleInfo;
    private boolean showingGroupsTree;
    private RepaintController repaintController;
    private JPopupMenu popupMenu = new JPopupMenu();
    private Action createGroupAction = null;
    private Action[] currentActions = null;
    private RoleDetail currentRoleDetail;
    public static String SIGNED_ON_USERNAME = "";

    public GroupTabSelectionHandler(GroupsManager mgr, GroupsTabMainPanel mainPnl, RolesList rl, JPanel rPanel, boolean viewsPrincipals, boolean modifiesPrincipals, boolean viewsRoles, boolean modifiesRoles, RepaintController rc) {
        this.manager = mgr;
        this.rolesList = rl;
        this.rightPanel = rPanel;
        if (this.rightPanel == null) {
            this.rightPanel = new JPanel();
        }
        this.canEditPrincipalInfo = modifiesPrincipals;
        this.canEditRoleInfo = modifiesRoles;
        this.repaintController = rc;
        this.setCommandsMenuToCreate();
        this.popupMenu.setName("UserTabSelectionHandler.popupMenu");
    }

    public void setRolesList(RolesList rl) {
        this.rolesList = rl;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public void principalCreated(MetaMatrixPrincipal principal) {
    }

    @Override
    public void selectionChanged(Component component, Object selectionObject) {
        this.removeSelections(component);
        ListWidget list = (ListWidget)selectionObject;
        int selectedIndex = list.getSelectedIndex();
        if (selectedIndex >= 0) {
            String role = list.getModel().getElementAt(selectedIndex).toString();
            this.displaySelectedRole(role);
        }
        this.setCommandsMenuToCreate();
    }

    public void setProperty(MetaMatrixPrincipal principal, String propertyName, String value) {
        Properties changedProperties = new Properties();
        changedProperties.setProperty(propertyName, value);
    }

    private List formCreateActions() {
        ArrayList<Action> act = new ArrayList<Action>();
        if (this.showingGroupsTree) {
            act.add(this.createGroupAction);
        }
        return act;
    }

    private void setCommandsMenuToCreate() {
        if (this.canEditPrincipalInfo) {
            List act = this.formCreateActions();
            Action[] actions = new Action[act.size()];
            Iterator it = act.iterator();
            int i = 0;
            while (it.hasNext()) {
                actions[i] = (Action)it.next();
                ++i;
            }
            ConsoleMenuBar.getInstance().setActions(actions);
            this.currentActions = actions;
        }
    }

    public ConnectionInfo getConnection() {
        return this.manager.getConnection();
    }

    public Action[] getCurrentActions() {
        if (this.currentActions == null) {
            return new Action[0];
        }
        return this.currentActions;
    }

    public List getCurrentActionsAsList() {
        if (this.currentActions == null) {
            return new ArrayList(1);
        }
        return Arrays.asList(this.currentActions);
    }

    private void removeSelections(Component comp) {
        if (comp != this.rolesList && this.rolesList != null) {
            this.rolesList.setIgnoreValueChange(true);
            this.rolesList.removeSelectionInterval(0, this.rolesList.getModel().getSize() - 1);
            this.rolesList.setIgnoreValueChange(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySelectedRole(String displayName) {
        try {
            RoleDetail rd;
            StaticUtilities.startWait(this.rightPanel);
            Map tempRoles = this.manager.getRoles();
            Iterator it = tempRoles.entrySet().iterator();
            String roleName = null;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                RoleDisplay disp = (RoleDisplay)entry.getValue();
                if (disp.getDisplayName().indexOf(displayName) < 0) continue;
                roleName = disp.getName();
            }
            if (this.currentRoleDetail != null) {
                this.currentRoleDetail.deregister();
            }
            RoleDisplay rDisp = this.manager.getRoleDisplay(roleName);
            this.currentRoleDetail = rd = new RoleDetail(rDisp, this.manager, !this.canEditRoleInfo, this.repaintController, this.getConnection());
            this.setRightPanel(rd);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Create Role Detail", e);
        }
        finally {
            StaticUtilities.endWait(this.rightPanel);
        }
    }

    private void setRightPanel(JPanel component) {
        this.rightPanel.removeAll();
        GridBagLayout layout = new GridBagLayout();
        this.rightPanel.setLayout(layout);
        this.rightPanel.add(component);
        layout.setConstraints(component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

