/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.views.DefaultConsoleTableComparator;
import com.metamatrix.console.ui.views.authorization.ProvidersChangedEvent;
import com.metamatrix.console.ui.views.authorization.ProvidersChangedListener;
import com.metamatrix.console.ui.views.users.GroupAccumulatorController;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.PopupMenuFactory;
import com.metamatrix.toolbox.ui.widget.TableWidget;
import com.metamatrix.toolbox.ui.widget.table.DefaultTableModel;
import com.metamatrix.toolbox.ui.widget.table.EnhancedTableColumn;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class GroupsAccumulatorPanel
extends BasePanel
implements PopupMenuFactory,
ProvidersChangedListener {
    private static final String REMOVE_DLG_TITLE = ConsolePlugin.Util.getString("GroupsAccumulatorPanel.removeDialog.title");
    private static final String REMOVE_DLG_MSG = ConsolePlugin.Util.getString("GroupsAccumulatorPanel.removeDialog.msg");
    private JScrollPane groupsTablePane;
    private JPanel buttonsPanel;
    private ButtonWidget addButton;
    private ButtonWidget removeButton;
    private Object[] blockedItems;
    private GroupsTable groupsTable;
    private GroupsTableModel groupsTableModel;
    private GroupAccumulatorController groupController;
    private List initialGroups;
    private List currentGroups;
    private ListSelectionListener listener;

    public GroupsAccumulatorPanel(List initialGroups, GroupAccumulatorController gc) {
        this.initialGroups = initialGroups != null ? initialGroups : new ArrayList();
        this.currentGroups = initialGroups;
        this.groupController = gc;
        this.init();
    }

    @Override
    public void providersChanged(ProvidersChangedEvent event) {
        int type = event.getType();
        if (type == 1 || type == 4) {
            this.setButtonStates();
        }
    }

    private void init() {
        this.groupsTablePane = this.createGroupsTablePane();
        this.addButton = new ButtonWidget("Add ...");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GroupsAccumulatorPanel.this.addButtonPressed();
            }
        });
        this.removeButton = new ButtonWidget("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GroupsAccumulatorPanel.this.removeButtonPressed();
            }
        });
        this.layoutStuff();
        this.listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                GroupsAccumulatorPanel.this.tableRowSelectionChanged(ev);
            }
        };
        this.addSelectionListener();
        this.setButtonStates();
    }

    private void addSelectionListener() {
        this.groupsTable.getSelectionModel().addListSelectionListener(this.listener);
    }

    private void removeSelectionListener() {
        this.groupsTable.getSelectionModel().removeListSelectionListener(this.listener);
    }

    private void layoutStuff() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.groupsTablePane);
        layout.setConstraints(this.groupsTablePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonsPanel = new JPanel();
        this.add(this.buttonsPanel);
        this.buttonsPanel.setLayout(new GridLayout(1, 2, 0, 10));
        this.buttonsPanel.add(this.addButton);
        this.buttonsPanel.add(this.removeButton);
        layout.setConstraints(this.buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 3, 5, 3), 0, 0));
    }

    public Object[] getBlockedItems() {
        return this.blockedItems;
    }

    public void itemSelectionBlocked() {
    }

    private void addButtonPressed() {
        this.removeSelectionListener();
        Collection addedGroups = this.groupController.addPressed(this);
        if (addedGroups != null) {
            Iterator iter = addedGroups.iterator();
            while (iter.hasNext()) {
                this.groupsTableModel.addRow((MetaMatrixPrincipalName)iter.next());
            }
        }
        this.setButtonStates();
        this.addSelectionListener();
    }

    private void removeButtonPressed() {
        int nRows;
        boolean reallyRemove;
        this.removeSelectionListener();
        ArrayList removedGroups = new ArrayList();
        int selectedRowIndex = this.groupsTable.getSelectedRow();
        int modelRow = this.groupsTable.convertRowIndexToModel(selectedRowIndex);
        if (modelRow >= 0 && (reallyRemove = DialogUtility.yesNoDialog(ConsoleMainFrame.getInstance(), REMOVE_DLG_MSG, REMOVE_DLG_TITLE))) {
            removedGroups.add(this.currentGroups.remove(modelRow));
            boolean success = this.groupController.removeConfirmed(this, removedGroups);
            if (success) {
                this.groupsTableModel.removeRow(modelRow);
            }
        }
        if ((nRows = this.groupsTable.getRowCount()) > 0) {
            this.groupsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.setButtonStates();
        this.addSelectionListener();
    }

    private void setButtonStates() {
        int selectedModelRow;
        ConnectionInfo conn = this.groupController.getGroupsManager().getConnection();
        UserCapabilities cap = UserCapabilities.getInstance();
        boolean canModify = cap.canModifySecurity(conn);
        if (!canModify) {
            this.removeButton.setEnabled(canModify);
            this.addButton.setEnabled(canModify);
            return;
        }
        boolean enableRemove = false;
        if (this.groupsTableModel.getRowCount() > 0 && (selectedModelRow = this.groupsTable.getSelectionModel().getMinSelectionIndex()) >= 0) {
            enableRemove = true;
        }
        this.removeButton.setEnabled(enableRemove);
        boolean enableAdd = true;
        try {
            AuthenticationProviderManager authMgr = ModelManager.getAuthenticationProviderManager(conn);
            int providerCnt = authMgr.getAllProviders().size();
            enableAdd = providerCnt > 0;
        }
        catch (Exception err) {
            ExceptionUtility.showMessage("Error setting button states", err);
        }
        this.addButton.setEnabled(enableAdd);
    }

    @Override
    public JPopupMenu getPopupMenu(Component context) {
        return new JPopupMenu();
    }

    public void repopulateTable(List groups) {
        this.removeSelectionListener();
        this.initialGroups = groups;
        this.currentGroups = new ArrayList(this.initialGroups);
        this.groupsTableModel.init(this.initialGroups);
        this.groupsTable.setEditable(false);
        this.addSelectionListener();
    }

    private void tableRowSelectionChanged(ListSelectionEvent ev) {
        if (!ev.getValueIsAdjusting()) {
            this.setButtonStates();
        }
    }

    private JScrollPane createGroupsTablePane() {
        this.groupsTableModel = new GroupsTableModel(this.initialGroups);
        this.groupsTable = new GroupsTable(this.groupsTableModel);
        this.groupsTable.getSelectionModel().setSelectionMode(0);
        this.groupsTable.setEditable(false);
        JScrollPane groupsSP = new JScrollPane(this.groupsTable);
        return groupsSP;
    }

    public class GroupsTableModel
    extends DefaultTableModel {
        public static final int GROUP_COL_NUM = 0;
        public static final String GROUP_NAME = "Group Name";
        public static final int NUM_COLUMNS = 1;

        public GroupsTableModel(Collection rows) {
            super((Vector)new Vector<String>(Arrays.asList(GROUP_NAME)), 0);
            this.init(rows);
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        public void init(Collection rows) {
            int numRows = this.getRowCount();
            for (int i = numRows - 1; i >= 0; --i) {
                this.removeRow(i);
            }
            for (MetaMatrixPrincipalName group : rows) {
                this.addRow(group);
            }
        }

        public void addRow(MetaMatrixPrincipalName group) {
            Object[] rowData = new Object[]{group.getName()};
            this.addRow(rowData);
        }
    }

    class GroupsTable
    extends TableWidget {
        public GroupsTable(GroupsTableModel model) {
            super((TableModel)model, true);
            this.init();
        }

        private void init() {
            this.getSelectionModel().setSelectionMode(0);
            this.setEditable(false);
            this.setComparator(DefaultConsoleTableComparator.getInstance());
            this.getTableHeader().setReorderingAllowed(false);
            EnhancedTableColumn nameColumn = (EnhancedTableColumn)this.getColumn("Group Name");
            this.setColumnSortedAscending(nameColumn, false);
        }
    }
}

