/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.util.AbstractPanelAction;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.ui.views.users.GroupTabSelectionHandler;
import com.metamatrix.console.ui.views.users.RolesList;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.Splitter;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class GroupsTabMainPanel
extends BasePanel
implements RepaintController,
WorkspacePanel {
    private GroupsManager manager;
    private RolesList rolesList;
    private ButtonWidget addButton;
    private JPanel rightPanel = new JPanel();
    private GroupTabSelectionHandler selectionHandler;
    private boolean canViewPrincipalInfo;
    private boolean canModifyPrincipalInfo;
    private boolean canViewRoleInfo;
    private boolean canModifyRoleInfo;
    private JSplitPane overallSplitPane;
    private boolean hasBeenPainted = false;
    private boolean showingRolesList = true;
    private PanelAction actionRefresh;

    public GroupsTabMainPanel(GroupsManager mgr, boolean seesEnterprise, boolean viewsPrincipals, boolean modifiesPrincipals, boolean viewsRoles, boolean modifiesRoles) {
        this.manager = mgr;
        this.canViewRoleInfo = viewsRoles;
        this.canModifyRoleInfo = modifiesRoles;
        this.actionRefresh = new PanelAction(this, 0);
    }

    public void createComponent() throws Exception {
        this.selectionHandler = new GroupTabSelectionHandler(this.manager, this, null, this.rightPanel, this.canViewPrincipalInfo, this.canModifyPrincipalInfo, this.canViewRoleInfo, this.canModifyRoleInfo, this);
        if (this.canViewRoleInfo) {
            this.rolesList = new RolesList(this.manager, this.selectionHandler, this.showingRolesList);
            this.selectionHandler.setRolesList(this.rolesList);
        }
        this.doTheLayout();
    }

    public void refreshData() {
        if (this.rolesList != null) {
            this.rolesList.refreshData();
        }
    }

    @Override
    public List resume() {
        ArrayList<MenuEntry> actions = new ArrayList<MenuEntry>();
        actions.add(new MenuEntry("view.refresh", this.actionRefresh));
        List otherActions = this.selectionHandler.getCurrentActionsAsList();
        int size = otherActions.size();
        for (int i = 0; i < size; ++i) {
            actions.add(new MenuEntry("action", (Action)otherActions.get(i)));
        }
        return actions;
    }

    @Override
    public void receiveUpdateNotification(RuntimeUpdateNotification notification) {
    }

    public boolean isShowingRolesList() {
        return this.showingRolesList;
    }

    public void setAddUser(boolean enableAddUser) {
        if (this.addButton != null) {
            this.addButton.setEnabled(enableAddUser);
        }
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public ConnectionInfo getConnection() {
        return this.manager.getConnection();
    }

    public RolesList getRolesList() {
        return this.rolesList;
    }

    private void doTheLayout() {
        JPanel rolesPanel = new JPanel();
        if (this.canViewRoleInfo) {
            GridBagLayout rl = new GridBagLayout();
            rolesPanel.setLayout(rl);
            JScrollPane rolesScrollPane = new JScrollPane(this.rolesList);
            rolesPanel.add(rolesScrollPane);
            rl.setConstraints(rolesScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.overallSplitPane = new Splitter(1, true, rolesPanel, this.rightPanel);
        this.overallSplitPane.setDividerLocation(0.28);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.overallSplitPane);
        layout.setConstraints(this.overallSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.hasBeenPainted) {
            this.overallSplitPane.invalidate();
            this.jiggleVerticalSplitter();
            this.overallSplitPane.setDividerLocation(0.28);
            this.hasBeenPainted = true;
            super.paint(g);
        }
    }

    @Override
    public void repaintNeeded() {
        this.jiggleVerticalSplitter();
    }

    private void jiggleVerticalSplitter() {
        if (this.overallSplitPane != null) {
            int splitterLoc = this.overallSplitPane.getDividerLocation();
            int increment = -1;
            if (splitterLoc == 0) {
                increment = 1;
            }
            this.overallSplitPane.setDividerLocation(splitterLoc + increment);
            this.overallSplitPane.setDividerLocation(splitterLoc);
        }
    }

    private void refreshImpl() throws ExternalException {
        if (this.showingRolesList) {
            this.rolesList.refreshData();
        }
    }

    private class PanelAction
    extends AbstractPanelAction {
        public static final int REFRESH = 0;

        public PanelAction(GroupsTabMainPanel caller, int theType) {
            String desc;
            super(theType);
            if (theType == 0) {
                desc = "";
                if (caller.isShowingRolesList()) {
                    desc = "Refreshes roles data.";
                }
            } else {
                throw new IllegalArgumentException("Invalid action type <" + theType + ">.");
            }
            this.putValue("ShortDescription", desc);
            this.putValue("menu.item.name", "Refresh");
            PropertyProvider pp = new PropertyProvider("com/metamatrix/console/ui/data/common_ui");
            this.putValue("SmallIcon", pp.getIcon("icon.refresh"));
        }

        @Override
        public void actionImpl(ActionEvent theEvent) throws ExternalException {
            if (this.type == 0) {
                GroupsTabMainPanel.this.refreshImpl();
            }
        }

        @Override
        protected void handleError(Exception theException) {
            if (this.type == 0) {
                String emsg = "Error refreshing group data.";
                ExceptionUtility.showMessage(emsg, theException.getMessage(), theException);
                LogManager.logError((String)"USERS", (Throwable)theException, (String)this.paramString());
            } else {
                super.handleError(theException);
            }
        }
    }
}

