/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.users.NewGroupsWizardSelectionPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JDialog;

public class NewGroupsWizardController
extends WizardInterfaceImpl {
    private static final int CONNECTOR_SELECT_PAGE_NUM = 0;
    private NewGroupsWizardSelectionPanel groupsSelectionPanel;
    private JDialog dialog;
    private int currentPage = -1;
    private ButtonWidget cancelButton;
    private ButtonWidget finishButton;
    private List selectedGroups = new ArrayList();
    private GroupsManager groupsManager;

    public NewGroupsWizardController(GroupsManager manager) {
        this.groupsManager = manager;
    }

    private GroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    public List runWizard(Collection listToRemoveFromAvailable) {
        this.groupsSelectionPanel = new NewGroupsWizardSelectionPanel(this, this.getGroupsManager(), listToRemoveFromAvailable);
        if (this.groupsSelectionPanel != null) {
            this.addPage(this.groupsSelectionPanel);
            this.dialog = new JDialog((Frame)ConsoleMainFrame.getInstance(), "Select Groups");
            this.dialog.setModal(true);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int preferredWidth = (int)((double)screenSize.width * 0.25);
            int preferredHeight = (int)((double)screenSize.width * 0.25);
            this.setSize(new Dimension(preferredWidth, preferredHeight));
            this.cancelButton = this.getCancelButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    NewGroupsWizardController.this.cancelPressed();
                }
            });
            this.getBackButton();
            this.finishButton = this.getFinishButton();
            this.finishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    NewGroupsWizardController.this.finishPressed();
                }
            });
            this.getNextButton();
            this.dialog.getContentPane().add(this);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    NewGroupsWizardController.this.cancelPressed();
                }
            });
            this.dialog.pack();
            this.currentPage = 0;
            NewGroupsWizardController.setLocationOn(this.dialog);
            this.dialog.show();
        }
        return this.selectedGroups;
    }

    private void cancelPressed() {
        this.selectedGroups.clear();
        this.dialog.dispose();
    }

    private void finishPressed() {
        this.selectedGroups = this.groupsSelectionPanel.getSelectedGroups();
        this.dialog.dispose();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showNextPage() {
        boolean bContinue = false;
        try {
            StaticUtilities.startWait(this.getDialog().getContentPane());
            bContinue = this.goingToNextPage();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed testing new connector binding name for uniqueness", e);
        }
        finally {
            StaticUtilities.endWait(this.getDialog().getContentPane());
        }
        if (bContinue) {
            ++this.currentPage;
            super.showNextPage();
        }
    }

    @Override
    public void showPreviousPage() {
        this.goingToPreviousPage();
        --this.currentPage;
        super.showPreviousPage();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension unadjusted = super.getPreferredSize();
        return new Dimension(Math.max(unadjusted.width, (int)((double)screenSize.width * 0.6)), Math.max(unadjusted.height, (int)((double)screenSize.height * 0.6)));
    }

    public boolean goingToNextPage() {
        boolean bContinue = true;
        switch (this.currentPage) {
            default: 
        }
        return bContinue;
    }

    public void goingToPreviousPage() {
        this.enableNextButton(true);
    }

    public static void setLocationOn(Component comp) {
        Point p = StaticUtilities.centerFrame(comp.getSize());
        comp.setLocation(p.x, p.y);
    }

    public void enableNextButton(boolean b) {
        ButtonWidget btnNext = null;
        btnNext = this.getNextButton();
        if (btnNext != null) {
            btnNext.setEnabled(b);
        } else {
            btnNext = this.getFinishButton();
            if (btnNext != null) {
                btnNext.setEnabled(b);
            }
        }
    }
}

