/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.NoMinTextFieldWidget;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.property.TypeConstants;
import com.metamatrix.console.ui.views.users.GroupsAccumulatorListener;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.AccumulatorPanel;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.util.StringFilter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class NewGroupsWizardSelectionPanel
extends BasicWizardSubpanelContainer
implements TypeConstants,
GroupsAccumulatorListener {
    private JPanel pnlOuter = new JPanel();
    private JComboBox cbxDomainSelection;
    private DefaultComboBoxModel cbxmdlDomainSelectionModel;
    private GroupsAccPanel groupsAccumulator;
    private boolean hasBeenPainted = false;
    private GroupsManager groupsManager;
    private TextFieldWidget txtFieldGroupFilter;
    private ButtonWidget retrieveGroupsButton;
    private List currentDomainGroups = new ArrayList();
    private List selectedGroups = new ArrayList();
    private Collection listToRemoveFromAvailable;

    public NewGroupsWizardSelectionPanel(WizardInterface wizardInterface, GroupsManager manager, Collection removeList) {
        super(wizardInterface);
        this.groupsManager = manager;
        this.initExistingGroupsList(removeList);
        this.init();
    }

    private void init() {
        LabelWidget lblDomainName = new LabelWidget("Domain :");
        this.setBoldFont(lblDomainName);
        JComboBox domainComboBox = this.getComboBox();
        this.retrieveGroupsButton = new ButtonWidget("Fetch");
        this.retrieveGroupsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewGroupsWizardSelectionPanel.this.retrieveDomainGroups();
            }
        });
        JPanel filterPanel = this.getFilterPanel();
        this.groupsAccumulator = new GroupsAccPanel(new ArrayList(), new ArrayList(), this);
        GridBagLayout layout = new GridBagLayout();
        this.pnlOuter.setLayout(layout);
        this.pnlOuter.add(lblDomainName);
        this.pnlOuter.add(domainComboBox);
        this.pnlOuter.add(this.retrieveGroupsButton);
        this.pnlOuter.add(filterPanel);
        this.pnlOuter.add(this.groupsAccumulator);
        layout.setConstraints(lblDomainName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(domainComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.retrieveGroupsButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(filterPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.groupsAccumulator, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(15, 5, 5, 5), 0, 0));
        this.setMainContent(this.pnlOuter);
        this.setStepText(1, "Select the Groups from the available provider domains");
        this.populateComboBox();
        domainComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                NewGroupsWizardSelectionPanel.this.domainComboBoxSelectionChanged();
            }
        });
        this.txtFieldGroupFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                NewGroupsWizardSelectionPanel.this.handleFilterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                NewGroupsWizardSelectionPanel.this.handleFilterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                NewGroupsWizardSelectionPanel.this.handleFilterChanged();
            }
        });
    }

    private void initExistingGroupsList(Collection existingPrincipalNames) {
        this.listToRemoveFromAvailable = new ArrayList();
        if (existingPrincipalNames != null) {
            for (MetaMatrixPrincipalName principalName : existingPrincipalNames) {
                this.listToRemoveFromAvailable.add(principalName.getName());
            }
        }
    }

    private GroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    private JComboBox getComboBox() {
        if (this.cbxDomainSelection == null) {
            this.cbxDomainSelection = new JComboBox();
            this.cbxmdlDomainSelectionModel = new DefaultComboBoxModel();
            this.cbxDomainSelection.setModel(this.cbxmdlDomainSelectionModel);
        }
        return this.cbxDomainSelection;
    }

    private void populateComboBox() {
        List allDomains = null;
        try {
            allDomains = this.getGroupsManager().getDomainNames();
        }
        catch (AuthorizationException e) {
            e.printStackTrace();
        }
        catch (ComponentNotFoundException e) {
            e.printStackTrace();
        }
        catch (ExternalException e) {
            e.printStackTrace();
        }
        if (allDomains != null) {
            for (String domainName : allDomains) {
                this.cbxmdlDomainSelectionModel.addElement(domainName);
            }
            if (!allDomains.isEmpty()) {
                this.cbxDomainSelection.setSelectedIndex(0);
                this.domainComboBoxSelectionChanged();
            }
        }
    }

    private void domainComboBoxSelectionChanged() {
        this.retrieveGroupsButton.setEnabled(true);
        this.groupsAccumulator.setAvailableValues(new ArrayList());
        this.groupsAccumulator.resetValues();
    }

    private void retrieveDomainGroups() {
        String selectedDomain = (String)this.cbxDomainSelection.getSelectedItem();
        Collection allDomainGroups = this.getGroupsManager().getGroupsForDomain(selectedDomain);
        this.currentDomainGroups = new ArrayList(allDomainGroups.size());
        Iterator iter = allDomainGroups.iterator();
        while (iter.hasNext()) {
            String currentGroup = (String)iter.next() + "@" + selectedDomain;
            if (this.listToRemoveFromAvailable == null || this.listToRemoveFromAvailable.contains(currentGroup)) continue;
            this.currentDomainGroups.add(currentGroup);
        }
        this.groupsAccumulator.setAvailableValues(this.getFilteredDomainGroups());
        this.retrieveGroupsButton.setEnabled(false);
    }

    private JPanel getFilterPanel() {
        JPanel filterPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        filterPanel.setLayout(layout);
        LabelWidget lblFilter = new LabelWidget("Groups Filter :");
        this.setBoldFont(lblFilter);
        this.txtFieldGroupFilter = new NoMinTextFieldWidget(20);
        this.txtFieldGroupFilter.setText("*");
        filterPanel.add(lblFilter);
        filterPanel.add(this.txtFieldGroupFilter);
        layout.setConstraints(lblFilter, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        layout.setConstraints(this.txtFieldGroupFilter, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        return filterPanel;
    }

    private void handleFilterChanged() {
        this.groupsAccumulator.setAvailableValues(this.getFilteredDomainGroups());
    }

    private List getFilteredDomainGroups() {
        String filterText = this.txtFieldGroupFilter.getText();
        if (filterText == null || filterText.length() == 0) {
            filterText = "*";
        }
        StringFilter filter = new StringFilter(filterText, true);
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String group : this.currentDomainGroups) {
            if (group == null || !filter.includes(group)) continue;
            filteredList.add(group);
        }
        return filteredList;
    }

    @Override
    public void selectedGroupsChanged() {
        this.selectedGroups = this.groupsAccumulator.getValues();
        if (!this.selectedGroups.isEmpty()) {
            this.enableForwardButton(true);
        } else {
            this.enableForwardButton(false);
        }
    }

    public List getSelectedGroups() {
        ArrayList<MetaMatrixPrincipalName> mmPrincipalNames = new ArrayList<MetaMatrixPrincipalName>(this.selectedGroups.size());
        for (String name : this.selectedGroups) {
            MetaMatrixPrincipalName mmName = new MetaMatrixPrincipalName(name, 1);
            mmPrincipalNames.add(mmName);
        }
        return mmPrincipalNames;
    }

    private void setBoldFont(LabelWidget label) {
        Font tempFont = label.getFont();
        Font newFont = new Font(tempFont.getName(), 1, tempFont.getSize());
        label.setFont(newFont);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.hasBeenPainted) {
            AbstractButton forwardButton = this.getWizardInterface().getForwardButton();
            forwardButton.setEnabled(false);
            this.hasBeenPainted = true;
        }
        super.paint(g);
    }

    public class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String itemName = (String)value;
            return super.getListCellRendererComponent((JList<?>)list, itemName, index, isSelected, cellHasFocus);
        }
    }

    class GroupsAccPanel
    extends AccumulatorPanel {
        private GroupsAccumulatorListener listener;

        public GroupsAccPanel(List initialAvailableContexts, List initialSelectedContexts, GroupsAccumulatorListener lsnr) {
            super(initialAvailableContexts, initialSelectedContexts);
            this.listener = lsnr;
            this.setAllowsReorderingValues(false);
            this.getAcceptButton().setVisible(false);
            this.getCancelButton().setVisible(false);
            this.getResetButton().setVisible(false);
            this.remove(this.getNavigationBar());
            this.getAvailableValuesHeader().setText("Available Groups");
            this.getValuesHeader().setText("Selected Groups");
            this.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent ev) {
                    GroupsAccPanel.this.selectionsChanged();
                }

                @Override
                public void intervalRemoved(ListDataEvent ev) {
                    GroupsAccPanel.this.selectionsChanged();
                }

                @Override
                public void contentsChanged(ListDataEvent ev) {
                    GroupsAccPanel.this.selectionsChanged();
                }
            });
            GroupListCellRenderer cellRenderer = new GroupListCellRenderer();
            this.setSelectionListCellRenderer(cellRenderer);
            this.setAvailableListCellRenderer(cellRenderer);
        }

        public void selectionsChanged() {
            this.listener.selectedGroupsChanged();
        }
    }
}

