/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.util.ConsoleCellRenderer;
import com.metamatrix.console.ui.util.IconLabel;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.ui.views.users.RoleMembershipPanel;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RoleDetail
extends BasePanel {
    private RoleDisplay roleDisplay;
    private GroupsManager manager;
    private RoleMembershipPanel rolePanel;
    private RepaintController repaintController;

    public RoleDetail(RoleDisplay rd, GroupsManager mgr, boolean rOnly, RepaintController rc, ConnectionInfo conn) throws Exception {
        this.roleDisplay = rd;
        this.manager = mgr;
        this.repaintController = rc;
        this.init();
        this.repaintController.repaintNeeded();
    }

    public void deregister() {
        if (this.rolePanel != null) {
            this.rolePanel.deregister();
        }
    }

    private void init() throws Exception {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        String headerText = "Role: " + this.roleDisplay.getDisplayName();
        IconLabel header = new IconLabel(ConsoleCellRenderer.ROLE_ICON, headerText);
        this.add(header);
        layout.setConstraints(header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JTextArea descriptionArea = new JTextArea();
        descriptionArea.setColumns(30);
        descriptionArea.setRows(4);
        descriptionArea.setPreferredSize(new Dimension(150, 68));
        descriptionArea.setLineWrap(true);
        descriptionArea.setText(this.roleDisplay.getDescription());
        descriptionArea.setBorder(new TitledBorder(""));
        descriptionArea.setBackground(new JPanel().getBackground());
        JScrollPane descriptionJSP = new JScrollPane(descriptionArea);
        this.add(descriptionJSP);
        layout.setConstraints(descriptionJSP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.2, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.rolePanel = new RoleMembershipPanel(this.roleDisplay, this.manager);
        this.add(this.rolePanel);
        layout.setConstraints(this.rolePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.8, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }
}

