/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.views.users.GroupAccumulatorController;
import com.metamatrix.console.ui.views.users.GroupsAccumulatorPanel;
import com.metamatrix.console.ui.views.users.NewGroupsWizardController;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public class RoleMembershipPanel
extends JPanel
implements GroupAccumulatorController {
    private GroupsAccumulatorPanel groupAccumulatorPanel;
    private GroupsManager groupsManager;
    private RoleDisplay roleDisplay;

    public RoleMembershipPanel(RoleDisplay rd, GroupsManager gMgr) {
        this.groupsManager = gMgr;
        this.roleDisplay = rd;
        this.groupAccumulatorPanel = new GroupsAccumulatorPanel(new ArrayList(), this);
        AuthenticationProviderManager authMgr = ModelManager.getAuthenticationProviderManager(gMgr.getConnection());
        if (authMgr != null) {
            authMgr.addProvidersChangeListener(this.groupAccumulatorPanel);
        }
        this.init();
    }

    @Override
    public GroupsManager getGroupsManager() {
        return this.groupsManager;
    }

    public void deregister() {
        AuthenticationProviderManager authMgr = ModelManager.getAuthenticationProviderManager(this.groupsManager.getConnection());
        if (authMgr != null) {
            authMgr.removeProvidersChangeListener(this.groupAccumulatorPanel);
        }
    }

    private void init() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add(this.groupAccumulatorPanel);
        layout.setConstraints(this.groupAccumulatorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        TitledBorder tBorder = new TitledBorder("Role Membership");
        this.setBorder(tBorder);
        this.repopulateGroupTable();
    }

    private void repopulateGroupTable() {
        this.groupAccumulatorPanel.repopulateTable(this.getPrincipalsForRole(this.roleDisplay));
    }

    private List getPrincipalsForRole(RoleDisplay roleDisplay) {
        ArrayList<MetaMatrixPrincipalName> groupPrincipals = new ArrayList<MetaMatrixPrincipalName>();
        Collection rolePrincipals = Collections.EMPTY_LIST;
        try {
            rolePrincipals = this.groupsManager.getPrincipalsForRole(roleDisplay.getName());
        }
        catch (AuthorizationException e) {
        }
        catch (ComponentNotFoundException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        for (MetaMatrixPrincipalName principalName : rolePrincipals) {
            if (principalName.getType() != 1) continue;
            groupPrincipals.add(principalName);
        }
        return groupPrincipals;
    }

    @Override
    public boolean removeConfirmed(Component callingPanel, Collection mmPrincipalNames) {
        this.removeRoleFromPrincipals(mmPrincipalNames);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoleFromPrincipals(Collection principalNames) {
        try {
            StaticUtilities.startWait(this);
            this.groupsManager.removePrincipalsFromRole(principalNames, this.roleDisplay.getName());
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Remove Role From Groups", e);
        }
        finally {
            StaticUtilities.endWait(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection addPressed(Component callingPanel) {
        try {
            StaticUtilities.startWait(this);
            Collection principalsHavingRole = this.groupsManager.getPrincipalsForRole(this.roleDisplay.getName());
            ArrayList<MetaMatrixPrincipalName> groupsHavingRole = new ArrayList<MetaMatrixPrincipalName>();
            for (MetaMatrixPrincipalName principalName : principalsHavingRole) {
                if (principalName.getType() != 1) continue;
                groupsHavingRole.add(principalName);
            }
            StaticUtilities.endWait(this);
            NewGroupsWizardController controller = new NewGroupsWizardController(this.groupsManager);
            List newGroups = controller.runWizard(groupsHavingRole);
            if (newGroups.size() > 0) {
                this.groupsManager.addPrincipalsToRole(newGroups, this.roleDisplay.getName());
                this.repopulateGroupTable();
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Assign Role to Groups", e);
        }
        finally {
            StaticUtilities.endWait(this);
        }
        return null;
    }
}

