/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.ui.util.StringListBasedListModel;
import com.metamatrix.console.ui.views.users.NotifyOnSelectionChange;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.toolbox.ui.widget.ListWidget;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RolesList
extends ListWidget
implements ListSelectionListener {
    private GroupsManager manager;
    private NotifyOnSelectionChange controller;
    private boolean ignoreValueChange = false;

    public RolesList(GroupsManager mgr, NotifyOnSelectionChange ctrlr, boolean makeSelection) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        this.manager = mgr;
        this.controller = ctrlr;
        this.init(makeSelection);
    }

    private void init(boolean makeSelection) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        String readRole;
        String displayName;
        Map roles = this.manager.getRoles();
        String[] roleNames = new String[roles.size()];
        Iterator it = roles.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            RoleDisplay roleDisplay = (RoleDisplay)me.getValue();
            roleNames[i] = roleDisplay.getDisplayName();
            ++i;
        }
        String[] sortedRoleNames = StaticQuickSorter.quickStringSort(roleNames);
        this.setModel(new StringListBasedListModel(sortedRoleNames, false));
        this.addListSelectionListener(this);
        this.getSelectionModel().setSelectionMode(0);
        if (makeSelection && (displayName = this.manager.getRoleDisplayName(readRole = "Admin.ReadOnlyAdmin")) != null) {
            int numElems = this.getModel().getSize();
            int i2 = 0;
            boolean found = false;
            while (!found && i2 < numElems) {
                String itemString = this.getModel().getElementAt(i2).toString();
                if (itemString.equals(displayName)) {
                    this.setSelectedIndex(i2);
                    found = true;
                    continue;
                }
                ++i2;
            }
        }
    }

    public void setIgnoreValueChange(boolean flag) {
        this.ignoreValueChange = flag;
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (!this.ignoreValueChange && !ev.getValueIsAdjusting()) {
            this.controller.selectionChanged(this, this);
        }
    }

    public void refreshData() {
        if (!this.ignoreValueChange) {
            this.controller.selectionChanged(this, this);
        }
    }
}

