/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BindingsAlreadyExistDlg
extends JDialog {
    private static final Color TEXT_BACKGROUND;
    private static final Color TEXT_FOREGROUND;
    private static final Font TEXT_FONT;
    private static final String HEADER;
    private static final String UPPER_TEXT;
    private static final String LOWER_TEXT;
    private static final String PROCEED;
    private static final String YES;
    private static final String CANCEL;
    private boolean canceling = false;

    public BindingsAlreadyExistDlg(Frame parent, String[] names) {
        super(parent);
        this.setTitle(HEADER);
        this.setModal(true);
        this.initialize(names);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                BindingsAlreadyExistDlg.this.cancelPressed();
            }
        });
    }

    public boolean proceeding() {
        return !this.canceling;
    }

    private void cancelPressed() {
        this.canceling = true;
        this.dispose();
    }

    private void yesPressed() {
        this.dispose();
    }

    private void initialize(String[] names) {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        JTextArea upperText = new JTextArea(UPPER_TEXT);
        upperText.setEditable(false);
        upperText.setLineWrap(true);
        upperText.setWrapStyleWord(true);
        upperText.setForeground(TEXT_FOREGROUND);
        upperText.setBackground(TEXT_BACKGROUND);
        upperText.setFont(TEXT_FONT);
        this.getContentPane().add(upperText);
        layout.setConstraints(upperText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JList<String> list = new JList<String>(names);
        list.setFont(TEXT_FONT);
        list.setBackground(TEXT_BACKGROUND);
        list.setForeground(TEXT_FOREGROUND);
        JScrollPane scrollPane = new JScrollPane(list);
        this.getContentPane().add(scrollPane);
        layout.setConstraints(scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JTextArea lowerText = new JTextArea(LOWER_TEXT);
        lowerText.setEditable(false);
        lowerText.setLineWrap(true);
        lowerText.setWrapStyleWord(true);
        lowerText.setForeground(TEXT_FOREGROUND);
        lowerText.setBackground(TEXT_BACKGROUND);
        lowerText.setFont(TEXT_FONT);
        this.getContentPane().add(lowerText);
        layout.setConstraints(lowerText, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JLabel proceedLabel = new JLabel(PROCEED);
        this.getContentPane().add(proceedLabel);
        layout.setConstraints(proceedLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 4, 6, 4), 0, 0));
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        ButtonWidget yesButton = new ButtonWidget(YES);
        yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BindingsAlreadyExistDlg.this.yesPressed();
            }
        });
        buttonsPanel.add(yesButton);
        ButtonWidget cancelButton = new ButtonWidget(CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BindingsAlreadyExistDlg.this.cancelPressed();
            }
        });
        buttonsPanel.add(cancelButton);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 10, 6), 0, 0));
        this.pack();
        Dimension oldSize = this.getSize();
        Dimension newSize = new Dimension(Math.max(oldSize.width, (int)((double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.4)), oldSize.height);
        this.setSize(newSize);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    static {
        JLabel dummyLabel = new JLabel();
        TEXT_BACKGROUND = dummyLabel.getBackground();
        TEXT_FOREGROUND = dummyLabel.getForeground();
        TEXT_FONT = dummyLabel.getFont();
        HEADER = ConsolePlugin.Util.getString("BindingsAlreadyExistDlg.header");
        UPPER_TEXT = ConsolePlugin.Util.getString("BindingsAlreadyExistDlg.alreadyExistText");
        LOWER_TEXT = ConsolePlugin.Util.getString("BindingsAlreadyExistDlg.oldUsed");
        PROCEED = ConsolePlugin.Util.getString("BindingsAlreadyExistDlg.proceed");
        YES = ConsolePlugin.Util.getString("General.Yes");
        CANCEL = ConsolePlugin.Util.getString("General.Cancel");
    }
}

