/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.console.ui.views.vdb.VDBConnectorBindingAssignmentModelTable;
import com.metamatrix.console.ui.views.vdb.VDBConnectorBindingNames;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;

class BindingsColRenderer
implements TableCellRenderer {
    private static final Color UNSELECTED_BUTTON_BACKGROUND = new ButtonWidget().getBackground();
    private JLabel label = new LabelWidget();
    private JButton button;

    public BindingsColRenderer() {
        this.label.setOpaque(true);
        this.button = new ButtonWidget();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object bindingsInfo, boolean isSelected, boolean hasFocus, int row, int col) {
        JComponent component;
        VDBConnectorBindingNames info = (VDBConnectorBindingNames)bindingsInfo;
        String labelText = VDBConnectorBindingAssignmentModelTable.getBindingsText(info);
        boolean editable = info.isMultiSource();
        if (editable) {
            Color background;
            MatteBorder border;
            if (isSelected) {
                border = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                background = table.getSelectionBackground();
            } else {
                border = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                background = UNSELECTED_BUTTON_BACKGROUND;
            }
            this.button.setBorder(border);
            this.button.setBackground(background);
            this.button.setText(labelText);
            component = this.button;
        } else {
            Color background = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.label.setBackground(background);
            this.label.setText(labelText);
            component = this.label;
        }
        return component;
    }
}

